/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.screen.obj.guidebook.obj;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.JSTheme;
import jp.jurassicsaga.client.base.screen.obj.guidebook.GuidebookPage;
import jp.jurassicsaga.client.base.screen.obj.guidebook.GuidebookScreen;
import jp.jurassicsaga.client.base.screen.obj.guidebook.obj.JournalSubPage;
import jp.jurassicsaga.client.base.screen.obj.widget.NoClickHoverClickButton;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diet;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5348;

public class JournalPage
extends GuidebookPage {
    private JournalSubPage currentSubPage;
    private final ArrayList<JSAnimal<?>> animals = JSAnimals.getAnimals();
    private int currentPageId = 0;
    private List<class_1799> stacks = null;
    private int scrollOffset = 0;
    private int scrollTicker = 0;

    public JournalPage(GuidebookScreen holder) {
        super(holder);
    }

    @Override
    public void init() {
        int i = this.holder.field_22789 / 2;
        int j = this.holder.field_22790 / 2;
        this.holder.addButton((class_339)new NoClickHoverClickButton(i - 8 + 148, j - 8 + 105, 25, 12, (class_2561)class_2561.method_43473(), press -> {
            int size;
            if (this.currentSubPage != null) {
                this.currentSubPage = null;
            }
            this.currentPageId = (size = this.animals.stream().filter(jsAnimal -> jsAnimal.getAnimalAttributes().getMiscProperties().isShowInGuidebook()).toList().size()) < this.currentPageId + 1 ? 0 : ++this.currentPageId;
            this.holder.method_25426();
        }, JSCommon.createId("container/guidebook/arrow_right_hover" + (this.theme == JSTheme.JP ? "_jp" : "")), JSCommon.createId("container/guidebook/arrow_right" + (this.theme == JSTheme.JP ? "_jp" : ""))));
        this.holder.addButton((class_339)new NoClickHoverClickButton(i - 8 - 157, j - 8 + 105, 25, 12, (class_2561)class_2561.method_43473(), press -> {
            if (this.currentSubPage != null) {
                this.currentSubPage = null;
            }
            int size = this.animals.stream().filter(jsAnimal -> jsAnimal.getAnimalAttributes().getMiscProperties().isShowInGuidebook()).toList().size();
            this.currentPageId = this.currentPageId - 1 < 0 ? size - 1 : --this.currentPageId;
            this.holder.method_25426();
        }, JSCommon.createId("container/guidebook/arrow_left_hover" + (this.theme == JSTheme.JP ? "_jp" : "")), JSCommon.createId("container/guidebook/arrow_left" + (this.theme == JSTheme.JP ? "_jp" : ""))));
        if (this.currentSubPage != null) {
            this.currentSubPage.init();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.currentPageId != 0 && this.stacks != null) {
            this.tickHorizontalScrolling();
        }
    }

    private void tickHorizontalScrolling() {
        int cols = 8;
        int rows = 3;
        int visibleCount = cols * rows;
        int maxOffset = Math.max(0, this.stacks.size() - visibleCount);
        ++this.scrollTicker;
        if (this.scrollTicker > 20) {
            this.scrollTicker = 0;
            ++this.scrollOffset;
            if (this.scrollOffset > maxOffset) {
                this.scrollOffset = 0;
            }
        }
    }

    @Override
    public void render(int i, int j, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.currentPageId == 0) {
            class_327 font = this.holder.getFont();
            guiGraphics.method_27535(font, (class_2561)class_2561.method_43471((String)"guidebook.jurassicsaga.page_home"), i - 153, j - 102, 6980223);
            guiGraphics.method_51440(font, (class_5348)class_2561.method_43471((String)"guidebook.jurassicsaga.home"), i - 155, j - 80, 142, 6980223);
        } else {
            if (this.currentSubPage == null) {
                if (this.currentPageId > this.animals.size()) {
                    this.currentPageId = 0;
                } else if (this.currentPageId < 0) {
                    this.currentPageId = 0;
                }
                JSAnimal animal = this.animals.stream().filter(jsAnimal -> jsAnimal.getAnimalAttributes().getMiscProperties().isShowInGuidebook()).toList().get(this.currentPageId - 1);
                this.currentSubPage = new JournalSubPage(this.holder, animal);
                Supplier<Diet> dietSupplier = animal.getAnimalAttributes().getMetabolismProperties().getDietSupplier();
                if (dietSupplier != Diets.EMPTY) {
                    Diet diet = dietSupplier.get();
                    this.stacks = diet.getAllItems().stream().sorted(Comparator.comparing(item -> item.method_7909().method_7864(item).getString())).toList();
                } else {
                    this.stacks = null;
                }
                this.init();
            }
            this.currentSubPage.render(i, j, guiGraphics, mouseX, mouseY, partialTick);
            if (this.stacks != null) {
                guiGraphics.method_27535(this.holder.getFont(), (class_2561)class_2561.method_43471((String)"guidebook.jurassicsaga.edible_items"), i + 21, j + 35, 6980223);
                this.renderWrappedItems(guiGraphics, i + 20, j + 45, mouseX, mouseY);
            }
        }
    }

    private void renderWrappedItems(class_332 guiGraphics, int startX, int startY, int mouseX, int mouseY) {
        int itemSize = 16;
        int cols = 8;
        int rows = 3;
        int visibleCount = cols * rows;
        int maxOffset = Math.max(0, this.stacks.size() - visibleCount);
        if (this.scrollOffset > maxOffset) {
            this.scrollOffset = maxOffset;
        }
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int index = this.scrollOffset + col + row * cols;
                if (index >= this.stacks.size()) {
                    return;
                }
                int x = startX + col * itemSize;
                int y = startY + row * itemSize;
                class_1799 stack = this.stacks.get(index);
                guiGraphics.method_51427(stack, x, y);
                guiGraphics.method_51431(this.holder.getFont(), stack, x, y);
                if (mouseX < x || mouseX >= x + itemSize || mouseY < y || mouseY >= y + itemSize) continue;
                guiGraphics.method_51446(this.holder.getFont(), stack, mouseX, mouseY);
            }
        }
    }
}

