/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.animals.VisitorAnimal;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.v1.animal.JSV1Animals;
import jp.jurassicsaga.server.v2.animal.JSV2Animals;
import jp.jurassicsaga.server.v4.animal.JSV4Animals;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.TravelersAnimalRegistry;

public class JSAnimals {
    public static VisitorAnimal visitorAnimal;
    private static final HashMap<Era, ArrayList<JSAnimal<?>>> animalMap;
    private static ArrayList<JSAnimal<?>> animals;

    public static void init() {
        visitorAnimal = new VisitorAnimal();
        JSV1Animals.init();
        JSV2Animals.init();
        if (!JSCommon.config.experimentalFeatures) {
            return;
        }
        JSV4Animals.init();
    }

    public static JSAnimal<?> getAnimal(String animalName) {
        for (TravelersAnimal travelersAnimal : JSAnimals.getAnimals()) {
            JSAnimal jsAnimal;
            if (!(travelersAnimal instanceof JSAnimal) || !(jsAnimal = (JSAnimal)travelersAnimal).getAnimalAttributes().getAnimalName().equalsIgnoreCase(animalName.contains(":") ? animalName.split(":")[1] : animalName)) continue;
            return jsAnimal;
        }
        return null;
    }

    public static ArrayList<JSAnimal<?>> getAnimals() {
        if (animals != null && !animals.isEmpty()) {
            return animals;
        }
        ArrayList newAnimalList = new ArrayList();
        TravelersAnimalRegistry.getANIMALS().forEach((string, travelersAnimals) -> {
            for (TravelersAnimal travelersAnimal : travelersAnimals) {
                if (!(travelersAnimal instanceof JSAnimal)) continue;
                JSAnimal jsAnimal = (JSAnimal)travelersAnimal;
                newAnimalList.add(jsAnimal);
            }
        });
        animals = newAnimalList;
        animals.sort(Comparator.comparing(jsAnimal -> jsAnimal.getAnimalAttributes().getAnimalName()));
        return newAnimalList;
    }

    public static boolean hasEra(Era era) {
        return animalMap.containsKey((Object)era);
    }

    public static void setEraEnabled(Era era, JSAnimal<?> animal) {
        if (!animalMap.containsKey((Object)era)) {
            animalMap.put(era, new ArrayList());
        }
        ArrayList<JSAnimal<?>> jsAnimals = animalMap.get((Object)era);
        jsAnimals.add(animal);
        jsAnimals.sort(Comparator.comparing(jsAnimal -> jsAnimal.getAnimalAttributes().getAnimalName()));
        animalMap.put(era, jsAnimals);
    }

    public static HashMap<Era, ArrayList<JSAnimal<?>>> getAnimalMap() {
        return animalMap;
    }

    static {
        animalMap = new HashMap();
    }
}

