/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.animals;

import java.util.HashMap;
import travelers.server.animal.obj.animation.PlayBehaviourType;
import travelers.server.animal.obj.animation.TravelersAnimationControllers;
import travelers.server.animal.obj.animation.TravelersAnimationDefinition;

public class JSAnimations {
    private static final HashMap<String, TravelersAnimationDefinition> ANIMATION_MAP = new HashMap();
    public static final TravelersAnimationControllers.AnimationController swayController = TravelersAnimationControllers.register((String)"sway_controller", (int)10);
    public static final TravelersAnimationControllers.AnimationController base_controller = TravelersAnimationControllers.register((String)"base_controller", (int)10);
    public static final TravelersAnimationControllers.AnimationController damageController = TravelersAnimationControllers.register((String)"damage_controller", (int)10);
    public static final TravelersAnimationDefinition IDLE = JSAnimations.loop(base_controller, "animation.idle");
    public static final TravelersAnimationDefinition IDLE_HIDDEN = JSAnimations.loop(base_controller, "animation.idle_hidden");
    public static final TravelersAnimationDefinition IDLE_IN_WATER = JSAnimations.loop(base_controller, "animation.idle_in_water");
    public static final TravelersAnimationDefinition IDLE_WALL = JSAnimations.loop("animation.on_wall");
    public static final TravelersAnimationDefinition IDLE_ROOF = JSAnimations.loop("animation.on_roof");
    public static final TravelersAnimationDefinition IDLE_WING_MOVE = JSAnimations.play(base_controller, "animation.idle_wing_move");
    public static final TravelersAnimationDefinition IDLE_FLAP = JSAnimations.play("animation.idle_flap");
    public static final TravelersAnimationDefinition IDLE_DISPLAY = JSAnimations.play("animation.idle_display");
    public static final TravelersAnimationDefinition IDLE_CALL = JSAnimations.play("animation.idle_call");
    public static final TravelersAnimationDefinition REST_IN = JSAnimations.play(base_controller, "animation.rest_in").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition REST_LOOP = JSAnimations.loop(base_controller, "animation.rest_loop").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition REST_OUT = JSAnimations.play(base_controller, "animation.rest_out").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition SLEEP_IN = JSAnimations.play(base_controller, "animation.sleep_in").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition SLEEP_LOOP = JSAnimations.loop(base_controller, "animation.sleep_loop").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition SLEEP_OUT = JSAnimations.play(base_controller, "animation.sleep_out").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition SLEEPING = JSAnimations.loop(base_controller, "animation.sleeping").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition WALK = JSAnimations.loop(base_controller, "animation.walk");
    public static final TravelersAnimationDefinition RUN = JSAnimations.loop(base_controller, "animation.run");
    public static final TravelersAnimationDefinition CRAWL = JSAnimations.loop(base_controller, "animation.crawl");
    public static final TravelersAnimationDefinition SWIM = JSAnimations.loop(base_controller, "animation.swim");
    public static final TravelersAnimationDefinition SWIM_NEAR_SURFACE = JSAnimations.loop(base_controller, "animation.swim_near_surface");
    public static final TravelersAnimationDefinition SWIM_FAST = JSAnimations.loop(base_controller, "animation.swim_fast");
    public static final TravelersAnimationDefinition BEACHED = JSAnimations.loop(base_controller, "animation.beached").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition WALK_BEACHED = JSAnimations.loop(base_controller, "animation.walk_beached").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition FLYING = JSAnimations.loop(base_controller, "animation.fly");
    public static final TravelersAnimationDefinition GLIDE = JSAnimations.loop(base_controller, "animation.glide");
    public static final TravelersAnimationDefinition HOVER = JSAnimations.loop(base_controller, "animation.hover");
    public static final TravelersAnimationDefinition STALK = JSAnimations.loop(base_controller, "animation.stalk");
    public static final TravelersAnimationDefinition FLOP = JSAnimations.loop(base_controller, "animation.flop");
    public static final TravelersAnimationDefinition JUMP_START = JSAnimations.play(base_controller, "animation.jump_start").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition JUMP_LOOP = JSAnimations.loop(base_controller, "animation.jump_loop").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition JUMP = JSAnimations.loop(base_controller, "animation.jump");
    public static final TravelersAnimationDefinition JUMP_END = JSAnimations.play(base_controller, "animation.jump_end").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition FALL = JSAnimations.play(base_controller, "animation.fall_start").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition FALL_LOOP = JSAnimations.loop(base_controller, "animation.fall_loop").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition FALL_END = JSAnimations.play(base_controller, "animation.fall_end").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition ATTACK = JSAnimations.play(damageController, "animation.attack");
    public static final TravelersAnimationDefinition FLY_ATTACK = JSAnimations.play(damageController, "animation.fly_attack");
    public static final TravelersAnimationDefinition INJURED = JSAnimations.play(damageController, "animation.injured");
    public static final TravelersAnimationDefinition ON_LAND_INJURED = JSAnimations.play("animation.injured_on_land");
    public static final TravelersAnimationDefinition DEATH = JSAnimations.hold(base_controller, "animation.death").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition ON_LAND_DEATH = JSAnimations.hold("animation.death_on_land").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition ROAR = JSAnimations.play(base_controller, "animation.roar").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition ROAR_1 = JSAnimations.play(base_controller, "animation.roar1").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition ROAR_2 = JSAnimations.play(base_controller, "animation.roar2").disableLook().disablePhysics();
    public static final TravelersAnimationDefinition DIVE_IN = JSAnimations.play(base_controller, "animation.dive_bomber_in");
    public static final TravelersAnimationDefinition DIVE = JSAnimations.loop(base_controller, "animation.dive_bomber_loop");
    public static final TravelersAnimationDefinition DIVE_OUT = JSAnimations.play(base_controller, "animation.dive_bomber_out");
    public static final TravelersAnimationDefinition SWAY_LEFT = JSAnimations.loop(swayController, "animation.sway_left");
    public static final TravelersAnimationDefinition SWAY_RIGHT = JSAnimations.loop(swayController, "animation.sway_right");
    public static final TravelersAnimationDefinition FRILL_OUT = JSAnimations.play(base_controller, "animation.frill_out");
    public static final TravelersAnimationDefinition FRILL_SHAKE = JSAnimations.play(base_controller, "animation.frill_shake");
    public static final TravelersAnimationDefinition FRILL_IN = JSAnimations.play(base_controller, "animation.frill_in");
    public static final TravelersAnimationDefinition EAT = JSAnimations.play(base_controller, "animation.eat");
    public static final TravelersAnimationDefinition EAT_LOW = JSAnimations.play(base_controller, "animation.eat_low");
    public static final TravelersAnimationDefinition DRINK = JSAnimations.play(base_controller, "animation.drink");
    public static final TravelersAnimationDefinition DROWN = JSAnimations.loop(base_controller, "animation.drown");
    public static final TravelersAnimationDefinition FLIP_UP = JSAnimations.play(base_controller, "animation.flip_up");
    public static final TravelersAnimationDefinition FLIP_LOOP = JSAnimations.loop(base_controller, "animation.flip_loop");
    public static final TravelersAnimationDefinition FLIP_DOWN = JSAnimations.play(base_controller, "animation.flip_down");
    public static final TravelersAnimationDefinition SPASM = JSAnimations.play(base_controller, "animation.spasm");
    public static final TravelersAnimationDefinition OPEN = JSAnimations.play("animation.open");
    public static final TravelersAnimationDefinition OPENED = JSAnimations.hold("animation.opened");
    public static final TravelersAnimationDefinition OPEN_HOLD = JSAnimations.hold("animation.open");
    public static final TravelersAnimationDefinition CLOSE = JSAnimations.play("animation.close");
    public static final TravelersAnimationDefinition CLOSED = JSAnimations.hold("animation.closed");
    public static final TravelersAnimationDefinition VEHICLE_OPEN_DOOR_LEFT = JSAnimations.play("animation.open_door_left");
    public static final TravelersAnimationDefinition VEHICLE_OPENED_DOOR_LEFT = JSAnimations.loop("animation.opened_door_left");
    public static final TravelersAnimationDefinition VEHICLE_CLOSE_DOOR_LEFT = JSAnimations.play("animation.close_door_left");
    public static final TravelersAnimationDefinition VEHICLE_OPEN_DOOR_RIGHT = JSAnimations.play("animation.open_door_right");
    public static final TravelersAnimationDefinition VEHICLE_OPENED_DOOR_RIGHT = JSAnimations.loop("animation.opened_door_right");
    public static final TravelersAnimationDefinition VEHICLE_CLOSE_DOOR_RIGHT = JSAnimations.play("animation.close_door_right");
    public static final TravelersAnimationDefinition VEHICLE_INFLATED = JSAnimations.play("animation.inflated");
    public static final TravelersAnimationDefinition VEHICLE_DEFLATED = JSAnimations.play("animation.deflated");
    public static final TravelersAnimationDefinition VEHICLE_INFLATE = JSAnimations.play("animation.inflate");
    public static final TravelersAnimationDefinition VEHICLE_DEFLATE = JSAnimations.play("animation.deflate");
    public static final TravelersAnimationDefinition GUIDEBOOK_POSE = JSAnimations.hold("animation.guidebook_pose");
    public static final TravelersAnimationDefinition GUIDEBOOK_POSE_BABY = JSAnimations.hold("animation.guidebook_baby_pose");

    public static TravelersAnimationDefinition loop(String name) {
        TravelersAnimationDefinition value = new TravelersAnimationDefinition(name, PlayBehaviourType.LOOP, 10);
        ANIMATION_MAP.put(name, value);
        return value;
    }

    public static TravelersAnimationDefinition loop(TravelersAnimationControllers.AnimationController controller, String name) {
        TravelersAnimationDefinition value = new TravelersAnimationDefinition(name, controller, PlayBehaviourType.LOOP);
        ANIMATION_MAP.put(name, value);
        return value;
    }

    public static TravelersAnimationDefinition play(String name) {
        TravelersAnimationDefinition value = new TravelersAnimationDefinition(name, PlayBehaviourType.PLAY_ONCE, 10);
        ANIMATION_MAP.put(name, value);
        return value;
    }

    public static TravelersAnimationDefinition play(TravelersAnimationControllers.AnimationController controller, String name) {
        TravelersAnimationDefinition value = new TravelersAnimationDefinition(name, controller, PlayBehaviourType.PLAY_ONCE);
        ANIMATION_MAP.put(name, value);
        return value;
    }

    public static TravelersAnimationDefinition hold(String name) {
        TravelersAnimationDefinition value = new TravelersAnimationDefinition(name, PlayBehaviourType.HOLD, 10);
        ANIMATION_MAP.put(name, value);
        return value;
    }

    public static TravelersAnimationDefinition hold(TravelersAnimationControllers.AnimationController controller, String name) {
        TravelersAnimationDefinition value = new TravelersAnimationDefinition(name, controller, PlayBehaviourType.HOLD);
        ANIMATION_MAP.put(name, value);
        return value;
    }

    public static TravelersAnimationDefinition getAnimation(String name) {
        return ANIMATION_MAP.get(name);
    }
}

