/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.bases;

import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Map;
import jp.jurassicsaga.JSConstants;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSModuleHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGroundNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSLookControl;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.entity.obj.other.IJSLeapingEntity;
import jp.jurassicsaga.server.base.entity.obj.other.SeatEntity;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_8111;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersMain;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.obj.TravelersAnimalAttributes;
import travelers.server.packet.obj.TravelersShakeCamera;
import travelers.util.helper.TravelersPacketDistributor;

public class JSAnimalBase
extends JSEntityDataHolder {
    private final Map<class_1309, Integer> blacklist = new HashMap<class_1309, Integer>();

    public JSAnimalBase(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
        this.setPathfindingMalus(TravelersPathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(TravelersPathType.DAMAGE_FIRE, -1.0f);
        this.moveController = new TravelersMoveControl((SmartAnimalBase)this, this.getAnimal());
        this.field_6206 = new JSLookControl(this);
        this.field_5985 = true;
        this.createModuleHolder();
        if (this.modules != null) {
            this.modules.init();
        }
        if (TravelersMain.isDebugging()) {
            JSConstants.LOG.warn("Added {} to the world.", (Object)this.getAnimal().getAnimalAttributes().getAnimalName());
        }
    }

    public int method_5970() {
        return 120;
    }

    public boolean method_5974(double distance) {
        return false;
    }

    public boolean method_6109() {
        if (this.getModules() == null) {
            return true;
        }
        return this.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.BABY;
    }

    public boolean isStalking() {
        return !this.isDead() && (Boolean)this.field_6011.method_12789(stalking) != false;
    }

    public void onGrowthStageChange(AnimalGrowthStage newStage) {
        if (this.method_37908().field_9236) {
            return;
        }
    }

    public void method_6005(double strength, double x, double z) {
        if (this.isDead()) {
            return;
        }
        super.method_6005(strength, x, z);
    }

    public boolean method_6101() {
        return false;
    }

    public boolean method_5747(float fallDistance, float multiplier, @NotNull class_1282 source) {
        if ((double)fallDistance > this.jumpHeight() * 2.0) {
            return super.method_5747(fallDistance, multiplier, source);
        }
        return false;
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        if ((double)fallDistance > this.jumpHeight() * 2.0) {
            return super.method_23329(fallDistance, damageMultiplier);
        }
        return 0;
    }

    public double method_23320() {
        return super.method_23320();
    }

    protected void createModuleHolder() {
        this.modules = new JSModuleHolder(this);
    }

    public JSAnimal<?> getAnimal() {
        return (JSAnimal)super.getAnimal();
    }

    public float getRenderScale() {
        return this.getModules().getGrowthStageModule().getSize();
    }

    @NotNull
    protected class_238 method_33332() {
        TravelersAnimal a = this.getAnimal();
        if (a == null || !this.method_37908().method_8477(this.method_24515())) {
            return this.method_55694(this.method_18376()).method_30757(this.method_19538());
        }
        return this.getModules().getGrowthStageModule().makeBoundingBox((JSAnimal<?>)a);
    }

    @NotNull
    protected class_4048 method_55694(@NotNull class_4050 pose) {
        if (this.getModules() != null && this.getModules().getGrowthStageModule().getDimensions() != null) {
            return this.getModules().getGrowthStageModule().getDimensions();
        }
        return super.method_55694(pose);
    }

    @Nullable
    public class_1799 method_31480() {
        class_1799 stack = ((class_1792)this.getAnimal().getItems().getSpawnEgg().get()).method_7854();
        JSGeneData data = JSGeneUtil.fromCompound((class_2487)this.method_5841().method_12789(geneData));
        stack = JSGeneUtil.writeToStack(stack, data);
        return stack;
    }

    @Override
    public boolean method_5643(@NotNull class_1282 source, float amount) {
        if (source == this.method_48923().method_48822()) {
            this.setLeaping(false);
        }
        this.curInjuredTicks = 4;
        boolean wasHurt = super.method_5643(source, amount);
        if (amount > 0.0f) {
            if (source.method_49708(class_8111.field_42341)) {
                return false;
            }
            this.handleCorpseHit(source, wasHurt, amount);
            this.getModules().getMetabolismModule().interrupt(10);
        }
        for (JSGene jsGene : this.getModules().getGeneticModule().getGeneData().geneDataHolder.getGENE_SET()) {
            jsGene.onHitBy(this, this.method_6065(), source, amount);
        }
        return wasHurt;
    }

    private void handleCorpseHit(@NotNull class_1282 source, boolean wasHurt, float amount) {
        if (!this.isDead()) {
            return;
        }
        if (amount <= 0.0f) {
            return;
        }
        TravelersAnimalAttributes animalAttributes = this.getAnimal().getAnimalAttributes();
        if (!(source.method_5526() instanceof class_3222 || source.method_5529() instanceof class_3222 || source.method_49708(class_8111.field_42320))) {
            return;
        }
        if (!(wasHurt && animalAttributes.getItemProperties().isHasDrops() && animalAttributes.getMiscProperties().isShouldCorpseDropItems())) {
            return;
        }
        float maxHealth = (float)this.getScaledMaxHealth();
        int totalExpectedDrops = (int)Math.max(1.0f, maxHealth / 8.0f);
        int dropsToSpawn = Math.max(1, totalExpectedDrops - this.corpseDropCount);
        if (dropsToSpawn > this.corpseDropCount) {
            if (this.corpseDropCount == 0) {
                Supplier<class_1792> item = this.getAnimal().getItems().getFossil_remains();
                if (animalAttributes.getItemProperties().isHasFossil() && item != null) {
                    this.method_5775(new class_1799((class_1935)item.get(), 1));
                } else if (animalAttributes.getItemProperties().isHasMeat() & item != null) {
                    this.method_5775(new class_1799((class_1935)item.get(), 1));
                }
            }
            int i = 0;
            while ((float)i < amount) {
                if (this.field_5974.method_43057() < 0.2f && this.corpseDropCount != 0) {
                    item = this.getAnimal().getItems().getFossil_remains();
                    if (animalAttributes.getItemProperties().isHasFossil() && item != null) {
                        this.method_5775(new class_1799((class_1935)item.get(), 1));
                    } else if (animalAttributes.getItemProperties().isHasMeat() & item != null) {
                        this.method_5775(new class_1799((class_1935)item.get(), 1));
                    }
                } else {
                    item = this.getAnimal().getItems().getRawMeat();
                    if (animalAttributes.getItemProperties().isHasMeat() & item != null) {
                        this.method_5775(new class_1799((class_1935)item.get(), 1));
                    }
                }
                ++this.corpseDropCount;
                if (this.corpseDropCount >= dropsToSpawn) break;
                ++i;
            }
        }
    }

    protected void method_6108() {
        if (this.isDead() || this.shouldDieInstantly()) {
            if (this.shouldDieInstantly() && this.getAnimal().getAnimalAttributes().getItemProperties().isHasDrops()) {
                if (this.getAnimal().getAnimalAttributes().getItemProperties().isHasMeat() && this.field_5974.method_43057() < 0.6f) {
                    this.method_5775(new class_1799((class_1935)this.getAnimal().getItems().getRawMeat().get(), this.field_5974.method_43048(4) + 1));
                }
                if (this.getAnimal().getAnimalAttributes().getMiscProperties().isExtinct() && this.field_5974.method_43057() < 0.6f) {
                    this.method_5775(new class_1799((class_1935)this.getAnimal().getItems().getFossil_remains().get(), this.field_5974.method_43048(4) + 1));
                }
            }
            if (!this.method_37908().method_8608() && !this.method_31481()) {
                this.method_37908().method_8421((class_1297)this, (byte)60);
                this.method_5650(class_1297.class_5529.field_26998);
            }
            return;
        }
        this.method_31482();
        this.setDead(true);
        this.method_6033((float)this.getScaledMaxHealth());
        this.method_55695();
        this.field_6189.method_6340();
        this.navigationController.stop();
        this.field_6201.method_35115().clear();
    }

    public boolean shouldDieInstantly() {
        return false;
    }

    protected float method_6107() {
        return this.isDead() || this.method_6113() || this.isStalking() ? 0.0f : Math.max(1.0f, this.getRenderScale());
    }

    public void method_5697(class_1297 entity) {
        double otherPoints;
        double hitboxPoints = this.method_17681() + this.method_17682();
        if (hitboxPoints - (otherPoints = (double)(entity.method_17682() + entity.method_17681())) < -1.0) {
            return;
        }
        super.method_5697(entity);
    }

    public void setExtraStat(class_6880<class_1320> stat, double i) {
        if (this.statMap == null) {
            this.statMap = new HashMap();
        }
        if (this.statMap.containsKey(stat)) {
            this.statMap.put(stat, (Double)this.statMap.get(stat) + i);
        } else {
            this.statMap.put(stat, i);
        }
    }

    public void removeFromStat(class_6880<class_1320> stat, double i) {
        if (this.statMap == null) {
            this.statMap = new HashMap();
        }
        if (this.statMap.containsKey(stat)) {
            double count = Math.max(0.0, (Double)this.statMap.get(stat) - i);
            if (count > 0.0) {
                this.statMap.put(stat, count);
            } else {
                this.statMap.remove(stat);
            }
        }
    }

    public double method_45325(@NotNull class_6880<class_1320> attribute) {
        double stats;
        double d = stats = this.statMap != null ? this.statMap.getOrDefault(attribute, 0.0) : 0.0;
        if (this.getModules() == null) {
            return super.method_45325(attribute);
        }
        if (attribute.method_55838(class_5134.field_23716)) {
            return this.getScaledMaxHealth() + stats;
        }
        if (attribute.method_55838(class_5134.field_23722)) {
            double val = super.method_45325(attribute);
            float scale = this.getModules().getGrowthStageModule().getPercentage();
            return class_3532.method_16436((double)scale, (double)(val / 4.0), (double)val) + stats;
        }
        if (attribute.method_55838(class_5134.field_23721) || attribute.method_55838(class_5134.field_23724) || attribute.method_55838(class_5134.field_23725) || attribute.method_55838(class_5134.field_23719)) {
            float scale = this.getModules().getGrowthStageModule().getPercentage();
            double max = super.method_45325(attribute) + stats;
            return class_3532.method_16436((double)scale, (double)(max / 4.0), (double)max);
        }
        return super.method_45325(attribute) + stats;
    }

    private double getScaledMaxHealth() {
        if (this.getAnimal() == null) {
            return super.method_45325(class_5134.field_23716);
        }
        double maxHealth = this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getMaxHealth();
        float scale = this.getModules().getGrowthStageModule().getPercentage();
        if (scale == 0.0f || scale == 1.0f) {
            return maxHealth;
        }
        return class_3532.method_16436((double)scale, (double)Math.min(5.0, maxHealth / 15.0), (double)maxHealth);
    }

    protected float method_6106() {
        TravelersPath path;
        if (this.method_5799()) {
            return this.method_56994(1.0f);
        }
        if (this.jumpHeight() > 1.0 && (path = this.getNavigationController().getPath()) != null && !path.isDone() && path.getNextNodeIndex() < path.getNodeCount()) {
            TravelersNode nextNode = path.getNextNode();
            if ((double)nextNode.y > this.method_23318()) {
                double diff = (double)nextNode.y - this.method_23318();
                return this.method_56994((float)((double)1.2f + diff / 3.0));
            }
        }
        return this.method_5799() ? this.method_56994(1.0f) : this.method_56994(2.35f);
    }

    public void method_6043() {
        float f = this.method_6106();
        if (!(f <= 1.0E-5f)) {
            class_243 vec3 = this.method_18798();
            this.method_18800(vec3.field_1352, f, vec3.field_1350);
            if (this.method_5624()) {
                float f1 = this.method_36454() * ((float)Math.PI / 180);
                this.method_45319(new class_243((double)(-class_3532.method_15374((float)f1)) * 0.2, 0.0, (double)class_3532.method_15362((float)f1) * 0.2));
            }
            this.field_6007 = true;
            JSAnimalBase jSAnimalBase = this;
            if (jSAnimalBase instanceof IJSLeapingEntity) {
                IJSLeapingEntity leapingEntity = (IJSLeapingEntity)((Object)jSAnimalBase);
                leapingEntity.onLeap();
            }
        }
    }

    @NotNull
    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28633;
    }

    public void method_5773() {
        if (this.getAnimal() != null && this.firstTick) {
            this.method_5857(this.method_33332());
            this.firstTick = false;
        } else if (this.isStaticCreature) {
            return;
        }
        if (this.method_37908().field_9236) {
            this.modules.clientTick();
        }
        if (this.curInjuredTicks-- > 0) {
            --this.curInjuredTicks;
        }
        if (this.curAttackTicks > 0) {
            --this.curAttackTicks;
        }
        if (this.curCallingTicks > 0) {
            --this.curCallingTicks;
            if (this.curCallingTicks == 10) {
                this.callSounds();
            }
        }
        if (this.curEatTicks > 0) {
            --this.curEatTicks;
        }
        if (this.curDrinkTicks > 0) {
            --this.curDrinkTicks;
        }
        if (this.curSleepInteruptions > 0) {
            --this.curSleepInteruptions;
        }
        if (((Boolean)this.field_6011.method_12789(refreshData)).booleanValue()) {
            this.field_6011.method_12778(refreshData, (Object)false);
        }
        this.modules.tick();
        super.method_5773();
    }

    public void method_6007() {
        class_1309 target;
        if (this.isStaticCreature && !this.firstTick) {
            return;
        }
        super.method_6007();
        if (this.method_5968() != null && (target = this.method_5968()).method_31481()) {
            this.method_5980(null);
        }
        this.modules.aiStep();
    }

    public float getTurnMultiplier() {
        return 5000.0f;
    }

    @Override
    protected void method_5958() {
        TravelersNode nextPos;
        TravelersPath path;
        if (this.isStaticCreature) {
            return;
        }
        this.getAnimal().animateServer(this, this.moveAnalysis, this.getAnimationModule());
        super.method_5958();
        if (this.isDead()) {
            return;
        }
        if ((double)this.method_6032() < this.getScaledMaxHealth() && this.field_6012 % 20 == 0 && this.field_5974.method_43057() > 0.9f) {
            this.method_6033((float)Math.min(this.getScaledMaxHealth(), (double)(this.method_6032() + this.regenHealth)));
        }
        this.tickBlacklist(this.method_37908());
        if (this.method_6113() || this.isResting()) {
            if (this.method_6065() != null) {
                this.getModules().getMetabolismModule().interrupt(500);
            }
            if (this.isMoving() && this.curSleepInteruptions > 100) {
                this.getModules().getMetabolismModule().interrupt(500);
            } else {
                this.curSleepInteruptions += 10;
            }
        }
        class_1309 target = this.method_5968();
        boolean isClose = false;
        if (target != null && this.method_5739((class_1297)target) < this.method_17681() * this.method_17681() * 3.0f) {
            double dx = target.method_23317() - this.method_23317();
            double dz = target.method_23321() - this.method_23321();
            double dy = target.method_23320() - this.method_23320();
            float headYaw = (float)(class_3532.method_15349((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            float headPitch = Math.clamp((float)(-(class_3532.method_15349((double)dy, (double)Math.sqrt(dx * dx + dz * dz)) * 57.29577951308232)), -20.0f, 20.0f);
            this.method_5847(headYaw);
            this.method_36457(headPitch);
            isClose = true;
        }
        if (!isClose && (path = this.getNavigationController().getPath()) != null && this.navigationController.isInProgress() && (nextPos = path.getNextNode()) != null) {
            class_2338 pos = nextPos.asBlockPos();
            double dx = (double)pos.method_10263() - this.method_23317();
            double dz = (double)pos.method_10260() - this.method_23321();
            float headYaw = (float)(class_3532.method_15349((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            this.method_5847(headYaw);
            this.method_36457(0.0f);
        }
        if (!this.isMoving() && this.shouldSleep() && !this.method_6113() && this.canSleep()) {
            this.setSleeping(true);
        }
        if (this.method_6113() && !this.shouldSleep()) {
            this.setSleeping(false);
        }
        this.modules.serverAiStep();
        if (this.attackDelay > 0) {
            --this.attackDelay;
            if (this.attackDelay == 10) {
                JSAnimalBase base;
                if (this.method_5739((class_1297)this.pendingTarget) > this.getAttackReach() * 3.0f) {
                    return;
                }
                if (this.isDead()) {
                    return;
                }
                this.actuallyAttack(this.pendingTarget);
                class_1309 class_13092 = this.pendingTarget;
                if (class_13092 instanceof JSAnimalBase && (base = (JSAnimalBase)class_13092).isDead()) {
                    this.getModules().getMetabolismModule().eatCorpse(base);
                }
            }
            if (this.attackDelay == 0 && this.pendingTarget != null) {
                this.pendingTarget = null;
                this.attackDelay = -1;
            }
        }
        if (this.isLeaping()) {
            class_243 forward = this.method_5720().method_1029().method_1021(0.02);
            this.method_18799(this.method_18798().method_1019(forward));
        }
    }

    private boolean canSleep() {
        if (this.isDead()) {
            return false;
        }
        if (this.getNavigationController().isInProgress()) {
            return false;
        }
        if (this.modules.getMetabolismModule().isInterrupted()) {
            return false;
        }
        if (!this.method_24828()) {
            return false;
        }
        return !this.method_5799();
    }

    protected void actuallyAttack(class_1309 pendingTarget) {
        SeatEntity e;
        class_1297 vehicle;
        if (pendingTarget.method_5765() && (vehicle = pendingTarget.method_5854()) instanceof SeatEntity && (e = (SeatEntity)vehicle).getJsVehicle() != null) {
            this.method_6121(e.getJsVehicle());
            return;
        }
        this.method_6121((class_1297)pendingTarget);
    }

    public boolean method_5810() {
        return !this.isDead();
    }

    public boolean method_31746() {
        return !this.isStaticCreature;
    }

    @NotNull
    protected class_1269 method_5992(class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        if (this.canEatFromPlayer(player, hand)) {
            this.onEatFromPlayer(player, hand, itemstack);
        }
        return super.method_5992(player, hand);
    }

    public boolean method_5931() {
        return this.method_17682() < 1.0f;
    }

    protected boolean canEatFromPlayer(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        return this.modules.getMetabolismModule().getDiet() != null && this.modules.getMetabolismModule().getDiet().canEatItem(itemstack);
    }

    protected void onEatFromPlayer(class_1657 player, class_1268 hand, class_1799 stack) {
    }

    @Override
    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        this.modules.saveNbt(compound);
    }

    @Override
    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        this.modules.loadNbt(compound);
    }

    protected void method_5712(@NotNull class_2338 pos, @NotNull class_2680 state) {
    }

    @Nullable
    public class_1315 method_5943(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 spawnType, @Nullable class_1315 spawnGroupData) {
        this.modules.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        return super.method_5943(level, difficulty, spawnType, spawnGroupData);
    }

    protected boolean canRunInWater() {
        return false;
    }

    protected TravelersPathNavigation createNavigationController(class_1937 level) {
        return new JSGroundNavigation(this, level);
    }

    public float getHeadRotationSpeed() {
        return 0.5f;
    }

    public boolean isMoving() {
        return this.moveAnalysis.isMoving();
    }

    public boolean isDead() {
        return (Boolean)this.field_6011.method_12789(dead);
    }

    public boolean shouldSleep() {
        ActiveTime sleeptime = this.getModules().getGeneticModule().getGeneData().getActiveTime();
        return !sleeptime.isActiveNow(this.method_37908().method_8532()) && !this.method_5799();
    }

    public double getTrackingRange() {
        return this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getTrackingRange();
    }

    public float getAttackReach() {
        float width = Math.max(0.5f, this.method_17681());
        return width * width * 3.0f;
    }

    public void attack(class_1309 target) {
        if (this.attackDelay == -1) {
            JSAnimalBase base;
            if (target instanceof JSAnimalBase && (base = (JSAnimalBase)target).isDead() && this.isCarnivore()) {
                this.curEatTicks = this.eatAnimLength();
                this.attackDelay = this.eatAnimLength() + 10;
            } else {
                this.curAttackTicks = this.attackAnimLength();
                this.attackDelay = this.attackAnimLength() + 10;
            }
            this.pendingTarget = target;
        }
    }

    private boolean isCarnivore() {
        return this.getAnimal().getAnimalAttributes().getMetabolismProperties().getDietType() == AnimalDietType.CARNIVORE;
    }

    protected int attackAnimLength() {
        return 20;
    }

    protected int eatAnimLength() {
        return 75;
    }

    public boolean method_6121(@NotNull class_1297 entity) {
        boolean superHurt = super.method_6121(entity);
        if (!superHurt) {
            return false;
        }
        if (entity instanceof class_1309) {
            class_1309 e = (class_1309)entity;
            for (JSGene jsGene : this.getModules().getGeneticModule().getGeneData().geneDataHolder.getGENE_SET()) {
                jsGene.doHurtTarget(this, e);
            }
        }
        return true;
    }

    protected void method_59928() {
        class_3414 sound = this.getAttackSound();
        if (sound != null) {
            this.method_5783(sound, this.method_6107(), this.method_6017());
        }
    }

    @Nullable
    protected class_3414 getAttackSound() {
        return null;
    }

    @Nullable
    protected class_3414 getCallSound() {
        return null;
    }

    public void callSounds() {
        class_3414 sound = this.getCallSound();
        if (sound != null) {
            this.method_5783(sound, this.method_6107(), this.method_6017());
        }
    }

    public float method_6029() {
        double baseSpeed = this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getMovementSpeed();
        float scale = this.method_55693();
        if (scale != 1.0f) {
            baseSpeed /= (double)scale;
        }
        float currentYaw = this.method_36454();
        float turningAmount = Math.abs(currentYaw - this.previousYaw);
        turningAmount = (turningAmount + 180.0f) % 360.0f - 180.0f;
        if ((turningAmount = Math.abs(turningAmount)) > 5.0f) {
            float turnSlowdown = Math.min(1.0f, turningAmount / 90.0f);
            baseSpeed *= (double)(1.0f - 0.3f * turnSlowdown);
        }
        if (this.curSpeed == 0.0) {
            this.curSpeed = baseSpeed;
        }
        float acceleration = 0.025f * this.getAnimal().getAnimalAttributes().getMetabolismProperties().getAccelerationSpeedMultiplier();
        double speed = this.getCrawling() ? baseSpeed * (double)0.87f : (this.isStalking() ? class_3532.method_16436((double)acceleration, (double)this.curSpeed, (double)(baseSpeed * (double)this.getAnimal().getAnimalAttributes().getMetabolismProperties().getStalkingSpeedMultiplier())) : (this.isRunning() ? class_3532.method_16436((double)acceleration, (double)this.curSpeed, (double)(baseSpeed * this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getRunningSpeedMultiplier())) : (this.method_5799() ? class_3532.method_16436((double)acceleration, (double)this.curSpeed, (double)(baseSpeed * this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getSwimmingSpeedMultiplier())) : (this.getNavigationController().isInProgress() ? class_3532.method_16436((double)acceleration, (double)this.curSpeed, (double)baseSpeed) : baseSpeed))));
        this.previousYaw = currentYaw;
        this.curSpeed = speed;
        return (float)speed;
    }

    public void freezeAnimator() {
        this.freezeAnimator = true;
    }

    public void shakeCamera(float multiplier, boolean groundCheck) {
        if (this.isStaticCreature()) {
            return;
        }
        if (!this.method_37908().field_9236 && this.canShake()) {
            TravelersPacketDistributor.sendToPlayersTrackingEntity((SmartAnimalBase)this, (class_8710)new TravelersShakeCamera(groundCheck, this.shakeAmount() * multiplier, (int)((float)this.shakeLength() * multiplier), this.shakeDistance(), this.method_19538().method_46409()));
        }
    }

    public boolean canShake() {
        return this.shakeAmount() > 0.0f && (float)this.shakeLength() > 0.0f && this.shakeDistance() > 0.0f;
    }

    public int shakeLength() {
        return 0;
    }

    public float shakeAmount() {
        return 0.0f;
    }

    public float shakeDistance() {
        return 0.0f;
    }

    public boolean hasSolidBelow() {
        class_238 aabb = this.method_5829().method_989(0.0, -0.05, 0.0);
        class_238 check = aabb.method_1009(-0.1, 0.0, -0.1);
        return this.hasCollisions(check);
    }

    protected boolean checkForCollide() {
        class_238 aabb = this.method_5829();
        return this.hasCollisions(aabb.method_1009(0.5, 0.0, 0.5));
    }

    protected boolean hasCollisions(class_238 boundingBox) {
        return !this.noBlockCollision((class_1297)this, boundingBox);
    }

    protected boolean noBlockCollision(@Nullable class_1297 entity, class_238 box) {
        class_3726 ctx = entity == null ? class_3726.method_16194() : class_3726.method_16195((class_1297)entity);
        class_2338.class_2339 pos = new class_2338.class_2339();
        int minX = class_3532.method_15357((double)box.field_1323);
        int maxX = class_3532.method_15357((double)(box.field_1320 + 1.0E-7));
        int minY = class_3532.method_15357((double)box.field_1322);
        int maxY = class_3532.method_15357((double)(box.field_1325 + 1.0E-7));
        int minZ = class_3532.method_15357((double)box.field_1321);
        int maxZ = class_3532.method_15357((double)(box.field_1324 + 1.0E-7));
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_265 shape;
                    pos.method_10103(x, y, z);
                    class_2680 state = this.method_37908().method_8320((class_2338)pos);
                    if (state.method_26215() || (shape = state.method_26194((class_1922)this.method_37908(), (class_2338)pos, ctx)).method_1110() || !shape.method_1107().method_989((double)x, (double)y, (double)z).method_994(box)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void tickBlacklist(class_1937 level) {
        int now = (int)level.method_8510();
        this.blacklist.entrySet().removeIf(e -> (Integer)e.getValue() <= now);
    }

    public void blackListAnimal(class_1309 target) {
        int expireTick = (int)(target.method_37908().method_8510() + 800L);
        this.blacklist.put(target, expireTick);
    }

    public boolean checkBlacklist(class_1309 mob) {
        if (mob != null && mob.method_5739((class_1297)this) < 16.0f) {
            this.blacklist.remove(mob);
            return false;
        }
        return this.blacklist.containsKey(mob);
    }

    public void onGestationFinished(JSGeneData fatherGeneData) {
        JSAnimalBase cre;
        if (this.getModules().getGeneticModule().isMale()) {
            return;
        }
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.getAnimal().getAnimalAttributes().getMetabolismProperties().isLiveBirth() && (cre = JSUtils.spawnCreature(this.getAnimal(), this.method_37908(), this.method_24515(), JSGeneUtil.combineBreeding(this.method_59922(), this.getModules().getGeneticModule().getGeneData(), fatherGeneData))) != null) {
            this.getModules().getMetabolismModule().clearBreedingParentData();
        }
    }

    public void onMate(JSAnimalBase other) {
        if (this.getModules().getGeneticModule().isMale()) {
            return;
        }
        this.getModules().getMetabolismModule().maxBreedingCooldown();
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 lev = (class_3218)class_19372;
            this.getModules().getMetabolismModule().setBreedingParentDNA(other.getModules().getGeneticModule().getGeneData());
            lev.method_14199((class_2394)class_2398.field_11201, (double)this.method_24515().method_10263(), (double)((float)this.method_24515().method_10264() + this.method_5751()), (double)this.method_24515().method_10260(), 15, 0.5, (double)0.05f, 0.5, 0.2);
        }
    }

    public boolean getEyesClosed() {
        return false;
    }

    public void notifyAboutMe(JSAnimalBase target) {
        if (this.getFleeTarget() == target || this.method_5968() == target) {
            return;
        }
        if (this.getModules().getMetabolismModule().canTarget(true, true, (class_1297)target)) {
            this.method_5980((class_1309)target);
            this.method_19540(true);
            this.alertHerd((class_1309)target);
            this.setFleeTarget(null);
        } else {
            this.setFleeTarget((class_1297)target);
            this.method_5980(null);
        }
    }

    public void alertHerd(class_1309 threat) {
        JSAnimalBase trueLeader = this.getModules().getHerdModule().getTrueLeader();
        if (trueLeader != null) {
            for (JSAnimalBase follower : trueLeader.getModules().getHerdModule().getFollowers()) {
                if (follower.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT) {
                    follower.method_5980(threat);
                    follower.method_19540(true);
                    continue;
                }
                follower.setFleeTarget((class_1297)threat);
            }
            trueLeader.method_5980(threat);
        }
    }
}

