/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.bases;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import java.util.HashMap;
import java.util.List;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSModuleHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1320;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;

public abstract class JSEntityDataHolder
extends SmartAnimalBase {
    public static final class_2940<Boolean> leaping = class_2945.method_12791(JSEntityDataHolder.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> male = class_2945.method_12791(JSEntityDataHolder.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> refreshData = class_2945.method_12791(JSEntityDataHolder.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> panicking = class_2945.method_12791(JSEntityDataHolder.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> resting = class_2945.method_12791(JSEntityDataHolder.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> sleeping = class_2945.method_12791(JSEntityDataHolder.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> stalking = class_2945.method_12791(JSEntityDataHolder.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> observing = class_2945.method_12791(JSEntityDataHolder.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> dead = class_2945.method_12791(JSEntityDataHolder.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> onGround = class_2945.method_12791(JSEntityDataHolder.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> crawling = class_2945.method_12791(JSEntityDataHolder.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Float> additionalScale = class_2945.method_12791(JSEntityDataHolder.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> aggression = class_2945.method_12791(JSEntityDataHolder.class, (class_2941)class_2943.field_13320);
    public static final class_2940<String> textureVariant = class_2945.method_12791(JSEntityDataHolder.class, (class_2941)class_2943.field_13326);
    public static final class_2940<class_2487> geneData = class_2945.method_12791(JSEntityDataHolder.class, (class_2941)class_2943.field_13318);
    public static final class_2940<class_2487> growthData = class_2945.method_12791(JSEntityDataHolder.class, (class_2941)class_2943.field_13318);
    public static final class_2940<class_2487> metabolismData = class_2945.method_12791(JSEntityDataHolder.class, (class_2941)class_2943.field_13318);
    public int curInjuredTicks;
    public int curAttackTicks;
    public int curCallingTicks;
    public int curEatTicks;
    public int curDrinkTicks;
    public int curSleepInteruptions;
    protected int attackDelay = -1;
    protected int corpseDropCount = 0;
    protected float regenHealth = 1.0f;
    protected float previousYaw = 0.0f;
    protected double curSpeed = 0.0;
    public class_2338 lastDrankAtPos;
    public class_2338 lastAteAtPos;
    protected class_1297 fleeTarget;
    protected class_1309 pendingTarget;
    protected boolean isStaticCreature;
    protected boolean isFrozenInPlace;
    protected boolean firstTick = true;
    protected HashMap<class_6880<class_1320>, Double> statMap = new HashMap();
    protected JSModuleHolder modules;
    protected float nextStep;
    protected int lastCrystalSoundPlayTick;
    protected float crystalSoundIntensity;

    protected JSEntityDataHolder(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(male, (Object)false);
        builder.method_56912(panicking, (Object)false);
        builder.method_56912(refreshData, (Object)false);
        builder.method_56912(resting, (Object)false);
        builder.method_56912(sleeping, (Object)false);
        builder.method_56912(stalking, (Object)false);
        builder.method_56912(observing, (Object)false);
        builder.method_56912(dead, (Object)false);
        builder.method_56912(onGround, (Object)false);
        builder.method_56912(crawling, (Object)false);
        builder.method_56912(additionalScale, (Object)Float.valueOf(0.0f));
        builder.method_56912(aggression, (Object)Float.valueOf(0.0f));
        builder.method_56912(textureVariant, (Object)JSVariants.NONE.getName());
        builder.method_56912(geneData, (Object)new class_2487());
        builder.method_56912(growthData, (Object)new class_2487());
        builder.method_56912(metabolismData, (Object)new class_2487());
        builder.method_56912(leaping, (Object)false);
    }

    protected void method_5958() {
        super.method_5958();
        boolean grounded = this.checkOnGround();
        this.field_6011.method_12778(onGround, (Object)grounded);
    }

    public boolean method_5643(class_1282 source, float amount) {
        return super.method_5643(source, amount);
    }

    public boolean isLeaping() {
        return (Boolean)this.field_6011.method_12789(leaping);
    }

    public void setLeaping(boolean isLeaping) {
        this.field_6011.method_12778(leaping, (Object)isLeaping);
    }

    private boolean checkOnGround() {
        class_238 box = this.method_5829();
        double feetY = box.field_1322 - 0.05;
        class_238 groundCheck = new class_238(box.field_1323, feetY, box.field_1321, box.field_1320, box.field_1322 + 0.05, box.field_1324);
        for (class_265 shape : this.method_37908().method_20812((class_1297)this, groundCheck)) {
            if (shape.method_1110()) continue;
            return true;
        }
        return false;
    }

    public boolean method_24828() {
        return (Boolean)this.field_6011.method_12789(onGround);
    }

    public void method_24830(boolean onGround) {
    }

    public void method_60607(boolean onGround, class_243 movement) {
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("js.animal.dead", ((Boolean)this.field_6011.method_12789(dead)).booleanValue());
        this.saveBlockPos("js.lastdrankat", this.lastDrankAtPos, compound);
        this.saveBlockPos("js.lastateat", this.lastAteAtPos, compound);
    }

    private void saveBlockPos(String string, class_2338 pos, class_2487 compound) {
        if (pos != null) {
            compound.method_10569(string + ".x", pos.method_10263());
            compound.method_10569(string + ".y", pos.method_10264());
            compound.method_10569(string + ".z", pos.method_10260());
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(dead, (Object)compound.method_10577("js.animal.dead"));
        this.lastDrankAtPos = this.readBlockPos(compound, "js.lastdrankat");
        this.lastAteAtPos = this.readBlockPos(compound, "js.lastateat");
    }

    private class_2338 readBlockPos(class_2487 compound, String string) {
        if (!compound.method_10545(string + ".x")) {
            return null;
        }
        return new class_2338(compound.method_10550(string + ".x"), compound.method_10550(string + ".y"), compound.method_10550(string + ".z"));
    }

    void setDead(boolean aBoolean) {
        this.field_6011.method_12778(dead, (Object)aBoolean);
    }

    public void setIsPanicking(boolean isPanicking) {
        this.field_6011.method_12778(panicking, (Object)isPanicking);
    }

    public boolean method_52546() {
        return (Boolean)this.field_6011.method_12789(panicking);
    }

    public void setResting(boolean isResting) {
        this.field_6011.method_12778(resting, (Object)isResting);
    }

    public boolean isResting() {
        return (Boolean)this.field_6011.method_12789(resting);
    }

    public void setSleeping(boolean isSleeping) {
        this.field_6011.method_12778(sleeping, (Object)isSleeping);
    }

    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(sleeping);
    }

    public void setCrawling(boolean bool) {
        this.field_6011.method_12778(crawling, (Object)bool);
        this.method_18382();
    }

    public boolean getCrawling() {
        return (Boolean)this.field_6011.method_12789(crawling);
    }

    public void setStalking(boolean isStalking) {
        this.field_6011.method_12778(stalking, (Object)isStalking);
    }

    public void setObserving(boolean isObserving) {
        this.field_6011.method_12778(observing, (Object)isObserving);
    }

    public boolean isObserving() {
        return (Boolean)this.field_6011.method_12789(observing);
    }

    public float getAggression() {
        return ((Float)this.field_6011.method_12789(aggression)).floatValue();
    }

    public void setAggression(float aggresionValue) {
        this.field_6011.method_12778(aggression, (Object)Float.valueOf(aggresionValue));
    }

    public float method_49476() {
        return 1.0f;
    }

    public void method_5784(class_1313 type, class_243 pos) {
        class_243 movement;
        if (this.field_5960) {
            this.method_5814(this.method_23317() + pos.field_1352, this.method_23318() + pos.field_1351, this.method_23321() + pos.field_1350);
            return;
        }
        this.field_28629 = this.method_5809();
        if (type == class_1313.field_6310 && (pos = this.method_18794(pos)).equals((Object)class_243.field_1353)) {
            return;
        }
        class_3695 profiler = this.method_37908().method_16107();
        profiler.method_15396("move");
        if (this.field_17046.method_1027() > 1.0E-7) {
            pos = pos.method_18806(this.field_17046);
            this.field_17046 = class_243.field_1353;
            this.method_18799(class_243.field_1353);
        }
        if ((movement = this.collide(pos = this.method_18796(pos, type))).method_1027() > 1.0E-7) {
            this.handleFallReset(movement);
            this.method_5814(this.method_23317() + movement.field_1352, this.method_23318() + movement.field_1351, this.method_23321() + movement.field_1350);
        }
        profiler.method_15407();
        profiler.method_15396("rest");
        this.updateCollisions(pos, movement);
        this.updateGroundAndFallDamage(movement);
        if (this.method_31481()) {
            profiler.method_15407();
            return;
        }
        this.handleHorizontalCollision();
        this.handleBlockInteractions(pos, movement);
        this.handleMovementEmission(pos, movement);
        this.method_36974();
        this.applyBlockSpeedFactor();
        this.handleFireAndExtinguish();
        profiler.method_15407();
    }

    private void handleFallReset(class_243 movement) {
        class_3965 hit;
        if (this.field_6017 != 0.0f && movement.method_1027() >= 1.0 && (hit = this.method_37908().method_17742(new class_3959(this.method_19538(), this.method_19538().method_1019(movement), class_3959.class_3960.field_36337, class_3959.class_242.field_36338, (class_1297)this))).method_17783() != class_239.class_240.field_1333) {
            this.method_38785();
        }
    }

    private void updateCollisions(class_243 input, class_243 result) {
        boolean xCollide = !class_3532.method_20390((double)input.field_1352, (double)result.field_1352);
        boolean zCollide = !class_3532.method_20390((double)input.field_1350, (double)result.field_1350);
        this.field_5976 = xCollide || zCollide;
        this.field_5992 = input.field_1351 != result.field_1351;
        this.field_36331 = this.field_5992 && input.field_1351 < 0.0;
        this.field_34927 = this.field_5976 && this.method_39759(result);
    }

    private void updateGroundAndFallDamage(class_243 movement) {
        class_2338 pos = this.method_43260();
        class_2680 state = this.method_37908().method_8320(pos);
        this.method_5623(movement.field_1351, this.method_24828(), state, pos);
    }

    private void handleHorizontalCollision() {
        if (!this.field_5976) {
            return;
        }
        class_243 delta = this.method_18798();
        this.method_18800(this.field_5976 ? 0.0 : delta.field_1352, delta.field_1351, this.field_5976 ? 0.0 : delta.field_1350);
    }

    private void handleBlockInteractions(class_243 input, class_243 movement) {
        class_2338 pos = this.method_43260();
        class_2680 state = this.method_37908().method_8320(pos);
        class_2248 block = state.method_26204();
        if (input.field_1351 != movement.field_1351) {
            block.method_9502((class_1922)this.method_37908(), (class_1297)this);
        }
        if (this.method_24828()) {
            block.method_9591(this.method_37908(), pos, state, (class_1297)this);
        }
    }

    private void handleMovementEmission(class_243 input, class_243 movement) {
        class_1297.class_5799 emission = this.method_33570();
        if (!emission.method_33576() || this.method_5765()) {
            return;
        }
        double dx = movement.field_1352;
        double dy = this.isStateClimbable(this.method_37908().method_8320(this.method_23312())) ? movement.field_1351 : 0.0;
        double dz = movement.field_1350;
        this.field_28627 += (float)(movement.method_1033() * (double)0.6f);
        this.field_5973 += (float)(movement.method_37267() * (double)0.6f);
        this.field_5994 += (float)(Math.sqrt(dx * dx + dy * dy + dz * dz) * (double)0.6f);
        if (this.field_5994 <= this.nextStep) {
            if (this.method_37908().method_8320(this.method_23312()).method_26215()) {
                this.method_33573();
            }
            return;
        }
        class_2338 current = this.method_23312();
        class_2338 previous = this.method_43260();
        class_2680 curState = this.method_37908().method_8320(current);
        class_2680 prevState = this.method_37908().method_8320(previous);
        boolean sameBlock = current.equals((Object)previous);
        boolean triggered = this.vibrationAndSoundEffectsFromBlock(previous, prevState, emission.method_33578(), sameBlock, input);
        if (!sameBlock) {
            triggered |= this.vibrationAndSoundEffectsFromBlock(current, curState, false, emission.method_33577(), input);
        }
        if (triggered || this.method_5799()) {
            this.nextStep = this.method_5867();
            if (this.method_5799()) {
                if (emission.method_33578()) {
                    this.method_51295();
                }
                if (emission.method_33577()) {
                    this.method_32876((class_6880)class_5712.field_28156);
                }
            }
        }
    }

    private void applyBlockSpeedFactor() {
        float factor = this.method_23326();
        this.method_18799(this.method_18798().method_18805((double)factor, 1.0, (double)factor));
    }

    private void handleFireAndExtinguish() {
        boolean inFireBlock = this.method_37908().method_29556(this.method_5829().method_1011(1.0E-6)).anyMatch(s -> s.method_26164(class_3481.field_21952) || s.method_27852(class_2246.field_10164));
        if (!inFireBlock) {
            if (this.method_20802() <= 0) {
                this.method_20803(-this.method_5676());
            }
            if (this.field_28629 && (this.field_27857 || this.method_5637())) {
                this.method_36975();
            }
        }
        if (this.method_5809() && (this.field_27857 || this.method_5637())) {
            this.method_20803(-this.method_5676());
        }
    }

    private class_243 collide(class_243 vec) {
        boolean flag3;
        class_238 aabb = this.method_5829();
        List list = this.method_37908().method_20743((class_1297)this, aabb.method_18804(vec));
        class_243 vec3 = vec.method_1027() == 0.0 ? vec : JSEntityDataHolder.collideBoundingBox((class_1297)this, vec, aabb, this.method_37908(), list);
        boolean flag = vec.field_1352 != vec3.field_1352;
        boolean flag1 = vec.field_1351 != vec3.field_1351;
        boolean flag2 = vec.field_1350 != vec3.field_1350;
        boolean bl = flag3 = flag1 && vec.field_1351 < 0.0;
        if (this.method_49476() > 0.0f && (flag3 || this.method_24828()) && (flag || flag2)) {
            float[] afloat;
            class_238 aabb1 = flag3 ? aabb.method_989(0.0, vec3.field_1351, 0.0) : aabb;
            class_238 aabb2 = aabb1.method_1012(vec.field_1352, (double)this.method_49476(), vec.field_1350);
            if (!flag3) {
                aabb2 = aabb2.method_1012(0.0, (double)-1.0E-5f, 0.0);
            }
            List<class_265> list1 = JSEntityDataHolder.collectColliders((class_1297)this, this.method_37908(), list, aabb2);
            float f = (float)vec3.field_1351;
            for (float f1 : afloat = JSEntityDataHolder.collectCandidateStepUpHeights(aabb1, list1, this.method_49476(), f)) {
                class_243 vec31 = JSEntityDataHolder.collideWithShapes(new class_243(vec.field_1352, (double)f1, vec.field_1350), aabb1, list1);
                if (!(vec31.method_37268() > vec3.method_37268())) continue;
                double d0 = aabb.field_1322 - aabb1.field_1322;
                return vec31.method_1031(0.0, -d0, 0.0);
            }
        }
        return vec3;
    }

    private static float[] collectCandidateStepUpHeights(class_238 box, List<class_265> colliders, float deltaY, float maxUpStep) {
        FloatArraySet floatset = new FloatArraySet(4);
        block0: for (class_265 voxelshape : colliders) {
            DoubleListIterator var7 = voxelshape.method_1109(class_2350.class_2351.field_11052).iterator();
            while (var7.hasNext()) {
                double d0 = var7.next();
                float f = (float)(d0 - box.field_1322);
                if (f < 0.0f || f == maxUpStep) continue;
                if (f > deltaY) continue block0;
                floatset.add(f);
            }
        }
        float[] afloat = floatset.toFloatArray();
        FloatArrays.unstableSort((float[])afloat);
        return afloat;
    }

    public static class_243 collideBoundingBox(@Nullable class_1297 entity, class_243 vec, class_238 collisionBox, class_1937 level, List<class_265> potentialHits) {
        List<class_265> list = JSEntityDataHolder.collectColliders(entity, level, potentialHits, collisionBox.method_18804(vec));
        return JSEntityDataHolder.collideWithShapes(vec, collisionBox, list);
    }

    private static List<class_265> collectColliders(@Nullable class_1297 entity, class_1937 level, List<class_265> collisions, class_238 boundingBox) {
        boolean flag;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(collisions.size() + 1));
        if (!collisions.isEmpty()) {
            builder.addAll(collisions);
        }
        class_2784 worldborder = level.method_8621();
        boolean bl = flag = entity != null && worldborder.method_39459(entity, boundingBox);
        if (flag) {
            builder.add((Object)worldborder.method_17903());
        }
        builder.addAll(level.method_20812(entity, boundingBox));
        return builder.build();
    }

    private static class_243 collideWithShapes(class_243 deltaMovement, class_238 entityBB, List<class_265> shapes) {
        boolean flag;
        if (shapes.isEmpty()) {
            return deltaMovement;
        }
        double d0 = deltaMovement.field_1352;
        double d1 = deltaMovement.field_1351;
        double d2 = deltaMovement.field_1350;
        if (d1 != 0.0 && (d1 = class_259.method_1085((class_2350.class_2351)class_2350.class_2351.field_11052, (class_238)entityBB, shapes, (double)d1)) != 0.0) {
            entityBB = entityBB.method_989(0.0, d1, 0.0);
        }
        boolean bl = flag = Math.abs(d0) < Math.abs(d2);
        if (flag && d2 != 0.0 && (d2 = class_259.method_1085((class_2350.class_2351)class_2350.class_2351.field_11051, (class_238)entityBB, shapes, (double)d2)) != 0.0) {
            entityBB = entityBB.method_989(0.0, 0.0, d2);
        }
        if (d0 != 0.0) {
            d0 = class_259.method_1085((class_2350.class_2351)class_2350.class_2351.field_11048, (class_238)entityBB, shapes, (double)d0);
            if (!flag && d0 != 0.0) {
                entityBB = entityBB.method_989(d0, 0.0, 0.0);
            }
        }
        if (!flag && d2 != 0.0) {
            d2 = class_259.method_1085((class_2350.class_2351)class_2350.class_2351.field_11051, (class_238)entityBB, shapes, (double)d2);
        }
        return new class_243(d0, d1, d2);
    }

    private boolean isStateClimbable(class_2680 state) {
        return state.method_26164(class_3481.field_22414) || state.method_27852(class_2246.field_27879);
    }

    private boolean vibrationAndSoundEffectsFromBlock(class_2338 pos, class_2680 state, boolean playStepSound, boolean broadcastGameEvent, class_243 entityPos) {
        boolean flag = this.isStateClimbable(state);
        if ((this.method_24828() || flag || this.method_18276() && entityPos.field_1351 == 0.0 || this.method_52172()) && !this.method_5681()) {
            if (playStepSound) {
                this.walkingStepSound(pos, state);
            }
            if (broadcastGameEvent) {
                this.method_37908().method_32888((class_6880)class_5712.field_28155, this.method_19538(), class_5712.class_7397.method_43286((class_1297)this, (class_2680)state));
            }
            return true;
        }
        return false;
    }

    private void walkingStepSound(class_2338 pos, class_2680 state) {
        this.method_5712(pos, state);
        if (this.shouldPlayAmethystStepSound(state)) {
            this.playAmethystStepSound();
        }
    }

    private boolean shouldPlayAmethystStepSound(class_2680 state) {
        return state.method_26164(class_3481.field_26986) && this.field_6012 >= this.lastCrystalSoundPlayTick + 20;
    }

    private void playAmethystStepSound() {
        this.crystalSoundIntensity *= (float)Math.pow(0.997, this.field_6012 - this.lastCrystalSoundPlayTick);
        this.crystalSoundIntensity = Math.min(1.0f, this.crystalSoundIntensity + 0.07f);
        float f = 0.5f + this.crystalSoundIntensity * this.field_5974.method_43057() * 1.2f;
        float f1 = 0.1f + this.crystalSoundIntensity * 1.2f;
        this.method_5783(class_3417.field_26980, f1, f);
        this.lastCrystalSoundPlayTick = this.field_6012;
    }

    public int getCurInjuredTicks() {
        return this.curInjuredTicks;
    }

    public int getCurAttackTicks() {
        return this.curAttackTicks;
    }

    public int getCurCallingTicks() {
        return this.curCallingTicks;
    }

    public int getCurEatTicks() {
        return this.curEatTicks;
    }

    public int getCurDrinkTicks() {
        return this.curDrinkTicks;
    }

    public int getCurSleepInteruptions() {
        return this.curSleepInteruptions;
    }

    public int getAttackDelay() {
        return this.attackDelay;
    }

    public int getCorpseDropCount() {
        return this.corpseDropCount;
    }

    public float getRegenHealth() {
        return this.regenHealth;
    }

    public float getPreviousYaw() {
        return this.previousYaw;
    }

    public double getCurSpeed() {
        return this.curSpeed;
    }

    public class_2338 getLastDrankAtPos() {
        return this.lastDrankAtPos;
    }

    public class_2338 getLastAteAtPos() {
        return this.lastAteAtPos;
    }

    public class_1297 getFleeTarget() {
        return this.fleeTarget;
    }

    public class_1309 getPendingTarget() {
        return this.pendingTarget;
    }

    public boolean isStaticCreature() {
        return this.isStaticCreature;
    }

    public boolean isFrozenInPlace() {
        return this.isFrozenInPlace;
    }

    public boolean isFirstTick() {
        return this.firstTick;
    }

    public HashMap<class_6880<class_1320>, Double> getStatMap() {
        return this.statMap;
    }

    public JSModuleHolder getModules() {
        return this.modules;
    }

    public float getNextStep() {
        return this.nextStep;
    }

    public int getLastCrystalSoundPlayTick() {
        return this.lastCrystalSoundPlayTick;
    }

    public float getCrystalSoundIntensity() {
        return this.crystalSoundIntensity;
    }

    public void setCurInjuredTicks(int curInjuredTicks) {
        this.curInjuredTicks = curInjuredTicks;
    }

    public void setCurAttackTicks(int curAttackTicks) {
        this.curAttackTicks = curAttackTicks;
    }

    public void setCurCallingTicks(int curCallingTicks) {
        this.curCallingTicks = curCallingTicks;
    }

    public void setCurEatTicks(int curEatTicks) {
        this.curEatTicks = curEatTicks;
    }

    public void setCurDrinkTicks(int curDrinkTicks) {
        this.curDrinkTicks = curDrinkTicks;
    }

    public void setCurSleepInteruptions(int curSleepInteruptions) {
        this.curSleepInteruptions = curSleepInteruptions;
    }

    public void setAttackDelay(int attackDelay) {
        this.attackDelay = attackDelay;
    }

    public void setCorpseDropCount(int corpseDropCount) {
        this.corpseDropCount = corpseDropCount;
    }

    public void setRegenHealth(float regenHealth) {
        this.regenHealth = regenHealth;
    }

    public void setPreviousYaw(float previousYaw) {
        this.previousYaw = previousYaw;
    }

    public void setCurSpeed(double curSpeed) {
        this.curSpeed = curSpeed;
    }

    public void setLastDrankAtPos(class_2338 lastDrankAtPos) {
        this.lastDrankAtPos = lastDrankAtPos;
    }

    public void setLastAteAtPos(class_2338 lastAteAtPos) {
        this.lastAteAtPos = lastAteAtPos;
    }

    public void setFleeTarget(class_1297 fleeTarget) {
        this.fleeTarget = fleeTarget;
    }

    public void setPendingTarget(class_1309 pendingTarget) {
        this.pendingTarget = pendingTarget;
    }

    public void setStaticCreature(boolean isStaticCreature) {
        this.isStaticCreature = isStaticCreature;
    }

    public void setFrozenInPlace(boolean isFrozenInPlace) {
        this.isFrozenInPlace = isFrozenInPlace;
    }

    public void setFirstTick(boolean firstTick) {
        this.firstTick = firstTick;
    }

    public void setStatMap(HashMap<class_6880<class_1320>, Double> statMap) {
        this.statMap = statMap;
    }

    public void setModules(JSModuleHolder modules) {
        this.modules = modules;
    }

    public void setNextStep(float nextStep) {
        this.nextStep = nextStep;
    }

    public void setLastCrystalSoundPlayTick(int lastCrystalSoundPlayTick) {
        this.lastCrystalSoundPlayTick = lastCrystalSoundPlayTick;
    }

    public void setCrystalSoundIntensity(float crystalSoundIntensity) {
        this.crystalSoundIntensity = crystalSoundIntensity;
    }
}

