/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.diet;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_4174;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class Diet {
    private final Set<Predicate<class_1799>> conditions = new HashSet<Predicate<class_1799>>();
    private final Map<Predicate<class_1799>, Integer> foodOverrides = new HashMap<Predicate<class_1799>, Integer>();
    private boolean canEatHaybale;
    private boolean canEatMeatCube;
    @NotNull
    private final Set<AnimalDietType> types = new HashSet<AnimalDietType>();

    public Diet(@NotNull AnimalDietType type) {
        this.types.add(type);
    }

    public Diet(Diet other) {
        this.types.addAll(other.types);
        this.foodOverrides.putAll(other.foodOverrides);
        this.conditions.addAll(other.conditions);
        this.canEatHaybale = other.canEatHaybale;
        this.canEatMeatCube = other.canEatMeatCube;
    }

    public boolean is(AnimalDietType diet) {
        return this.types.stream().anyMatch(d -> d == diet);
    }

    public Diet addItem(class_1792 item) {
        this.conditions.add(stack -> stack.method_31574(item));
        return this;
    }

    public Diet addItem(class_1792 item, int points) {
        this.conditions.add(stack -> stack.method_31574(item));
        this.foodOverrides.put(stack -> stack.method_31574(item), Math.max(0, points));
        return this;
    }

    public Diet addItemTag(class_6862<class_1792> tag) {
        this.conditions.add(stack -> stack.method_31573(tag));
        return this;
    }

    public Diet addItemTag(class_6862<class_1792> tag, int points) {
        this.conditions.add(stack -> stack.method_31573(tag));
        this.foodOverrides.put(stack -> stack.method_31573(tag), Math.max(0, points));
        return this;
    }

    public Diet addBlock(class_2248 block) {
        return this.addItem(block.method_8389());
    }

    public Diet addBlockTag(class_6862<class_2248> tag) {
        this.conditions.add(stack -> {
            class_1792 item = stack.method_7909();
            class_2248 block = class_2248.method_9503((class_1792)item);
            return block.method_9564().method_26164(tag);
        });
        return this;
    }

    public Diet addBlockTag(class_6862<class_2248> tag, int points) {
        this.conditions.add(stack -> {
            class_1792 item = stack.method_7909();
            class_2248 block = class_2248.method_9503((class_1792)item);
            return block.method_9564().method_26164(tag);
        });
        this.foodOverrides.put(stack -> {
            class_1792 item = stack.method_7909();
            class_2248 block = class_2248.method_9503((class_1792)item);
            return block.method_9564().method_26164(tag);
        }, Math.max(0, points));
        return this;
    }

    public Diet clearFoodOverrides() {
        this.foodOverrides.clear();
        return this;
    }

    public Diet add(Diet diet) {
        this.types.addAll(diet.types);
        this.conditions.addAll(diet.conditions);
        this.foodOverrides.putAll(diet.foodOverrides);
        if (!this.canEatHaybale) {
            this.canEatHaybale = diet.canEatHaybale;
        }
        if (!this.canEatMeatCube) {
            this.canEatMeatCube = diet.canEatMeatCube;
        }
        return this;
    }

    public boolean isEmpty() {
        return this.conditions.isEmpty();
    }

    public Diet copy() {
        return new Diet(this);
    }

    public boolean canEat(JSAnimalBase animal, class_1297 other) {
        boolean same = animal == other || animal.method_5864() == other.method_5864();
        return !same;
    }

    public int getFoodPoints(@NotNull JSAnimalBase animal, @NotNull class_1799 stack) {
        if (stack.method_7960()) {
            return 0;
        }
        for (Map.Entry<Predicate<class_1799>, Integer> entry : this.foodOverrides.entrySet()) {
            if (!entry.getKey().test(stack)) continue;
            return entry.getValue();
        }
        class_4174 food = (class_4174)stack.method_57824(class_9334.field_50075);
        if (food != null) {
            return (int)JSUtils.toTickMinutes((food.comp_2492() + (float)food.comp_2491()) / 2.0f);
        }
        class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
        if (block != class_2246.field_10124) {
            return 5;
        }
        return 1;
    }

    public boolean canEatItem(@NotNull class_1799 stack) {
        class_1799 check = stack.method_7972();
        check.method_7939(1);
        for (Predicate<class_1799> i : this.conditions) {
            if (!i.test(check)) continue;
            return true;
        }
        return false;
    }

    public Set<class_1799> getAllItems() {
        return class_7923.field_41178.method_10220().map(class_1799::new).filter(stack -> this.conditions.stream().anyMatch(predicate -> predicate.test(stack))).collect(Collectors.toSet());
    }

    public Diet setCanEatMeatCube(boolean canEatMeatCube) {
        this.canEatMeatCube = canEatMeatCube;
        return this;
    }

    public Diet setCanEatHaybale(boolean canEatHaybale) {
        this.canEatHaybale = canEatHaybale;
        return this;
    }

    public boolean isCanEatHaybale() {
        return this.canEatHaybale;
    }

    public boolean isCanEatMeatCube() {
        return this.canEatMeatCube;
    }

    @NotNull
    public Set<AnimalDietType> getTypes() {
        return this.types;
    }
}

