/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.modules.obj;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSAnimalModuleBase;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import net.minecraft.class_1266;
import net.minecraft.class_1315;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGeneticModule
extends JSAnimalModuleBase {
    private JSGeneData geneData;
    private boolean isFertile = true;
    private boolean isIntolerant = false;
    private boolean dirty = false;

    public JSGeneticModule(JSAnimalBase owner) {
        super(owner);
    }

    @Override
    public void tick() {
        if (this.dirty) {
            this.geneData = null;
            this.dirty = false;
        }
    }

    @Override
    public void saveNbt(class_2487 nbt) {
        if (this.geneData != null) {
            class_2487 tag = new class_2487();
            this.geneData.saveToNbt(tag);
            nbt.method_10566("js.genetics.data", (class_2520)tag);
        }
        nbt.method_10582("js.genetics.variant", (String)this.owner.method_5841().method_12789(JSEntityDataHolder.textureVariant));
        nbt.method_10556("js.genetics.male", this.isMale());
        nbt.method_10556("js.genetics.fertile", this.isFertile);
    }

    @Override
    public void loadNbt(class_2487 nbt) {
        class_2487 tag = nbt.method_10562("js.genetics.data");
        JSGeneData geneData = this.getGeneData();
        if (!tag.method_33133()) {
            geneData.loadFromNbt(tag);
        }
        this.setMale(nbt.method_10577("js.genetics.male"));
        this.setFertile(nbt.method_10577("js.genetics.fertile"));
        this.setGeneData(geneData);
    }

    public JSGeneData getGeneData() {
        if (this.geneData == null) {
            class_2487 tag = (class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.geneData);
            if (tag == null || tag.method_33133()) {
                this.geneData = new JSGeneData();
            } else {
                this.geneData = new JSGeneData();
                this.geneData.loadFromNbt(tag);
            }
        }
        return this.geneData;
    }

    public void setGeneData(JSGeneData data) {
        if (data == null) {
            return;
        }
        this.applyGenes(data);
    }

    private void applyGenes(JSGeneData data) {
        if (data == null || data.geneDataHolder == null) {
            return;
        }
        for (JSGene jsGene : data.geneDataHolder.getGENE_SET()) {
            jsGene.applyTo(data, this.owner);
        }
        class_2487 tag = new class_2487();
        data.saveToNbt(tag);
        this.owner.method_5841().method_12778(JSEntityDataHolder.geneData, (Object)tag);
    }

    @Override
    public void finalizeSpawn(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 spawnType, @Nullable class_1315 spawnGroupData) {
        this.setMale(level.method_8409().method_43056());
        JSGeneData data = this.getGeneData();
        data.setGeneSeed(level.method_8409().method_43054());
        data.setSizeDimorphism((float)(1 + level.method_8409().method_43048((int)this.owner.getAnimal().getAnimalAttributes().getEntityBaseProperties().getSizeDimorphism())) / 500.0f);
        this.setGeneData(data);
    }

    @Override
    public void init() {
    }

    public void hatch() {
        JSGeneData data = this.getGeneData();
        if (data == null || data.geneDataHolder == null) {
            return;
        }
        for (JSGene gene : data.geneDataHolder.getGENE_SET()) {
            gene.onHatch(this.owner);
        }
    }

    public void setMale(boolean male) {
        this.owner.method_5841().method_12778(JSEntityDataHolder.male, (Object)male);
    }

    public boolean isMale() {
        return (Boolean)this.owner.method_5841().method_12789(JSEntityDataHolder.male);
    }

    public void markDirty() {
        this.dirty = true;
    }

    public boolean isFertile() {
        return this.isFertile;
    }

    public void setFertile(boolean isFertile) {
        this.isFertile = isFertile;
    }

    public void setIntolerant(boolean isIntolerant) {
        this.isIntolerant = isIntolerant;
    }

    public boolean isIntolerant() {
        return this.isIntolerant;
    }
}

