/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.modules.obj;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSAnimalModuleBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.JSMetabolismModule;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import travelers.server.animal.entity.task.TaskGoal;

public class JSHerdModule
extends JSAnimalModuleBase {
    private JSAnimalBase herdLeader;
    private UUID herdLeaderUUID;
    private final Set<JSAnimalBase> followers = new HashSet<JSAnimalBase>();
    private boolean isMovingToLeader;
    private int checkCooldown;
    private int lookCooldown = 40;
    private int maxDistance;
    private int maxHerdSize;
    private double minLeaderDist;
    private JSSocialGroupProperties<?> socialProps;
    private Class<? extends class_1309>[] compatTypes;
    private int trueLeaderCooldown = 0;
    private JSAnimalBase cachedTrueLeader;
    private int leaderResolveCooldown = 0;
    private boolean herdStrengthDirty = true;
    private double cachedHerdStrength = 0.0;
    private CompletableFuture<Void> herdMergeFuture;

    public JSHerdModule(JSAnimalBase owner) {
        super(owner);
        if (owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getMaxHerdSize() < 1) {
            this.disable();
        }
    }

    public void setHerdLeader(JSAnimalBase leader) {
        this.herdLeader = leader;
        this.herdLeaderUUID = leader != null ? leader.method_5667() : null;
    }

    @Override
    public void saveNbt(class_2487 nbt) {
        if (this.herdLeaderUUID != null) {
            nbt.method_10582("js.herd.herdleader", this.herdLeaderUUID.toString());
        }
    }

    @Override
    public void loadNbt(class_2487 nbt) {
        String s = nbt.method_10558("js.herd.herdleader");
        if (!s.isEmpty()) {
            this.herdLeaderUUID = UUID.fromString(s);
        }
    }

    @Override
    public void init() {
        this.socialProps = this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties();
        this.maxDistance = (int)this.socialProps.getMaxDistanceToPackLeader();
        this.minLeaderDist = this.socialProps.getMinDistanceToPackLeader();
        this.maxHerdSize = this.socialProps.getMaxHerdSize();
        this.compatTypes = this.socialProps.getHerdCompatible().toArray(new Class[0]);
        this.checkCooldown = 0;
        this.lookCooldown = 40;
    }

    @Override
    public void serverAiStep() {
        if (this.owner.getModules().getGeneticModule().isIntolerant()) {
            this.disable();
            return;
        }
        this.resolveLeaderByUUID();
        if ((this.owner.field_6012 + this.owner.method_5628()) % 40 == 0) {
            this.ensureTwoWayLink();
        }
        if ((this.owner.field_6012 + this.owner.method_5628()) % 100 == 0) {
            this.cleanupFollowers();
        }
        if (this.isFollower()) {
            this.tickFollower();
        } else {
            this.tickLeader();
        }
    }

    private void tickFollower() {
        if (!this.isEntityValid(this.herdLeader)) {
            this.stopFollowing();
            return;
        }
        if (this.owner.getNavigationController().isDone() && this.isMovingToLeader) {
            this.isMovingToLeader = false;
        }
        if (!this.isMovingToLeader && this.owner.method_5858((class_1297)this.herdLeader) > this.minLeaderDist * this.minLeaderDist) {
            if (this.checkCooldown > 0) {
                --this.checkCooldown;
            } else {
                this.tryMoveToLeader();
            }
        }
    }

    private void tryMoveToLeader() {
        JSAvianBase av;
        if (this.owner.isDead()) {
            return;
        }
        if ((this.owner.field_6012 + this.owner.method_5628()) % 5 != 0) {
            return;
        }
        JSAnimalBase jSAnimalBase = this.owner;
        if (jSAnimalBase instanceof JSAvianBase && (av = (JSAvianBase)jSAnimalBase).isDiving()) {
            return;
        }
        if (this.owner.method_5968() != null || this.owner.getFleeTarget() != null) {
            return;
        }
        JSMetabolismModule meta = this.owner.getModules().getMetabolismModule();
        if (meta.isHungry() || meta.isThirsty()) {
            return;
        }
        this.isMovingToLeader = true;
        this.owner.getTaskController().stopTask(TaskGoal.MOVEMENT);
        CompletableFuture moveTask = this.owner.getNavigationController().moveTo((class_1297)this.herdLeader);
        if (moveTask != null) {
            moveTask.thenAccept(path -> {
                if (path == null) {
                    this.isMovingToLeader = false;
                    this.checkCooldown = 20;
                } else {
                    this.checkCooldown = 800;
                }
            });
        }
    }

    private void tickLeader() {
        class_238 box;
        if (this.lookCooldown > 0) {
            --this.lookCooldown;
            return;
        }
        if (this.herdMergeFuture != null && !this.herdMergeFuture.isDone()) {
            return;
        }
        this.lookCooldown = 200 + this.owner.method_59922().method_43048(100);
        if (this.herdMergeFuture != null && !this.herdMergeFuture.isDone()) {
            return;
        }
        class_3218 level = (class_3218)this.owner.method_37908();
        List candidates = level.method_8390(JSAnimalBase.class, box = this.owner.method_5829().method_1014(16.0), this::canHerdWith);
        if (candidates.isEmpty()) {
            return;
        }
        HashSet<JSAnimalBase> leaders = new HashSet<JSAnimalBase>();
        for (JSAnimalBase e : candidates) {
            JSAnimalBase tl = e.getModules().getHerdModule().getTrueLeader();
            if (!this.isEntityValid(tl)) continue;
            leaders.add(tl);
        }
        if (this.isLeader()) {
            leaders.add(this.owner);
        }
        if (leaders.isEmpty()) {
            this.lookCooldown = 200;
            return;
        }
        JSAnimalBase bestLeader = this.owner;
        int bestSize = this.getHerdSize();
        UUID bestId = this.owner.method_5667();
        for (JSAnimalBase l : leaders) {
            int size = l.getModules().getHerdModule().getHerdSize();
            if (size <= bestSize && (size != bestSize || l.method_5667().compareTo(bestId) >= 0)) continue;
            bestLeader = l;
            bestSize = size;
            bestId = l.method_5667();
        }
        JSHerdModule bestMod = bestLeader.getModules().getHerdModule();
        for (JSAnimalBase l : leaders) {
            if (l == bestLeader) continue;
            JSHerdModule lm = l.getModules().getHerdModule();
            if (!lm.followers.isEmpty()) {
                JSAnimalBase[] arr;
                for (JSAnimalBase f : arr = lm.followers.toArray(new JSAnimalBase[0])) {
                    if (bestMod.getHerdSize() >= this.maxHerdSize) break;
                    if (f == null || f.isDead()) continue;
                    f.getModules().getHerdModule().startFollowing(bestLeader);
                }
            }
            if (bestMod.getHerdSize() >= this.maxHerdSize) continue;
            l.getModules().getHerdModule().startFollowing(bestLeader);
        }
        this.lookCooldown = 40;
    }

    public void addFollowers(Stream<? extends JSAnimalBase> newFollowers) {
        newFollowers.forEach(f -> {
            JSHerdModule hm;
            if (f != null && f != this.owner && !f.isDead() && !(hm = f.getModules().getHerdModule()).isFollower()) {
                hm.startFollowing(this.owner);
            }
        });
    }

    public void startFollowing(JSAnimalBase leader) {
        if (leader == this.owner) {
            return;
        }
        JSHerdModule lm = leader.getModules().getHerdModule();
        if (!lm.canBeFollowed()) {
            return;
        }
        this.stopFollowing();
        this.setHerdLeader(leader);
        lm.addFollower(this.owner);
    }

    public void stopFollowing() {
        if (this.herdLeader != null) {
            this.herdLeader.getModules().getHerdModule().removeFollower(this.owner);
        }
        this.herdLeader = null;
        this.herdLeaderUUID = null;
        this.isMovingToLeader = false;
    }

    public void addFollower(JSAnimalBase a) {
        if (a != null && a != this.owner && this.followers.add(a)) {
            this.herdStrengthDirty = true;
        }
    }

    public void removeFollower(JSAnimalBase a) {
        if (this.followers.remove((Object)a)) {
            this.herdStrengthDirty = true;
        }
    }

    public int getHerdSize() {
        return this.isLeader() ? 1 + this.followers.size() : 1;
    }

    public boolean canBeFollowed() {
        return this.followers.size() < this.maxHerdSize;
    }

    public boolean isFollower() {
        return this.herdLeader != null || this.herdLeaderUUID != null;
    }

    public boolean isLeader() {
        return !this.isFollower();
    }

    public JSAnimalBase getTrueLeader() {
        class_1937 class_19372;
        if (this.trueLeaderCooldown > 0) {
            --this.trueLeaderCooldown;
            return this.cachedTrueLeader;
        }
        JSHerdModule cur = this;
        HashSet<UUID> visited = new HashSet<UUID>();
        while (cur.herdLeader == null && cur.herdLeaderUUID != null && (class_19372 = cur.owner.method_37908()) instanceof class_3218) {
            JSAnimalBase b;
            class_3218 sl = (class_3218)class_19372;
            class_1297 e = sl.method_14190(cur.herdLeaderUUID);
            JSAnimalBase jSAnimalBase = cur.herdLeader = e instanceof JSAnimalBase && this.isEntityValid(b = (JSAnimalBase)e) ? b : null;
            if (cur.herdLeader != null) continue;
            break;
        }
        while (cur.herdLeader != null && cur.herdLeader != cur.owner) {
            UUID id = cur.herdLeader.method_5667();
            if (!visited.add(id)) {
                this.cachedTrueLeader = null;
                this.trueLeaderCooldown = 200;
                return null;
            }
            cur = cur.herdLeader.getModules().getHerdModule();
            if (cur.isFollower()) continue;
            break;
        }
        if (!this.isEntityValid(cur.owner)) {
            this.cachedTrueLeader = null;
            this.trueLeaderCooldown = 200;
            return null;
        }
        this.cachedTrueLeader = cur.owner;
        this.trueLeaderCooldown = 20;
        return this.cachedTrueLeader;
    }

    public double getHerdStrength() {
        if (!this.herdStrengthDirty) {
            return this.cachedHerdStrength;
        }
        if (this.owner == null || this.owner.isDead()) {
            this.cachedHerdStrength = 0.0;
            this.herdStrengthDirty = false;
            return 0.0;
        }
        double sum = JSHerdModule.getEntityStrength(this.owner);
        for (JSAnimalBase f : this.followers) {
            if (f == null || f.isDead()) continue;
            sum += JSHerdModule.getEntityStrength(f);
        }
        this.cachedHerdStrength = sum;
        this.herdStrengthDirty = false;
        return sum;
    }

    private static double getEntityStrength(JSAnimalBase e) {
        float w = e.method_17681();
        return (w *= e.getAggression()) * w * e.method_17682();
    }

    private void resolveLeaderByUUID() {
        JSAnimalBase b;
        if (this.herdLeader != null || this.herdLeaderUUID == null) {
            return;
        }
        class_1937 class_19372 = this.owner.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 sl = (class_3218)class_19372;
        if (this.leaderResolveCooldown > 0) {
            --this.leaderResolveCooldown;
            return;
        }
        this.leaderResolveCooldown = 10;
        class_1297 e = sl.method_14190(this.herdLeaderUUID);
        if (e instanceof JSAnimalBase && this.isEntityValid(b = (JSAnimalBase)e)) {
            this.herdLeader = b;
        }
    }

    private void ensureTwoWayLink() {
        if (this.herdLeader != null) {
            JSHerdModule lm = this.herdLeader.getModules().getHerdModule();
            if (!lm.followers.contains((Object)this.owner)) {
                lm.followers.add(this.owner);
            }
        }
    }

    private boolean isEntityValid(JSAnimalBase a) {
        return a != null && !a.isDead() && !a.method_31481();
    }

    private void cleanupFollowers() {
        if (this.followers.isEmpty()) {
            return;
        }
        UUID myId = this.owner.method_5667();
        this.followers.removeIf(f -> {
            if (f == null || f.isDead() || f.method_31481()) {
                return true;
            }
            JSHerdModule hm = f.getModules().getHerdModule();
            boolean pointsToUs = hm.herdLeader == this.owner || myId.equals(hm.herdLeaderUUID);
            return !pointsToUs;
        });
        this.herdStrengthDirty = true;
    }

    private boolean canHerdWith(JSAnimalBase other) {
        if (other == this.owner) {
            return false;
        }
        if (other.getModules().getGeneticModule().isIntolerant()) {
            return false;
        }
        for (Class<? extends class_1309> compatType : this.compatTypes) {
            if (!compatType.isInstance((Object)other)) continue;
            return true;
        }
        return false;
    }

    public JSAnimalBase getHerdLeader() {
        return this.herdLeader;
    }

    public UUID getHerdLeaderUUID() {
        return this.herdLeaderUUID;
    }

    public Set<JSAnimalBase> getFollowers() {
        return this.followers;
    }

    public boolean isMovingToLeader() {
        return this.isMovingToLeader;
    }

    public int getCheckCooldown() {
        return this.checkCooldown;
    }

    public int getLookCooldown() {
        return this.lookCooldown;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public int getMaxHerdSize() {
        return this.maxHerdSize;
    }

    public double getMinLeaderDist() {
        return this.minLeaderDist;
    }

    public JSSocialGroupProperties<?> getSocialProps() {
        return this.socialProps;
    }

    public Class<? extends class_1309>[] getCompatTypes() {
        return this.compatTypes;
    }

    public int getTrueLeaderCooldown() {
        return this.trueLeaderCooldown;
    }

    public JSAnimalBase getCachedTrueLeader() {
        return this.cachedTrueLeader;
    }

    public int getLeaderResolveCooldown() {
        return this.leaderResolveCooldown;
    }

    public boolean isHerdStrengthDirty() {
        return this.herdStrengthDirty;
    }

    public double getCachedHerdStrength() {
        return this.cachedHerdStrength;
    }

    public CompletableFuture<Void> getHerdMergeFuture() {
        return this.herdMergeFuture;
    }
}

