/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.modules.obj;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diet;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSAnimalModuleBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.JSHerdModule;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.entity.obj.other.IJSEdibleEntity;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3730;
import net.minecraft.class_4174;
import net.minecraft.class_5425;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersMain;
import travelers.server.animal.TravelersAnimal;

public class JSMetabolismModule
extends JSAnimalModuleBase {
    private boolean hungerEnabled;
    private boolean thirstEnabled;
    private boolean sleepEnabled;
    private boolean breedingEnabled;
    private boolean isInterrupted;
    private int breedingCooldown;
    private int maxHunger;
    private int maxThirst;
    private int maxGestation;
    private int ticksSleeping;
    private int interruptTicks = 0;
    private Diet diet;
    private JSGeneData fatherGeneData;

    public JSMetabolismModule(JSAnimalBase owner) {
        super(owner);
    }

    @Override
    public void saveNbt(class_2487 nbt) {
        nbt.method_10566("js.metabolism", (class_2520)this.owner.method_5841().method_12789(JSEntityDataHolder.metabolismData));
        if (this.fatherGeneData != null) {
            class_2487 tag = new class_2487();
            this.fatherGeneData.saveToNbt(tag);
            nbt.method_10566("js.metabolism.data.father", (class_2520)tag);
        }
    }

    @Override
    public void loadNbt(class_2487 nbt) {
        this.owner.method_5841().method_12778(JSEntityDataHolder.metabolismData, (Object)nbt.method_10562("js.metabolism"));
        this.fatherGeneData = JSGeneUtil.fromCompound(nbt.method_10562("js.metabolism.data.father"));
    }

    @Override
    public void init() {
        TravelersAnimal animal = this.owner.getAnimal();
        JSMetabolismProperties attributes = animal.getAnimalAttributes().getMetabolismProperties();
        this.hungerEnabled = this.owner.method_37908().method_8450().method_8355(JSCommon.ENABLE_METABOLISM) && animal.getAnimalAttributes().getMetabolismProperties().isHungerEnabled();
        this.thirstEnabled = this.owner.method_37908().method_8450().method_8355(JSCommon.ENABLE_METABOLISM) && animal.getAnimalAttributes().getMetabolismProperties().isThirstEnabled();
        this.breedingEnabled = this.owner.method_37908().method_8450().method_8355(JSCommon.ENABLE_METABOLISM) && animal.getAnimalAttributes().getMetabolismProperties().isCanBreed() && this.owner.getModules().getGeneticModule().isFertile();
        this.maxHunger = attributes.getMaxFood();
        this.maxThirst = attributes.getMaxWater();
        this.maxGestation = attributes.getGestationTicks();
    }

    @Override
    public void tick() {
        TravelersAnimal animal = this.owner.getAnimal();
        this.hungerEnabled = this.owner.method_37908().method_8450().method_8355(JSCommon.ENABLE_METABOLISM) && animal.getAnimalAttributes().getMetabolismProperties().isHungerEnabled();
        this.thirstEnabled = this.owner.method_37908().method_8450().method_8355(JSCommon.ENABLE_METABOLISM) && animal.getAnimalAttributes().getMetabolismProperties().isThirstEnabled();
        boolean bl = this.breedingEnabled = this.owner.method_37908().method_8450().method_8355(JSCommon.ENABLE_METABOLISM) && animal.getAnimalAttributes().getMetabolismProperties().isCanBreed() && this.owner.getModules().getGeneticModule().isFertile();
        if (this.interruptTicks > 0) {
            --this.interruptTicks;
        } else if (this.isInterrupted) {
            this.isInterrupted = false;
        }
    }

    public Diet getDiet() {
        if (this.diet != null) {
            return this.diet;
        }
        this.diet = this.owner.getAnimal().getAnimalAttributes().getMetabolismProperties().getDietSupplier().get();
        return this.diet;
    }

    @Override
    public void serverAiStep() {
        if (this.maxHunger == -1 || this.maxThirst == -1) {
            this.init();
        }
        if (this.owner.isMoving()) {
            if (this.hungerEnabled) {
                int hunger = this.getHunger();
                this.setHunger(Math.max(0, hunger - 1));
                if (hunger == 0 && this.owner.method_59922().method_43058() > 0.8) {
                    this.owner.method_5643(this.owner.method_37908().method_48963().method_48825(), 2.0f);
                }
            }
            if (this.thirstEnabled) {
                int thirst = this.getThirst();
                this.setThirst(Math.max(0, thirst - 1));
                if (thirst == 0 && this.owner.method_59922().method_43058() > 0.8) {
                    this.owner.method_5643(this.owner.method_37908().method_48963().method_48834(), 2.0f);
                }
            }
        }
        if (this.breedingEnabled) {
            int gest = this.getGestation();
            if (this.fatherGeneData != null) {
                this.setGestation(Math.max(0, gest - 1));
                if (gest == 0) {
                    this.owner.onGestationFinished(this.fatherGeneData);
                }
            }
            if (this.getBreedingCooldown() > 0) {
                this.setBreedingCooldown(Math.max(0, this.getBreedingCooldown() - 1));
            }
        }
    }

    public boolean isHungry() {
        return this.hungerPercentage() < 0.75;
    }

    public boolean isThirsty() {
        return this.thirstPercentage() < 0.75;
    }

    public int getHunger() {
        class_2487 data = (class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.metabolismData);
        return Math.min(this.maxHunger, data.method_10550("js.metabolism.hunger"));
    }

    public void setHunger(int newHunger) {
        class_2487 data = ((class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.metabolismData)).method_10553();
        data.method_10569("js.metabolism.hunger", Math.min(this.maxHunger, newHunger));
        this.owner.method_5841().method_12778(JSEntityDataHolder.metabolismData, (Object)data);
    }

    public int getThirst() {
        class_2487 data = (class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.metabolismData);
        return Math.min(this.maxThirst, data.method_10550("js.metabolism.thirst"));
    }

    public void setThirst(int newThirst) {
        class_2487 data = ((class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.metabolismData)).method_10553();
        data.method_10569("js.metabolism.thirst", Math.min(this.maxThirst, newThirst));
        this.owner.method_5841().method_12778(JSEntityDataHolder.metabolismData, (Object)data);
    }

    public int getGestation() {
        class_2487 data = (class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.metabolismData);
        return data.method_10550("js.metabolism.gestation");
    }

    public void setGestation(int newGestation) {
        class_2487 data = ((class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.metabolismData)).method_10553();
        data.method_10569("js.metabolism.gestation", newGestation);
        this.owner.method_5841().method_12778(JSEntityDataHolder.metabolismData, (Object)data);
    }

    public int getBreedingCooldown() {
        class_2487 data = (class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.metabolismData);
        return data.method_10550("js.metabolism.breedingcooldown");
    }

    private void setBreedingCooldown(int newGestation) {
        class_2487 data = ((class_2487)this.owner.method_5841().method_12789(JSEntityDataHolder.metabolismData)).method_10553();
        data.method_10569("js.metabolism.breedingcooldown", newGestation);
        this.owner.method_5841().method_12778(JSEntityDataHolder.metabolismData, (Object)data);
    }

    public void maxBreedingCooldown() {
        this.setBreedingCooldown((int)((float)this.maxGestation / 2.0f));
    }

    public void setBreedingParentDNA(JSGeneData data) {
        this.fatherGeneData = data;
        if (TravelersMain.isDebugging()) {
            this.setGestation(500);
        } else {
            this.setGestation(this.maxGestation);
        }
    }

    public void clearBreedingParentData() {
        this.fatherGeneData = null;
        this.setGestation(0);
    }

    @Override
    public void finalizeSpawn(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 spawnType, @Nullable class_1315 spawnGroupData) {
        this.setMax();
    }

    public void setMax() {
        this.setThirst(this.owner.getAnimal().getAnimalAttributes().getMetabolismProperties().getMaxWater());
        this.setHunger(this.owner.getAnimal().getAnimalAttributes().getMetabolismProperties().getMaxFood());
        this.setBreedingCooldown(this.maxGestation / 2);
    }

    public boolean canTarget(class_1309 mob) {
        return this.canTarget(true, false, (class_1297)mob);
    }

    public boolean canTarget(boolean withBias, boolean revenge, class_1297 mob) {
        if (this.owner.getModules().getGeneticModule().isIntolerant()) {
            return true;
        }
        if (!revenge && this.owner.method_5864() == mob.method_5864() && this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getMaxHerdSize() > 1) {
            return false;
        }
        boolean canTarget = false;
        if (!revenge) {
            if (this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getHuntTargets().contains(mob.getClass())) {
                canTarget = true;
            } else {
                for (Class<class_1297> huntTarget : this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getHuntTargets()) {
                    if (!huntTarget.isInstance(mob) && mob.getClass() != huntTarget) continue;
                    canTarget = true;
                    this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getHuntTargets().add(mob.getClass());
                    break;
                }
            }
            if (!canTarget) {
                return false;
            }
        }
        if (withBias) {
            JSAnimalBase animalBase;
            JSHerdModule otherHerd;
            JSHerdModule herdModule;
            float naturalAggresion;
            double boundingPoints = this.owner.method_17682() + this.owner.method_17681();
            double otherPoints = mob.method_17682() + mob.method_17681();
            double aggression = this.owner.getAggression();
            double hungerBias = this.hungerPercentage();
            if (!revenge) {
                otherPoints *= 1.0 + hungerBias;
            }
            if (aggression > 0.0) {
                boundingPoints += boundingPoints * Math.min(aggression, 0.5);
            }
            if ((naturalAggresion = this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getNaturalAggression()) > 0.0f) {
                boundingPoints += boundingPoints * (double)naturalAggresion;
            }
            if ((herdModule = this.owner.getModules().getHerdModule()) != null) {
                JSAnimalBase leader;
                if (herdModule.isLeader()) {
                    int size = herdModule.getHerdSize();
                    boundingPoints += boundingPoints * ((double)size * 0.25);
                } else if (herdModule.isFollower() && (leader = herdModule.getTrueLeader()) != null) {
                    if (leader.method_5968() != null) {
                        int size = leader.getModules().getHerdModule().getHerdSize();
                        boundingPoints += boundingPoints * ((double)size * 0.25);
                    } else {
                        return false;
                    }
                }
            }
            if (mob instanceof JSAnimalBase && (otherHerd = (animalBase = (JSAnimalBase)mob).getModules().getHerdModule()) != null) {
                JSHerdModule otherLeaderHerd;
                JSAnimalBase otherLeader;
                int otherSize = 0;
                if (otherHerd.isLeader()) {
                    otherSize = otherHerd.getHerdSize();
                } else if (otherHerd.isFollower() && (otherLeader = otherHerd.getTrueLeader()) != null && (otherLeaderHerd = otherLeader.getModules().getHerdModule()) != null) {
                    otherSize = otherLeaderHerd.getHerdSize();
                }
                if (--otherSize > 0) {
                    otherPoints += otherPoints * ((double)otherSize * 0.6);
                }
            }
            return boundingPoints >= otherPoints * 0.75;
        }
        return true;
    }

    public double hungerPercentage() {
        double value = (double)this.getHunger() / (double)this.maxHunger;
        return value;
    }

    public double thirstPercentage() {
        double value = (double)this.getThirst() / (double)this.maxThirst;
        return value;
    }

    public double gestationPercentage() {
        double value = (double)this.getGestation() / (double)this.maxGestation;
        return value;
    }

    public void interrupt(int ticks) {
        this.isInterrupted = true;
        this.interruptTicks = ticks;
        this.owner.setSleeping(false);
        this.owner.setResting(false);
    }

    public void eatEntity(IJSEdibleEntity edible) {
        this.setHunger(this.getHunger() + edible.getFoodPoints(this.owner));
    }

    public boolean canEatCorpse(JSAnimalBase edible) {
        return true;
    }

    public void eatCorpse(JSAnimalBase edible) {
        edible.method_5643(edible.method_37908().method_48963().method_48812((class_1309)this.owner), 5.0f);
        this.setHunger((int)((float)this.getHunger() + 1000.0f * (edible.method_17681() + edible.method_17682())));
    }

    public void addThirst(int thirst) {
        this.setThirst(this.getThirst() + thirst);
    }

    public void addFood(int thirst) {
        this.setHunger(this.getThirst() + thirst);
    }

    public boolean eatItem(class_1799 stack) {
        if (this.getDiet().canEatItem(stack)) {
            double foodValue = 100.0;
            class_4174 food = (class_4174)stack.method_57824(class_9334.field_50075);
            if (food != null) {
                foodValue += (double)(3500.0f * ((float)food.comp_2491() * food.comp_2492()));
            }
            this.setHunger((int)((double)this.getHunger() + foodValue));
            return true;
        }
        return false;
    }

    public boolean isGestating() {
        return this.getGestation() > 0 || this.fatherGeneData != null;
    }

    public boolean isBreedingInCooldown() {
        return this.getBreedingCooldown() > 0;
    }

    public void resetBreedingCooldown() {
        this.setBreedingCooldown(0);
    }

    public boolean isHungerEnabled() {
        return this.hungerEnabled;
    }

    public boolean isThirstEnabled() {
        return this.thirstEnabled;
    }

    public boolean isSleepEnabled() {
        return this.sleepEnabled;
    }

    public boolean isBreedingEnabled() {
        return this.breedingEnabled;
    }

    public boolean isInterrupted() {
        return this.isInterrupted;
    }

    public int getMaxHunger() {
        return this.maxHunger;
    }

    public int getMaxThirst() {
        return this.maxThirst;
    }

    public int getMaxGestation() {
        return this.maxGestation;
    }

    public int getTicksSleeping() {
        return this.ticksSleeping;
    }

    public JSGeneData getFatherGeneData() {
        return this.fatherGeneData;
    }
}

