/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.nav.eval;

import net.minecraft.class_1922;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.TravelersWalkNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;

public class JSCrabNodeEvaluator
extends TravelersWalkNodeEvaluator {
    private float oldWalkableCost;
    private float oldWaterBorderCost;
    private final class_2338.class_2339 tmp = new class_2338.class_2339();
    private final class_2338.class_2339 tmp2 = new class_2338.class_2339();

    public void prepare(@NotNull class_1950 level, @NotNull SmartAnimalBase mob) {
        super.prepare(level, mob);
        mob.setPathfindingMalus(TravelersPathType.WATER, 0.0f);
        this.oldWalkableCost = mob.getPathfindingMalus(TravelersPathType.WALKABLE);
        mob.setPathfindingMalus(TravelersPathType.WALKABLE, 6.0f);
        this.oldWaterBorderCost = mob.getPathfindingMalus(TravelersPathType.WATER_BORDER);
        mob.setPathfindingMalus(TravelersPathType.WATER_BORDER, 0.5f);
    }

    public void done() {
        if (this.mob != null) {
            this.mob.setPathfindingMalus(TravelersPathType.WALKABLE, this.oldWalkableCost);
            this.mob.setPathfindingMalus(TravelersPathType.WATER_BORDER, this.oldWaterBorderCost);
        }
        super.done();
    }

    @NotNull
    public TravelersNode getStart() {
        return !this.mob.method_5799() ? super.getStart() : this.getInnerStart();
    }

    @NotNull
    private TravelersNode getInnerStart() {
        class_238 box = this.mob.method_5829();
        double cx = (box.field_1323 + box.field_1320) * 0.5;
        double cy = (box.field_1322 + box.field_1325) * 0.5;
        double cz = (box.field_1321 + box.field_1324) * 0.5;
        int y = class_3532.method_15357((double)cy);
        this.tmp.method_10102(cx, (double)y, cz);
        class_2680 state = this.context.getBlockState((class_2338)this.tmp);
        if (!state.method_26227().method_39360((class_3611)class_3612.field_15910)) {
            boolean found = false;
            for (int dy = 1; dy <= 6; ++dy) {
                this.tmp.method_10102(cx, (double)(y - dy), cz);
                if (this.context.getBlockState((class_2338)this.tmp).method_26227().method_39360((class_3611)class_3612.field_15910)) {
                    y -= dy;
                    found = true;
                    break;
                }
                this.tmp.method_10102(cx, (double)(y + dy), cz);
                if (!this.context.getBlockState((class_2338)this.tmp).method_26227().method_39360((class_3611)class_3612.field_15910)) continue;
                y += dy;
                found = true;
                break;
            }
            if (!found) {
                y = class_3532.method_15357((double)this.mob.method_23318());
            }
        }
        this.tmp.method_33098(y);
        return this.getNode((class_2338)this.tmp);
    }

    public TravelersNodeEvaluator copy() {
        JSCrabNodeEvaluator e = new JSCrabNodeEvaluator();
        this.applyDefaultProperties((TravelersNodeEvaluator)e);
        e.setCanClimb(this.isCanClimb());
        e.setCanClimbAnyBlock(this.isCanClimbAnyBlock());
        return e;
    }

    public int getNeighbors(TravelersNode[] arr, TravelersNode node) {
        int count = super.getNeighbors(arr, node);
        TravelersPathType above = this.getPathType(node.x, node.y + 1, node.z);
        TravelersPathType at = this.getPathType(node.x, node.y, node.z);
        int stepAllowance = this.mob.getPathfindingMalus(above) >= 0.0f && at != TravelersPathType.STICKY_HONEY ? class_3532.method_15375((float)Math.max(1.0f, this.mob.method_49476())) : 0;
        stepAllowance = Math.min(stepAllowance, 1);
        this.tmp.method_10103(node.x, node.y, node.z);
        double floorY = this.getFloorLevel((class_2338)this.tmp);
        TravelersNode up = this.findAcceptedNode(node, node.x, node.y + 1, node.z, 0, floorY, class_2350.field_11036, at);
        TravelersNode down = this.findAcceptedNode(node, node.x, node.y - 1, node.z, 1, floorY, class_2350.field_11033, at);
        if (this.mob.method_5799() && this.isVerticalNeighborValid(up, node)) {
            arr[count++] = up;
        }
        if (this.isVerticalNeighborValid(down, node) && at != TravelersPathType.TRAPDOOR) {
            arr[count++] = down;
        }
        return this.applyCrabMovementBias(arr, count, node);
    }

    private boolean isVerticalNeighborValid(TravelersNode n, TravelersNode base) {
        if (n == null) {
            return false;
        }
        if (!this.isNeighborValid(n, base)) {
            return false;
        }
        if (n.type != TravelersPathType.WATER) {
            return false;
        }
        this.tmp.method_10103(n.x, n.y, n.z);
        double floorY = this.getFloorLevel((class_2338)this.tmp);
        return floorY - (double)n.y <= 1.5;
    }

    private int applyCrabMovementBias(TravelersNode[] arr, int count, TravelersNode base) {
        class_2350 facing = this.mob.method_5735();
        class_2350 left = facing.method_10160();
        class_2350 right = facing.method_10170();
        for (int i = 0; i < count; ++i) {
            class_2350 d;
            TravelersNode n = arr[i];
            if (n == null || (d = this.horizontalDir(n, base)) == null) continue;
            if (d == left || d == right) {
                n.costMalus *= 0.3f;
                continue;
            }
            n.costMalus *= 1.8f;
        }
        return count;
    }

    private class_2350 horizontalDir(TravelersNode to, TravelersNode from) {
        int dx = to.x - from.x;
        int dz = to.z - from.z;
        if (dx == 1 && dz == 0) {
            return class_2350.field_11034;
        }
        if (dx == -1 && dz == 0) {
            return class_2350.field_11039;
        }
        if (dz == 1 && dx == 0) {
            return class_2350.field_11035;
        }
        if (dz == -1 && dx == 0) {
            return class_2350.field_11043;
        }
        return null;
    }

    protected TravelersNode findAcceptedNode(TravelersNode parent, int x, int y, int z, int step, double floor, class_2350 dir, TravelersPathType baseType) {
        TravelersNode node = super.findAcceptedNode(parent, x, y, z, step, floor, dir, baseType);
        if (node == null) {
            return null;
        }
        TravelersPathType type = this.getPathType(this.context, node.x, node.y, node.z);
        if (type == TravelersPathType.WATER) {
            int snappedY = this.findWaterFloorY(this.context, node.x, node.y, node.z);
            if (snappedY == Integer.MIN_VALUE) {
                return null;
            }
            node.y = snappedY;
            if (!this.hasWaterSolidSupport(this.context, node.x, node.y, node.z)) {
                return null;
            }
        }
        return node;
    }

    private int findWaterFloorY(TravelersPathfindingContext ctx, int x, int y, int z) {
        class_2338.class_2339 m = this.tmp;
        for (int dy = 0; dy < 8; ++dy) {
            m.method_10103(x, y - dy, z);
            class_2680 bs = ctx.getBlockState((class_2338)m);
            if (bs.method_26227().method_39360((class_3611)class_3612.field_15910)) continue;
            class_2338.class_2339 solidPos = this.tmp2;
            solidPos.method_10103(x, y - dy, z);
            class_2680 below = ctx.getBlockState((class_2338)solidPos);
            if (!below.method_26220((class_1922)ctx.level(), (class_2338)solidPos).method_1110()) {
                return y - dy + 1;
            }
            return Integer.MIN_VALUE;
        }
        return Integer.MIN_VALUE;
    }

    private boolean hasWaterSolidSupport(TravelersPathfindingContext ctx, int x, int y, int z) {
        this.tmp.method_10103(x, y - 1, z);
        class_2680 bs = ctx.getBlockState((class_2338)this.tmp);
        return !bs.method_26220((class_1922)ctx.level(), (class_2338)this.tmp).method_1110();
    }

    protected boolean isAmphibious() {
        return true;
    }

    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext ctx, int x, int y, int z) {
        TravelersPathType at = ctx.getPathTypeFromState(x, y, z);
        if (at == TravelersPathType.WATER) {
            for (class_2350 dir : class_2350.values()) {
                this.tmp2.method_10103(x, y, z).method_10098(dir);
                TravelersPathType adj = ctx.getPathTypeFromState(this.tmp2.method_10263(), this.tmp2.method_10264(), this.tmp2.method_10260());
                if (adj != TravelersPathType.BLOCKED) continue;
                return TravelersPathType.WATER_BORDER;
            }
            return TravelersPathType.WATER;
        }
        return super.getPathType(ctx, x, y, z);
    }
}

