/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat;

import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAquaticBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.JSHerdModule;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatFollowTask;
import jp.jurassicsaga.server.base.entity.obj.other.SeatEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_2183;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;

public class JSHerdCombatFollowTask
extends JSCombatFollowTask {
    private boolean callOut = false;
    private boolean isNearEnoughToBody = false;
    private int callingTicks = 0;
    private int maxCallingTicks = 0;
    private boolean shouldObserve = false;
    private int reachTries = 0;
    private int observeTicks = 0;
    private int maxObserveTicks = 40;
    private final int maxFollowTicks = 2000;
    private int followTicks = 0;
    private double distance = Double.MAX_VALUE;
    private State state = State.AGGRESSIVE;
    private static final double RUN_AWAY_DIST = 10.0;

    public JSHerdCombatFollowTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    public JSHerdCombatFollowTask shouldCallout(boolean callOut, int callingTicks) {
        this.callOut = callOut;
        this.callingTicks = callingTicks;
        this.maxCallingTicks = callingTicks;
        return this;
    }

    public JSCombatFollowTask observe() {
        this.shouldObserve = true;
        return this;
    }

    @Override
    public boolean shouldRun() {
        class_1309 leaderTarget;
        JSHerdModule herdModule;
        class_1657 player;
        class_1309 class_13092;
        if (this.animal.isDead()) {
            return false;
        }
        if (this.animal.getModules().getMetabolismModule().isThirsty()) {
            return false;
        }
        if (this.animal.method_5968() != null && (class_13092 = this.animal.method_5968()) instanceof class_1657 && (player = (class_1657)class_13092).method_7337()) {
            if (player.method_5854() != null) {
                SeatEntity e;
                class_1297 class_12972 = player.method_5854();
                if (class_12972 instanceof SeatEntity && (e = (SeatEntity)class_12972).getJsVehicle() == null) {
                    this.animal.method_5980(null);
                    return false;
                }
            } else {
                this.animal.method_5980(null);
                return false;
            }
        }
        if ((herdModule = this.animal.getModules().getHerdModule()).isFollower() && (leaderTarget = herdModule.getHerdLeader().method_5968()) != null && leaderTarget.method_5805()) {
            return true;
        }
        return this.animal.method_5968() != null && this.animal.method_5968().method_5805();
    }

    @Override
    public void onStart() {
        class_1309 target;
        class_1309 leaderTarget;
        JSHerdModule herdModule;
        if (this.animal.isResting() || this.animal.method_6113()) {
            this.animal.getModules().getMetabolismModule().interrupt(20);
        }
        if ((herdModule = this.animal.getModules().getHerdModule()).isFollower() && (leaderTarget = herdModule.getHerdLeader().method_5968()) != null && leaderTarget.method_5805()) {
            this.animal.method_5980(leaderTarget);
        }
        if ((target = this.animal.method_5968()) == null) {
            return;
        }
        if (!this.animal.method_6510() && this.callOut && this.random.nextDouble() < 0.875 && herdModule.getFollowers().isEmpty()) {
            this.state = State.CALLING;
            this.animal.curCallingTicks = 30;
        } else if (!this.animal.method_6510() && this.shouldObserve && !this.isTargetRunningAway(target) && this.animal.method_6065() == null) {
            this.state = State.OBSERVING;
            this.observeTicks = 100;
            this.animal.setObserving(true);
        } else {
            this.state = State.AGGRESSIVE;
        }
        this.recomputePathTicks = 0;
    }

    @Override
    public void tick() {
        class_1309 target;
        if (this.animal.isResting() || this.animal.method_6113()) {
            this.animal.getModules().getMetabolismModule().interrupt(400);
        }
        if ((target = this.animal.method_5968()) == null) {
            this.stop();
            return;
        }
        switch (this.state.ordinal()) {
            case 0: {
                this.tickCalling(target);
                break;
            }
            case 1: {
                this.tickObserving(target);
                break;
            }
            case 2: {
                this.tickStalking(target);
                break;
            }
            case 3: {
                this.tickAggresive(target);
            }
        }
    }

    protected void tickCalling(class_1309 target) {
        this.animal.method_19540(false);
        if (this.shouldStalk && !this.isTargetRunningAway(target) && !this.canTargetSeeMe(target, (class_1314)this.animal)) {
            this.state = State.STALKING;
            this.animal.setStalking(true);
            return;
        }
        if (this.callingTicks > 0) {
            --this.callingTicks;
            this.animal.method_55695();
            if (this.random.nextDouble() < (double)0.05f) {
                this.callingTicks -= 5;
            }
        } else {
            State state = this.state = this.shouldObserve ? State.OBSERVING : State.AGGRESSIVE;
            if (this.state == State.OBSERVING) {
                this.observeTicks = this.maxObserveTicks;
                this.animal.setObserving(true);
            }
        }
    }

    protected void tickObserving(class_1309 target) {
        JSAnimalBase base;
        this.animal.method_19540(false);
        if (this.animal.method_5799() && !(this.animal instanceof JSAquaticBase)) {
            this.switchState(this.state, State.AGGRESSIVE);
            this.state = State.AGGRESSIVE;
            this.animal.method_19540(true);
            return;
        }
        if (target instanceof JSAnimalBase && (base = (JSAnimalBase)target).isDead()) {
            this.state = State.AGGRESSIVE;
            this.animal.method_19540(true);
            this.animal.setStalking(false);
        }
        if (this.observeTicks > 0 && this.shouldObserve) {
            JSAnimalBase base2;
            --this.observeTicks;
            this.animal.method_55695();
            double difference = target.method_23320() - this.animal.method_23320();
            if (target instanceof JSAnimalBase && (base2 = (JSAnimalBase)target).isDead()) {
                difference = 0.0;
            }
            class_243 nextPos = new class_243(target.method_23317(), this.animal.method_23318() + difference, target.method_23321());
            this.animal.method_5702(class_2183.class_2184.field_9853, nextPos);
            if (this.isTargetRunningAway(target)) {
                this.switchState(this.state, State.AGGRESSIVE);
                this.state = State.AGGRESSIVE;
                this.animal.method_19540(true);
            }
        } else {
            this.animal.setObserving(false);
            if (this.extraCheckBeforeSwitch(target, this.animal)) {
                if (!this.canTargetSeeMe(target, (class_1314)this.animal) && this.shouldStalk) {
                    this.state = State.STALKING;
                    this.animal.setStalking(true);
                } else {
                    this.switchState(this.state, State.AGGRESSIVE);
                }
            } else {
                this.stop();
                return;
            }
        }
    }

    protected void tickStalking(class_1309 target) {
        JSAnimalBase base;
        if (target instanceof JSAnimalBase && (base = (JSAnimalBase)target).isDead()) {
            this.state = State.AGGRESSIVE;
            this.animal.method_19540(true);
            this.animal.setStalking(false);
        }
        this.followTicks = this.animal.isMoving() ? (this.followTicks += 5) : (this.followTicks += 25);
        this.animal.method_19540(false);
        if (target.method_5858((class_1297)this.animal) <= (double)this.animal.getAttackReach() || this.canTargetSeeMe(target, (class_1314)this.animal) || this.isTargetRunningAway(target)) {
            this.animal.setStalking(false);
            this.animal.method_19540(true);
            this.state = State.AGGRESSIVE;
        } else {
            this.handleMoveTowards(target, 1.0);
        }
        if (this.followTicks > 2000) {
            this.cancel(target);
        }
    }

    protected void tickAggresive(class_1309 target) {
        JSAnimalBase base;
        if (target instanceof JSAnimalBase && !(base = (JSAnimalBase)target).isDead()) {
            base.notifyAboutMe(this.animal);
        }
        this.followTicks = this.animal.isMoving() ? (!this.isGainingOnTarget(target, this.animal) ? (this.followTicks += 5) : 0) : (this.followTicks += 25);
        this.animal.method_19540(true);
        this.handleMoveTowards(target, 1.0);
        if (this.attackCooldown == 0) {
            if (target.method_5858((class_1297)this.animal) <= (double)this.animal.getAttackReach()) {
                this.attack(target);
                this.recomputePathTicks += 5;
                this.attackResetTime = this.attackCooldown;
            }
        } else {
            --this.attackCooldown;
        }
        if (this.followTicks > 2000) {
            this.cancel(target);
        }
    }

    private boolean isGainingOnTarget(class_1309 target, JSAnimalBase animal) {
        double distance = target.method_5739((class_1297)animal);
        if (distance < this.distance) {
            this.distance = distance;
            return true;
        }
        this.distance = distance;
        return false;
    }

    protected void switchState(State state, State newState) {
        this.state = newState;
        if (newState == State.AGGRESSIVE) {
            this.animal.method_19540(true);
        }
    }

    private void cancel(class_1309 target) {
        this.animal.blackListAnimal(target);
        this.stop();
    }

    private void handleMoveTowards(class_1309 target, double speed) {
        JSAnimalBase base;
        if (target.method_5858((class_1297)this.animal) <= (double)this.animal.getAttackReach() && target instanceof JSAnimalBase && (base = (JSAnimalBase)target).isDead()) {
            this.animal.getNavigationController().stop();
            this.isNearEnoughToBody = true;
            this.animal.method_5988().method_19615(target.method_19538());
            return;
        }
        if (this.isNearEnoughToBody) {
            this.isNearEnoughToBody = false;
            this.animal.getNavigationController().setFrozen(false);
        }
        if (this.animal.getNavigationController().isDone() || this.recomputePathTicks == 0) {
            class_243 aheadPos;
            class_243 targetPos = target.method_19538();
            class_243 targetVel = target.method_18798();
            if (targetVel.method_1027() > 4.0E-4) {
                class_243 targetLook = target.method_5720().method_1029();
                double distanceAhead = 1.0;
                aheadPos = targetPos.method_1019(targetLook.method_1021(distanceAhead));
            } else {
                aheadPos = targetPos;
            }
            CompletableFuture moveTo = this.animal.getNavigationController().moveTo(aheadPos.field_1352, aheadPos.field_1351, aheadPos.field_1350);
            if (moveTo != null) {
                moveTo.thenAccept(path -> {
                    if (path == null) {
                        this.recomputePathTicks += 20;
                    } else if (!path.canReach()) {
                        ++this.reachTries;
                        if (this.reachTries > 10) {
                            this.cancel(target);
                        }
                    } else {
                        float aSpeed = this.animal.method_6029() * 8.0f;
                        if ((float)path.getNodeCount() < aSpeed) {
                            path.setNextNodeIndex(path.getNodeCount());
                        } else {
                            path.setNextNodeIndex((int)aSpeed);
                        }
                    }
                });
            } else {
                this.recomputePathTicks += 20;
            }
            this.recomputePathTicks += this.random.nextInt(20, 40);
        } else {
            --this.recomputePathTicks;
        }
    }

    protected void attack(class_1309 target) {
        this.animal.attack(target);
        this.followTicks = 0;
    }

    protected boolean extraCheckBeforeSwitch(class_1309 target, JSAnimalBase animal) {
        return true;
    }

    protected boolean canTargetSeeMe(class_1309 target, class_1314 entity) {
        double minDot;
        class_243 toEntity;
        class_243 entityEyes;
        if (target.method_37908() != entity.method_37908()) {
            return false;
        }
        class_243 targetEyes = new class_243(target.method_23317(), target.method_23320(), target.method_23321());
        if (targetEyes.method_1022(entityEyes = new class_243(entity.method_23317(), entity.method_23320(), entity.method_23321())) > 64.0) {
            return false;
        }
        class_243 forward = target.method_5720().method_1029();
        double dot = forward.method_1026(toEntity = entityEyes.method_1020(targetEyes).method_1029());
        return dot >= (minDot = Math.cos(Math.toRadians(67.5))) && target.method_37908().method_17742(new class_3959(targetEyes, entityEyes, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)target)).method_17783() == class_239.class_240.field_1333;
    }

    protected boolean isTargetRunningAway(class_1309 target) {
        class_243 targetMove;
        double dist = this.animal.method_5739((class_1297)target);
        if (dist < 10.0) {
            return false;
        }
        class_243 toAnimal = this.animal.method_19538().method_1020(target.method_19538()).method_1029();
        return toAnimal.method_1026(targetMove = target.method_18798().method_1029()) < -0.1;
    }

    @Override
    public void onStop() {
        super.onStop();
        this.recomputePathTicks = 0;
        this.callingTicks = this.maxCallingTicks;
        this.animal.getNavigationController().setFrozen(false);
        this.animal.setObserving(false);
        this.animal.method_5980(null);
        this.animal.setStalking(false);
        this.animal.method_19540(false);
        this.state = State.AGGRESSIVE;
        this.reachTries = 0;
        this.followTicks = 0;
    }

    protected static enum State {
        CALLING,
        OBSERVING,
        STALKING,
        AGGRESSIVE;

    }
}

