/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diet;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import jp.jurassicsaga.server.base.entity.obj.other.IJSEdibleEntity;
import jp.jurassicsaga.server.base.entity.obj.physics.HaybaleEntity;
import jp.jurassicsaga.server.base.entity.obj.physics.MeatEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.server.MinecraftServer;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSFindFoodTask
extends JSTaskBase {
    protected volatile class_1297 targetEntity;
    private volatile boolean shouldMoveToLastKnown;
    protected boolean setTargetTypes = true;
    protected boolean targetMeatCubes;
    protected boolean targetHayCubes;
    private static final AtomicInteger GLOBAL_PENDING_PATHS = new AtomicInteger();
    private static final int MAX_GLOBAL_CONCURRENT_PATHS = 64;
    private static final int SEARCH_INTERVAL = 20;
    private static final int MAX_CANDIDATES = 16;
    private static final int MAX_REQS_PER_SEARCH = 3;
    private static final int MAX_CONCURRENT_PATHS = 4;
    private static final int CACHE_EXPIRY = 40;
    private static final int MAX_RANGE = 96;
    private static final int VISIBILITY_BUDGET = 8;
    private static final double JITTER = 0.25;
    private final AtomicInteger pendingPathChecks = new AtomicInteger();
    private final List<class_1297> candidateCache = Collections.synchronizedList(new ArrayList(32));
    private int cacheTick = -9999;
    private int ticks;
    private int checkCooldown;

    public JSFindFoodTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.getGoals().add(TaskGoal.METABOLISM);
        this.getGoals().add(TaskGoal.MOVEMENT);
    }

    public TaskPriority getPriority() {
        if (this.animal.isDead()) {
            return TaskPriority.NONE;
        }
        double h = this.animal.getModules().getMetabolismModule().hungerPercentage();
        if (h > 0.8) {
            return TaskPriority.LOW;
        }
        if (h > 0.6) {
            return TaskPriority.MEDIUM;
        }
        if (h > 0.4) {
            return TaskPriority.HIGH;
        }
        if (h > 0.2) {
            return TaskPriority.VERY_HIGH;
        }
        return TaskPriority.DIRECT;
    }

    public boolean shouldRun() {
        if (this.animal.isDead() || this.animal.getModules().getMetabolismModule().getDiet() == null) {
            return false;
        }
        if (!this.animal.getAnimal().getAnimalAttributes().getMetabolismProperties().isHungerEnabled()) {
            return false;
        }
        if (!this.animal.getModules().getMetabolismModule().isHungry()) {
            return false;
        }
        Diet diet = this.animal.getModules().getMetabolismModule().getDiet();
        this.targetMeatCubes = diet.isCanEatMeatCube();
        this.targetHayCubes = diet.isCanEatHaybale();
        if (this.targetEntity != null && !this.targetEntity.method_5805()) {
            this.targetEntity = null;
        }
        if (this.targetEntity == null && this.ticks - this.cacheTick >= 20) {
            this.findTargets(128.0f, null);
            this.cacheTick = this.ticks;
        }
        ++this.ticks;
        return this.targetEntity != null || this.shouldMoveToLastKnown;
    }

    public boolean canInterrupt() {
        return this.targetEntity == null;
    }

    public void onStart() {
        if (!this.shouldMoveToLastKnown && this.targetEntity != null && !this.animal.getNavigationController().isLookingForPath()) {
            this.submitPathRequest(this.targetEntity.method_24515());
        }
    }

    public boolean requiresUpdateEveryTick() {
        return this.targetEntity != null || this.shouldMoveToLastKnown;
    }

    public void tick() {
        if (this.checkCooldown > 0) {
            --this.checkCooldown;
        }
        if (this.shouldMoveToLastKnown) {
            this.shouldMoveToLastKnown = false;
        }
        if (this.isCloseToTarget()) {
            this.eatTarget();
            return;
        }
        if (this.targetEntity != null && this.animal.getNavigationController().isDone() && this.checkCooldown <= 0) {
            this.submitPathRequest(this.targetEntity.method_24515());
            this.checkCooldown = 40;
        }
    }

    public void cleanUp() {
        super.cleanUp();
        this.shouldMoveToLastKnown = false;
        this.pendingPathChecks.set(0);
        this.candidateCache.clear();
    }

    public void onStop() {
        this.targetEntity = null;
        this.animal.method_19540(false);
    }

    private void submitPathRequest(class_2338 dest) {
        if (this.pendingPathChecks.get() >= 4) {
            return;
        }
        if (GLOBAL_PENDING_PATHS.get() >= 64) {
            return;
        }
        CompletableFuture future = this.animal.getNavigationController().createPath(dest, 0.0);
        if (future == null) {
            return;
        }
        this.pendingPathChecks.incrementAndGet();
        GLOBAL_PENDING_PATHS.incrementAndGet();
        future.thenAccept(jsPath -> JSFindFoodTask.runOnMainThread(this.animal.method_37908(), () -> {
            try {
                if (jsPath != null) {
                    this.animal.getNavigationController().moveTo(jsPath);
                    this.animal.method_19540(true);
                }
            }
            finally {
                this.pendingPathChecks.decrementAndGet();
                GLOBAL_PENDING_PATHS.decrementAndGet();
            }
        }));
    }

    /*
     * Unable to fully structure code
     */
    private void eatTarget() {
        block6: {
            block8: {
                block7: {
                    this.animal.getNavigationController().stop();
                    this.animal.method_55695();
                    if (this.animal.curEatTicks == 0) {
                        this.animal.curEatTicks = 20;
                    }
                    if (this.targetEntity != null) {
                        this.animal.method_5702(class_2183.class_2184.field_9851, this.targetEntity.method_19538());
                    }
                    if (this.animal.curEatTicks > 5) break block6;
                    var4_1 = this.targetEntity;
                    if (!(var4_1 instanceof IJSEdibleEntity)) break block7;
                    edible = (IJSEdibleEntity)var4_1;
                    this.animal.getModules().getMetabolismModule().addFood(5000);
                    this.targetEntity.method_31472();
                    break block8;
                }
                var4_1 = this.targetEntity;
                if (!(var4_1 instanceof JSAnimalBase)) ** GOTO lbl-1000
                corpse = (JSAnimalBase)var4_1;
                if (this.animal.getModules().getMetabolismModule().canEatCorpse(corpse)) {
                    this.animal.getModules().getMetabolismModule().eatCorpse(corpse);
                } else if ((var4_1 = this.targetEntity) instanceof class_1542) {
                    item = (class_1542)var4_1;
                    if (this.animal.getModules().getMetabolismModule().eatItem(item.method_6983())) {
                        item.method_31472();
                    }
                }
            }
            this.targetEntity = null;
        }
    }

    public boolean isCloseToTarget() {
        return this.targetEntity != null && JSTaskUtils.isCloseEnough(this.animal, this.targetEntity.method_24515().method_46558(), 2.0f);
    }

    public void findTargets(float range, class_243 pos) {
        range = Math.min(Math.max(range, 2.0f), 96.0f);
        class_1937 level = this.animal.method_37908();
        this.candidateCache.clear();
        this.cacheTick = this.ticks;
        class_238 box = this.animal.method_5829().method_1009((double)range, (double)range * 4.0, (double)range);
        if (pos != null) {
            box = box.method_997(pos);
        }
        ArrayList<class_1297> found = new ArrayList<class_1297>(32);
        if (this.targetMeatCubes) {
            found.addAll(level.method_8390(JSAnimalBase.class, box, e -> e.isDead() && !this.animal.method_5779((class_1297)e)));
            found.addAll(level.method_8390(MeatEntity.class, box, class_1297::method_5805));
        }
        if (this.targetHayCubes) {
            found.addAll(level.method_8390(HaybaleEntity.class, box, class_1297::method_5805));
        }
        found.addAll(level.method_8390(class_1542.class, box, e -> this.animal.getModules().getMetabolismModule().getDiet().canEatItem(e.method_6983())));
        if (found.isEmpty()) {
            return;
        }
        class_243 aPos = this.animal.method_19538();
        found.removeIf(e -> e == null || !e.method_5805());
        if (found.isEmpty()) {
            return;
        }
        found.sort((a, b) -> {
            double d1 = aPos.method_1025(a.method_19538()) * (1.0 + ThreadLocalRandom.current().nextDouble() * 0.25);
            double d2 = aPos.method_1025(b.method_19538()) * (1.0 + ThreadLocalRandom.current().nextDouble() * 0.25);
            return Double.compare(d1, d2);
        });
        if (found.size() > 16) {
            found = new ArrayList(found.subList(0, 16));
        }
        int visCount = 0;
        for (int i = 0; i < found.size() && visCount < 8; ++visCount, ++i) {
            class_1297 e2 = (class_1297)found.get(i);
            this.candidateCache.add(e2);
        }
        if (this.candidateCache.isEmpty()) {
            return;
        }
        int pathReqs = 0;
        for (class_1297 targ : this.candidateCache) {
            if (this.targetEntity != null || pathReqs >= 3 || this.pendingPathChecks.get() >= 4 || GLOBAL_PENDING_PATHS.get() >= 64) break;
            double distSqr = aPos.method_1025(targ.method_19538());
            if (distSqr > (double)(range * range) * 1.5) continue;
            ++pathReqs;
            this.submitCompetitivePathRequest(level, targ);
        }
        if (pathReqs == 0 && this.targetEntity == null) {
            this.shouldMoveToLastKnown = true;
        }
    }

    private void submitCompetitivePathRequest(class_1937 level, class_1297 targ) {
        CompletableFuture future = this.animal.getNavigationController().createPath(targ.method_24515(), 0.0);
        if (future == null) {
            return;
        }
        this.pendingPathChecks.incrementAndGet();
        GLOBAL_PENDING_PATHS.incrementAndGet();
        future.thenAccept(jsPath -> JSFindFoodTask.runOnMainThread(level, () -> {
            try {
                if (jsPath != null && targ.method_5805()) {
                    if (this.targetEntity == null) {
                        this.targetEntity = targ;
                    } else {
                        double cur = this.animal.method_19538().method_1025(this.targetEntity.method_19538());
                        double neu = this.animal.method_19538().method_1025(targ.method_19538());
                        if (neu + 1.0E-6 < cur && ThreadLocalRandom.current().nextDouble() < 0.65) {
                            this.targetEntity = targ;
                        }
                    }
                }
            }
            finally {
                this.pendingPathChecks.decrementAndGet();
                GLOBAL_PENDING_PATHS.decrementAndGet();
            }
        }));
    }

    private boolean cheapCanSee(class_1937 level, class_1297 e) {
        class_243 to;
        if (e == null) {
            return false;
        }
        class_243 from = this.animal.method_33571();
        class_3965 res = level.method_17742(new class_3959(from, to = e.method_33571(), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.animal));
        return res.method_17783() != class_239.class_240.field_1332;
    }

    private static void runOnMainThread(class_1937 level, Runnable r) {
        MinecraftServer srv = level.method_8503();
        if (srv != null) {
            srv.execute(r);
        }
    }
}

