/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.server.MinecraftServer;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSFindWaterTask
extends JSTaskBase {
    private class_243 targetPos;
    private class_243 targetWater;
    private int lookingTicks;
    private int ticks;
    private int lastSearchTick = -9999;
    private int checkCooldown;
    private boolean pathStarted;
    private boolean scanning;
    private final AtomicInteger pendingPaths = new AtomicInteger();
    private final List<Candidate> candidates = Collections.synchronizedList(new ArrayList(32));
    private final Deque<class_2338> pendingProbes = new ArrayDeque<class_2338>();
    private static final int SEARCH_INTERVAL = 20;
    private static final int MAX_CANDIDATES = 24;
    private static final int MAX_REQS_PER_SEARCH = 3;
    private static final int MAX_CONCURRENT_PATHS = 4;
    private static final int PROBE_BUDGET_PER_TICK = 64;
    private static final int GRID_STEP = 3;
    private static final int MAX_LAST_DRANK_DIST = 512;
    private boolean requiresShore = false;
    private int range = 64;
    private boolean isDrinking;

    public JSFindWaterTask(JSAnimalBase animal) {
        super(animal);
        this.getGoals().add(TaskGoal.METABOLISM);
        this.getGoals().add(TaskGoal.MOVEMENT);
    }

    public JSFindWaterTask noShore() {
        this.requiresShore = false;
        return this;
    }

    public JSFindWaterTask setRange(int r) {
        this.range = r;
        return this;
    }

    public TaskPriority getPriority() {
        if (this.animal.isDead()) {
            return TaskPriority.NONE;
        }
        double t = this.animal.getModules().getMetabolismModule().thirstPercentage();
        if (t > 0.8) {
            return TaskPriority.LOW;
        }
        if (t > 0.6) {
            return TaskPriority.MEDIUM;
        }
        if (t > 0.4) {
            return TaskPriority.HIGH;
        }
        if (t > 0.2) {
            return TaskPriority.VERY_HIGH;
        }
        return TaskPriority.DIRECT;
    }

    public boolean shouldRun() {
        if (this.checkCooldown < 0) {
            this.checkCooldown = 0;
        }
        if (this.checkCooldown-- != 0 || this.animal.isDead()) {
            return false;
        }
        if (!this.animal.getModules().getMetabolismModule().isThirsty()) {
            return false;
        }
        if (!this.animal.getAnimal().getAnimalAttributes().getMetabolismProperties().isThirstEnabled()) {
            return false;
        }
        if (this.animal.lastDrankAtPos != null && this.animal.lastDrankAtPos.method_10262((class_2382)this.animal.method_24515()) > 262144.0) {
            this.animal.lastDrankAtPos = null;
        }
        if (this.ticks - this.lastSearchTick >= 20 && !this.scanning && this.candidates.isEmpty() && this.pendingProbes.isEmpty()) {
            this.lastSearchTick = this.ticks;
            this.scanning = true;
            class_2338 center = this.animal.method_24515();
            int half = Math.max(2, Math.min(this.range, 96));
            CompletableFuture.runAsync(() -> {
                ArrayDeque<class_2338> toProbe = new ArrayDeque<class_2338>();
                for (int x = center.method_10263() - half; x <= center.method_10263() + half; x += 3) {
                    for (int z = center.method_10260() - half; z <= center.method_10260() + half; z += 3) {
                        toProbe.add(new class_2338(x, 0, z));
                    }
                }
                JSFindWaterTask.runOnMainThread(this.animal.method_37908(), () -> {
                    this.pendingProbes.addAll(toProbe);
                    this.scanning = false;
                });
            });
        }
        if (!this.pendingProbes.isEmpty()) {
            this.consumeProbeBudget();
        }
        if (this.targetPos != null && this.targetWater != null) {
            return true;
        }
        if (!this.candidates.isEmpty()) {
            this.requestPaths();
        }
        ++this.ticks;
        return this.scanning || !this.pendingProbes.isEmpty() || this.targetPos != null && this.targetWater != null;
    }

    public boolean canContinueRunning() {
        if (this.animal.isDead()) {
            return false;
        }
        if (this.targetPos != null || this.targetWater != null) {
            return true;
        }
        return this.scanning || !this.pendingProbes.isEmpty() || this.pendingPaths.get() > 0 || !this.candidates.isEmpty();
    }

    public boolean canInterrupt() {
        return this.targetPos == null;
    }

    public void onStart() {
        this.animal.getNavigationController().stop();
        this.animal.method_19540(true);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.scanning) {
            return;
        }
        if (this.checkCooldown > 0) {
            --this.checkCooldown;
        }
        ++this.lookingTicks;
        if (!this.reachedWater() && this.lookingTicks > 200 && this.animal.getNavigationController().isDone() && this.animal.getNavigationController().isStuck()) {
            this.stop();
            this.checkCooldown = 5;
            return;
        }
        if (this.reachedWater() || this.isDrinking) {
            this.drink();
            return;
        }
        if (this.targetPos == null && !this.candidates.isEmpty()) {
            Candidate next = this.candidates.removeFirst();
            this.targetPos = class_243.method_24953((class_2382)next.land);
            this.targetWater = class_243.method_24953((class_2382)next.water);
            this.pathStarted = false;
        }
        if (this.targetPos != null && (!this.pathStarted || this.animal.getNavigationController().isDone()) && this.pendingPaths.get() < 4) {
            CompletableFuture future = this.animal.getNavigationController().createPath(this.targetPos.field_1352, this.targetPos.field_1351, this.targetPos.field_1350, 1);
            if (future != null) {
                this.pendingPaths.incrementAndGet();
                future.thenAccept(path -> JSFindWaterTask.runOnMainThread(this.animal.method_37908(), () -> {
                    try {
                        if (path != null) {
                            this.animal.getNavigationController().moveTo(path);
                            this.pathStarted = true;
                        } else {
                            this.clearTarget();
                        }
                    }
                    finally {
                        this.pendingPaths.decrementAndGet();
                    }
                }));
            } else {
                this.clearTarget();
            }
        }
        ++this.ticks;
    }

    public void onStop() {
        this.animal.method_19540(false);
    }

    public void cleanUp() {
        this.clearAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeProbeBudget() {
        class_2338 base;
        class_1937 lvl = this.animal.method_37908();
        class_243 origin = this.animal.method_19538();
        int budget = 64;
        ArrayList<Candidate> batch = new ArrayList<Candidate>(budget);
        while (budget-- > 0 && !this.pendingProbes.isEmpty() && (base = this.pendingProbes.pollFirst()) != null) {
            int surfaceY = lvl.method_8624(class_2902.class_2903.field_13202, base.method_10263(), base.method_10260());
            class_2338 waterPos = new class_2338(base.method_10263(), surfaceY - 1, base.method_10260());
            if (!lvl.method_8316(waterPos).method_15767(class_3486.field_15517) || !lvl.method_8320(waterPos.method_10084()).method_26215()) continue;
            if (this.requiresShore) {
                boolean added = false;
                for (class_2350 dir : class_2350.class_2353.field_11062) {
                    class_2338 land = waterPos.method_10093(dir);
                    if (!lvl.method_8320(land).method_26215() || !lvl.method_8320(land.method_10084()).method_26215() || !lvl.method_8320(land.method_10074()).method_26216((class_1922)lvl, land.method_10074())) continue;
                    batch.add(new Candidate(land.method_10062(), waterPos.method_10062(), origin.method_1025(class_243.method_24953((class_2382)land))));
                    added = true;
                    break;
                }
                if (added) continue;
                continue;
            }
            batch.add(new Candidate(waterPos.method_10062(), waterPos.method_10062(), origin.method_1025(class_243.method_24953((class_2382)waterPos))));
        }
        if (!batch.isEmpty()) {
            HashMap<Candidate, Double> weight = new HashMap<Candidate, Double>();
            for (Candidate a2 : batch) {
                weight.put(a2, a2.dist * (1.0 + ThreadLocalRandom.current().nextDouble() * 0.25));
            }
            batch.sort(Comparator.comparingDouble(weight::get));
            List<Candidate> list = this.candidates;
            synchronized (list) {
                this.candidates.removeIf(this::isInvalid);
                this.candidates.addAll(batch);
                if (this.candidates.size() > 24) {
                    this.candidates.sort((a, b) -> Double.compare(a.dist, b.dist));
                    this.candidates.subList(24, this.candidates.size()).clear();
                }
            }
        }
    }

    private void requestPaths() {
        int reqs = 0;
        for (Candidate c : new ArrayList<Candidate>(this.candidates)) {
            if (reqs >= 3 || this.pendingPaths.get() >= 4 || this.targetPos != null) break;
            CompletableFuture future = this.animal.getNavigationController().createPath(c.land, 0.0);
            if (future == null) continue;
            this.targetPos = class_243.method_24953((class_2382)c.land);
            this.targetWater = class_243.method_24953((class_2382)c.water);
            this.pathStarted = false;
            this.pendingPaths.incrementAndGet();
            ++reqs;
            future.thenAccept(path -> JSFindWaterTask.runOnMainThread(this.animal.method_37908(), () -> {
                try {
                    if (path != null) {
                        this.animal.getNavigationController().moveTo(path);
                        this.pathStarted = true;
                    } else {
                        this.clearTarget();
                    }
                }
                finally {
                    this.pendingPaths.decrementAndGet();
                }
            }));
        }
    }

    private boolean isInvalid(Candidate c) {
        class_1937 lvl = this.animal.method_37908();
        if (!lvl.method_8316(c.water).method_15767(class_3486.field_15517)) {
            return true;
        }
        if (!lvl.method_8320(c.water.method_10084()).method_26215()) {
            return true;
        }
        if (this.requiresShore) {
            if (!lvl.method_8320(c.land).method_26215()) {
                return true;
            }
            if (!lvl.method_8320(c.land.method_10084()).method_26215()) {
                return true;
            }
            return !lvl.method_8320(c.land.method_10074()).method_26216((class_1922)lvl, c.land.method_10074());
        }
        return false;
    }

    private void drink() {
        this.animal.getNavigationController().stop();
        this.animal.method_55695();
        this.animal.getNavigationController().setFrozen(true);
        if (this.targetWater != null) {
            this.animal.method_5702(class_2183.class_2184.field_9853, this.targetWater);
        }
        this.isDrinking = true;
        this.animal.getModules().getMetabolismModule().addThirst(100);
        this.animal.curDrinkTicks = 2;
        if (this.animal.getModules().getMetabolismModule().getThirst() == this.animal.getModules().getMetabolismModule().getMaxThirst()) {
            if (this.targetWater != null) {
                this.animal.lastDrankAtPos = class_2338.method_49638((class_2374)this.targetWater);
            }
            this.clearTarget();
            this.animal.getNavigationController().setFrozen(false);
            this.animal.curDrinkTicks = 0;
            this.lookingTicks = 0;
            this.checkCooldown = 10;
            this.stop();
        }
    }

    private boolean reachedWater() {
        return this.targetPos != null && JSTaskUtils.isCloseEnough(this.animal, this.targetPos, 3.0f) || this.animal.method_5799();
    }

    private void clearTarget() {
        this.targetWater = null;
        this.targetPos = null;
        this.pathStarted = false;
    }

    private void clearAll() {
        this.animal.getNavigationController().setFrozen(false);
        this.clearTarget();
        this.checkCooldown = 0;
        this.ticks = 0;
        this.lookingTicks = 0;
        this.pendingPaths.set(0);
        this.scanning = false;
        this.pendingProbes.clear();
        this.candidates.clear();
        this.isDrinking = false;
    }

    private static void runOnMainThread(class_1937 level, Runnable r) {
        MinecraftServer srv = level.method_8503();
        if (srv != null) {
            srv.execute(r);
        } else {
            class_310.method_1551().execute(r);
        }
    }

    private record Candidate(class_2338 land, class_2338 water, double dist) {
    }
}

