/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.base.tag.JSBlockTags;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;
import travelers.server.animal.entity.task.TravelerTaskBase;

public class JSGrazeTask
extends JSTaskBase {
    private class_243 targetPos;
    private int grazeTicks;
    private int maxGrazeDuration = 40;
    private int xRange = 8;

    public JSGrazeTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.getGoals().add(TaskGoal.METABOLISM);
        this.getGoals().add(TaskGoal.MOVEMENT);
    }

    public boolean requiresUpdateEveryTick() {
        return this.targetPos != null;
    }

    public TaskPriority getPriority() {
        if (this.animal.isDead()) {
            return TaskPriority.NONE;
        }
        if (!this.animal.getModules().getMetabolismModule().isHungry()) {
            return TaskPriority.NONE;
        }
        return TaskPriority.MEDIUM;
    }

    public boolean shouldRun() {
        if (this.checkCooldown-- > 0) {
            return false;
        }
        if (!this.animal.getModules().getMetabolismModule().isHungry()) {
            return false;
        }
        class_2338 base = this.animal.method_24515();
        class_1937 level = this.animal.method_37908();
        for (int dx = -this.xRange; dx <= this.xRange; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -this.xRange; dz <= this.xRange; ++dz) {
                    class_2338 pos = base.method_10069(dx, dy, dz);
                    if (!this.isValidEatBlock(pos, level.method_8320(pos)) || !level.method_22347(pos.method_10084())) continue;
                    this.targetPos = class_243.method_24953((class_2382)pos);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean canContinueRunning() {
        return this.targetPos != null && this.animal.getModules().getMetabolismModule().isHungry();
    }

    public void onStart() {
        if (this.targetPos != null) {
            this.animal.getNavigationController().moveTo(this.targetPos.field_1352, this.targetPos.field_1351, this.targetPos.field_1350);
        }
    }

    public void tick() {
        if (this.targetPos == null) {
            return;
        }
        TravelersPathNavigation nav = this.animal.getNavigationController();
        if (!nav.isInProgress()) {
            nav.moveTo(this.targetPos.field_1352, this.targetPos.field_1351, this.targetPos.field_1350);
        }
        class_2338 grassPos = class_2338.method_49638((class_2374)this.targetPos);
        if (JSTaskUtils.isCloseEnough(this.animal, this.targetPos, 2.0f)) {
            nav.setFrozen(true);
            this.animal.method_5702(class_2183.class_2184.field_9853, this.targetPos);
            ++this.grazeTicks;
            if (this.grazeTicks == 1) {
                this.animal.curEatTicks = 2;
            }
            if (this.grazeTicks >= this.maxGrazeDuration / 2) {
                if (this.isValidEatBlock(grassPos, this.animal.method_37908().method_8320(grassPos))) {
                    this.animal.method_37908().method_8652(grassPos, class_2246.field_10124.method_9564(), 3);
                }
                this.animal.getModules().getMetabolismModule().addFood((int)JSUtils.toTickMinutes(5.0f));
                this.targetPos = null;
                this.grazeTicks = 0;
                this.checkCooldown = this.random.nextInt(1, 3);
                nav.setFrozen(false);
            }
        } else if (nav.isFrozen()) {
            nav.setFrozen(false);
        }
    }

    public void onStop() {
        this.targetPos = null;
        this.grazeTicks = 0;
        this.animal.getNavigationController().setFrozen(false);
    }

    public void cleanUp() {
        this.targetPos = null;
        this.grazeTicks = 0;
        this.animal.getNavigationController().setFrozen(false);
    }

    public TravelerTaskBase setRange(int x, int y) {
        this.xRange = x;
        return this;
    }

    public boolean isValidEatBlock(class_2338 pos, class_2680 state) {
        return state.method_26164(JSBlockTags.EXTINCT_PLANT_BLOCKS) || state.method_27852(class_2246.field_10479) || state.method_26164(JSBlockTags.HERBIVORE_BLOCK_EDIBLE);
    }

    public int getMaxGrazeDuration() {
        return this.maxGrazeDuration;
    }

    public JSGrazeTask setMaxGrazeDuration(int maxGrazeDuration) {
        this.maxGrazeDuration = maxGrazeDuration;
        return this;
    }
}

