/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import net.minecraft.class_1297;
import net.minecraft.class_1333;
import net.minecraft.class_243;
import net.minecraft.class_3419;
import net.minecraft.class_8710;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.animation.TravelersSoundAnimationDefinition;
import travelers.server.packet.obj.TravelersShakeCamera;
import travelers.util.helper.TravelersPacketDistributor;

public class JSRoarTask
extends JSTaskBase {
    private int roarLength = 0;
    private final TravelersSoundAnimationDefinition[] defs;
    private TravelersSoundAnimationDefinition roar;
    private int roarTickOffset = 0;
    private int lastIndex = -1;
    private int roarCooldown = 0;
    private boolean hasEnteredShake;
    private boolean scaresNearby;

    public JSRoarTask(JSAnimalBase baseAnimal, TravelersSoundAnimationDefinition ... definitions) {
        super(baseAnimal);
        this.defs = definitions;
    }

    public JSRoarTask scareNearby() {
        this.scaresNearby = true;
        return this;
    }

    public boolean shouldRun() {
        if (this.roarCooldown > 0) {
            --this.roarCooldown;
            return false;
        }
        if (this.animal.isDead() || this.animal.method_5816() && !this.animal.method_24828() || this.animal.method_6113() || this.animal.method_5968() != null || this.animal.method_6113() || this.animal.isResting()) {
            return false;
        }
        if (this.animal.getModules().getHerdModule().isFollower()) {
            return this.animal.method_18411() && this.animal.getNavigationController().isDone();
        }
        return this.animal.getNavigationController().isDone() && this.random.nextDouble() < (double)0.08f;
    }

    public boolean canContinueRunning() {
        if (this.animal.isDead() || this.animal.method_6113() || this.animal.method_5816() || this.animal.isResting()) {
            return false;
        }
        return this.roarLength != 0;
    }

    public boolean requiresUpdateEveryTick() {
        if (this.animal.isDead() || this.animal.method_6113()) {
            return false;
        }
        return this.roarLength > 0;
    }

    public void onStart() {
        int index;
        while ((index = this.random.nextInt(this.defs.length)) == this.lastIndex && this.defs.length > 1) {
        }
        this.lastIndex = index;
        TravelersSoundAnimationDefinition soundAnimDef = this.defs[index];
        this.roarTickOffset = soundAnimDef.length() - soundAnimDef.offset();
        this.roarLength = soundAnimDef.length();
        this.roar = soundAnimDef;
        if (this.roarTickOffset == this.roarLength) {
            this.animal.method_5783(soundAnimDef.event(), 6.0f, 1.0f);
            if (this.scaresNearby) {
                for (JSAnimalBase animalBase : this.animal.method_37908().method_8390(JSAnimalBase.class, this.animal.method_5829().method_1014(30.0), e -> e.method_17682() + e.method_17681() < this.animal.method_17682() + this.animal.method_17681())) {
                    animalBase.setFleeTarget((class_1297)this.animal);
                }
            }
        }
        this.animal.method_18799(class_243.field_1353);
        this.animal.getNavigationController().stop();
        this.animal.getNavigationController().setFrozen(true);
        this.animal.field_6283 = this.animal.method_36454();
        this.animal.field_6241 = this.animal.method_36454();
        this.animal.field_5982 = this.animal.method_36454();
        this.animal.field_6220 = this.animal.field_6283;
        this.animal.field_6259 = this.animal.field_6241;
        class_1333 class_13332 = this.animal.method_5988();
        if (class_13332 instanceof class_1333) {
            class_1333 look = class_13332;
            look.method_20248(this.animal.method_23317(), this.animal.method_23320(), this.animal.method_23321());
        }
        this.tick();
    }

    public void tick() {
        --this.roarLength;
        if (this.roarTickOffset == this.roarLength) {
            this.animal.method_37908().method_8396(null, this.animal.method_24515(), this.roar.event(), class_3419.field_15251, 2.0f, 1.0f);
        }
        if (this.animal.canShake() && !this.hasEnteredShake && this.roar.length() - this.roar.secondaryOffset() > this.roarLength) {
            TravelersPacketDistributor.sendToPlayersTrackingEntity((SmartAnimalBase)this.animal, (class_8710)new TravelersShakeCamera(false, this.animal.shakeAmount() * 0.7f, this.roarLength, this.animal.shakeDistance() * 0.7f, this.animal.method_19538().method_46409()));
            this.hasEnteredShake = true;
        }
        this.animal.freezeAnimator();
        if (this.roar != null && this.roarLength > 0) {
            this.roar.def().sendForEntity((SmartAnimalBase)this.animal);
        }
    }

    public void onStop() {
        this.roarCooldown = 26;
        this.roar = null;
        this.roarLength = 0;
        this.hasEnteredShake = false;
        this.animal.getNavigationController().setFrozen(false);
    }
}

