/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.util;

import java.util.function.ToDoubleFunction;
import jp.jurassicsaga.server.base.animal.entity.util.JSGoalUtils;
import jp.jurassicsaga.server.base.animal.entity.util.JSRandomPos;
import net.minecraft.class_1314;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;

public class JSLandRandomPos {
    @Nullable
    public static class_243 getPos(SmartAnimalBase mob, int radius, int verticalRange) {
        return JSLandRandomPos.getPos(mob, radius, verticalRange, arg_0 -> ((SmartAnimalBase)mob).method_6149(arg_0));
    }

    @Nullable
    public static class_243 getPos(SmartAnimalBase mob, int radius, int yRange, ToDoubleFunction<class_2338> scorer) {
        boolean restricted = JSGoalUtils.mobRestricted(mob, radius);
        return JSRandomPos.generateBestRandomPos(() -> {
            class_2338 offset = JSRandomPos.generateRandomDirection(radius, yRange);
            class_2338 candidate = JSLandRandomPos.generateValidRandomTarget(mob, radius, restricted, offset);
            return candidate != null ? JSLandRandomPos.movePosUpOutOfSolid(mob, candidate) : null;
        }, scorer);
    }

    @Nullable
    public static class_243 getPosTowards(SmartAnimalBase mob, int radius, int yRange, class_243 target) {
        class_243 direction = target.method_1020(mob.method_19538());
        boolean restricted = JSGoalUtils.mobRestricted(mob, radius);
        return JSLandRandomPos.getPosInDirection(mob, radius, yRange, direction, restricted);
    }

    @Nullable
    public static class_243 getPosAway(SmartAnimalBase mob, int radius, int yRange, class_243 dangerSource) {
        class_243 direction = mob.method_19538().method_1020(dangerSource);
        boolean restricted = JSGoalUtils.mobRestricted(mob, radius);
        return JSLandRandomPos.getPosInDirection(mob, radius, yRange, direction, restricted);
    }

    @Nullable
    private static class_243 getPosInDirection(SmartAnimalBase mob, int radius, int yRange, class_243 direction, boolean restricted) {
        return JSRandomPos.generateBestRandomPos(() -> {
            class_2338 offset = JSRandomPos.generateRandomDirectionWithinRadians(radius, yRange, 0, direction.field_1352, direction.field_1350, 1.5707963267948966);
            if (offset == null) {
                return null;
            }
            class_2338 candidate = JSLandRandomPos.generateValidRandomTarget(mob, radius, restricted, offset);
            return candidate != null ? JSLandRandomPos.movePosUpOutOfSolid(mob, candidate) : null;
        }, arg_0 -> ((SmartAnimalBase)mob).method_6149(arg_0));
    }

    @Nullable
    private static class_2338 movePosUpOutOfSolid(SmartAnimalBase mob, class_2338 pos) {
        class_2338 corrected = JSRandomPos.searchUpDown(pos, 4, p -> !JSGoalUtils.isSolid(mob, p));
        if (corrected == null) {
            return null;
        }
        return !JSGoalUtils.isWater(mob, corrected) && !JSGoalUtils.hasMalus(mob, corrected) ? corrected : null;
    }

    @Nullable
    private static class_2338 generateValidRandomTarget(SmartAnimalBase mob, int radius, boolean restricted, class_2338 offset) {
        class_2338 candidate = JSRandomPos.generateRandomPosTowardDirection((class_1314)mob, radius, offset);
        return candidate != null && !JSGoalUtils.isOutsideLimits(candidate, mob) && !JSGoalUtils.isRestricted(restricted, mob, candidate) && !JSGoalUtils.isNotStable(mob.getNavigationController(), candidate) ? candidate : null;
    }
}

