/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj.attributes;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import net.minecraft.class_1297;
import net.minecraft.class_1309;

public class JSSocialGroupProperties<T extends JSAnimalBase> {
    private final Set<Class<? extends class_1297>> huntTargets = new HashSet<Class<? extends class_1297>>();
    private final Set<Class<? extends class_1309>> herdCompatible = new HashSet<Class<? extends class_1309>>();
    private final Set<Class<? extends class_1309>> scaredOf = new HashSet<Class<? extends class_1309>>();
    private int maxHerdSize = 1;
    private float maxDistanceToPackLeader = 500.0f;
    private float minDistanceToPackLeader = 100.0f;
    private float naturalAggression = 0.0f;
    private boolean usesNest = false;

    public JSSocialGroupProperties<T> enableNesting() {
        this.usesNest = true;
        return this;
    }

    public final JSSocialGroupProperties<T> setNaturalAggression(float aggression) {
        this.naturalAggression = Math.clamp(aggression, 0.0f, 5.0f);
        return this;
    }

    @SafeVarargs
    public final JSSocialGroupProperties<T> addHuntTargets(Class<? extends class_1297> ... clazz) {
        this.huntTargets.addAll(List.of(clazz));
        return this;
    }

    @SafeVarargs
    public final JSSocialGroupProperties<T> addHerdTargets(Class<? extends class_1309> ... clazz) {
        this.herdCompatible.addAll(List.of(clazz));
        return this;
    }

    public final JSSocialGroupProperties<T> addHerdTargets(List<Class<? extends class_1309>> clazz) {
        this.herdCompatible.addAll(clazz);
        return this;
    }

    @SafeVarargs
    public final JSSocialGroupProperties<T> addScaredOf(Class<? extends class_1309> ... clazz) {
        this.scaredOf.addAll(List.of(clazz));
        return this;
    }

    public final JSSocialGroupProperties<T> setMaxHerdSize(int maxHerdSize) {
        this.maxHerdSize = Math.max(0, maxHerdSize);
        return this;
    }

    public boolean isScaredOf(class_1309 livingEntity) {
        for (Class<? extends class_1309> aClass1 : this.scaredOf) {
            if (!aClass1.isInstance(livingEntity) && aClass1 != livingEntity.getClass()) continue;
            return true;
        }
        return false;
    }

    public Set<Class<? extends class_1297>> getHuntTargets() {
        return this.huntTargets;
    }

    public Set<Class<? extends class_1309>> getHerdCompatible() {
        return this.herdCompatible;
    }

    public Set<Class<? extends class_1309>> getScaredOf() {
        return this.scaredOf;
    }

    public int getMaxHerdSize() {
        return this.maxHerdSize;
    }

    public float getMaxDistanceToPackLeader() {
        return this.maxDistanceToPackLeader;
    }

    public float getMinDistanceToPackLeader() {
        return this.minDistanceToPackLeader;
    }

    public float getNaturalAggression() {
        return this.naturalAggression;
    }

    public boolean isUsesNest() {
        return this.usesNest;
    }

    public JSSocialGroupProperties<T> setMaxDistanceToPackLeader(float maxDistanceToPackLeader) {
        this.maxDistanceToPackLeader = maxDistanceToPackLeader;
        return this;
    }

    public JSSocialGroupProperties<T> setMinDistanceToPackLeader(float minDistanceToPackLeader) {
        this.minDistanceToPackLeader = minDistanceToPackLeader;
        return this;
    }

    public JSSocialGroupProperties<T> setUsesNest(boolean usesNest) {
        this.usesNest = usesNest;
        return this;
    }
}

