/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj.locator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSModuleHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import net.minecraft.class_2960;
import travelers.server.animal.obj.TravelersAnimalAttributes;
import travelers.server.animal.obj.locator.ResourceLocator;

public class JSAnimalBaseLocator<T extends JSAnimalBase>
extends ResourceLocator<T> {
    private final boolean hasGenders;
    private boolean adultOnly;
    protected Cache<String, class_2960> cache = CacheBuilder.newBuilder().maximumSize(5000L).build();

    public JSAnimalBaseLocator() {
        this(true);
    }

    public JSAnimalBaseLocator(boolean gendered) {
        this.hasGenders = gendered;
    }

    public JSAnimalBaseLocator<T> setAdultOnly() {
        this.adultOnly = true;
        return this;
    }

    public class_2960 getTextureLocation(T entity) {
        Object key = this.makeCacheKey(entity, "texture");
        if (entity.method_16914()) {
            key = (String)key + "|name=" + entity.method_5797().getString().toLowerCase(Locale.ROOT);
        }
        try {
            return (class_2960)this.cache.get(key, () -> this.buildTextureLocation(entity));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public class_2960 getLuxLocation(T entity) {
        String key = this.makeCacheKey(entity, "lux");
        try {
            return (class_2960)this.cache.get((Object)key, () -> {
                String name = this.getEntityName(entity);
                String growthStage = this.getGrowthStage(entity);
                String version = this.getVersion(entity);
                return JSCommon.createId("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + "_lux.png");
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public class_2960 getEyelidLocation(T entity) {
        Object key = this.makeCacheKey(entity, "texture_eyelid");
        if (entity.method_16914()) {
            key = (String)key + "|name=" + entity.method_5797().getString().toLowerCase(Locale.ROOT);
        }
        try {
            return (class_2960)this.cache.get(key, () -> this.buildTextureEyelidLocation(entity));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public class_2960 getModelLocation(T entity) {
        String key = this.makeCacheKey(entity, "model");
        try {
            return (class_2960)this.cache.get((Object)key, () -> {
                String name = this.getEntityName(entity);
                String growthStage = this.getGrowthStage(entity);
                String version = this.getVersion(entity);
                return JSCommon.createId("geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + ".geo.json");
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public class_2960 getDefaultModelLocation(T entity) {
        String key = this.makeCacheKey(entity, "default_model");
        try {
            return (class_2960)this.cache.get((Object)key, () -> {
                String name = this.getEntityName(entity);
                String version = this.getVersion(entity);
                return JSCommon.createId("geo/animal/" + version + "/" + name + "/" + name + "_adult.geo.json");
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public class_2960 getAnimationLocation(T entity) {
        String key = this.makeCacheKey(entity, "anim");
        try {
            return (class_2960)this.cache.get((Object)key, () -> {
                String name = this.getEntityName(entity);
                String version = this.getVersion(entity);
                boolean baby = !this.adultOnly && entity.getAnimal().getAnimalAttributes().getMiscProperties().isBabyAnimations() && entity.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.BABY;
                return JSCommon.createId("animations/animal/" + version + "/" + name + "/" + name + (baby ? "_baby.animation.json" : ".animation.json"));
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected class_2960 buildTextureLocation(T entity) {
        String name = this.getEntityName(entity);
        String growthStage = this.getGrowthStage(entity);
        String version = this.getVersion(entity);
        if (((JSEntityDataHolder)((Object)entity)).getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT && !this.adultOnly) {
            return JSCommon.createId("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + ".png");
        }
        if (this.adultOnly) {
            growthStage = "adult";
        }
        JSVariants.JSVariant variant = JSVariants.fromLocation((String)entity.method_5841().method_12789(JSEntityDataHolder.textureVariant));
        boolean extinct = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().isExtinct();
        if (variant == JSVariants.NONE || !extinct) {
            if (!this.hasGenders) {
                return JSCommon.createId("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + ".png");
            }
            String suffix = ((JSEntityDataHolder)((Object)entity)).getModules().getGeneticModule().isMale() ? "male" : "female";
            return JSCommon.createId("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + "_" + suffix + ".png");
        }
        class_2960 variantLoc = variant.location();
        String path = variantLoc.method_12832();
        boolean genderedVariants = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().isGenderedVariants();
        if (variant.ignoresGenders()) {
            return class_2960.method_60655((String)variantLoc.method_12836(), (String)("textures/geo/animal/" + version + "/" + name + "/variants/" + name + "_adult_" + path + ".png"));
        }
        if (genderedVariants) {
            String suffix = ((JSEntityDataHolder)((Object)entity)).getModules().getGeneticModule().isMale() ? "_male" : "_female";
            return class_2960.method_60655((String)variantLoc.method_12836(), (String)("textures/geo/animal/" + version + "/" + name + "/variants/" + name + "_adult_" + path + suffix + ".png"));
        }
        return class_2960.method_60655((String)variantLoc.method_12836(), (String)("textures/geo/animal/" + version + "/" + name + "/variants/" + name + "_adult_" + path + ".png"));
    }

    protected class_2960 buildTextureEyelidLocation(T entity) {
        String name = this.getEntityName(entity);
        String growthStage = this.getGrowthStage(entity);
        String version = this.getVersion(entity);
        if (((JSEntityDataHolder)((Object)entity)).getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT && !this.adultOnly) {
            return JSCommon.createId("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + "_eyelid.png");
        }
        if (this.adultOnly) {
            growthStage = "adult";
        }
        JSVariants.JSVariant variant = JSVariants.fromLocation((String)entity.method_5841().method_12789(JSEntityDataHolder.textureVariant));
        boolean extinct = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().isExtinct();
        if (variant == JSVariants.NONE || !extinct) {
            if (!this.hasGenders) {
                return JSCommon.createId("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + "_eyelid.png");
            }
            String suffix = ((JSEntityDataHolder)((Object)entity)).getModules().getGeneticModule().isMale() ? "male" : "female";
            return JSCommon.createId("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + "_" + suffix + "_eyelid.png");
        }
        class_2960 variantLoc = variant.location();
        String path = variantLoc.method_12832();
        boolean genderedVariants = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().isGenderedVariants();
        if (variant.ignoresGenders()) {
            return class_2960.method_60655((String)variantLoc.method_12836(), (String)("textures/geo/animal/" + version + "/" + name + "/variants/" + name + "_adult_" + path + "_eyelid.png"));
        }
        if (genderedVariants) {
            String suffix = ((JSEntityDataHolder)((Object)entity)).getModules().getGeneticModule().isMale() ? "_male" : "_female";
            return class_2960.method_60655((String)variantLoc.method_12836(), (String)("textures/geo/animal/" + version + "/" + name + "/variants/" + name + "_adult_" + path + suffix + "_eyelid.png"));
        }
        return class_2960.method_60655((String)variantLoc.method_12836(), (String)("textures/geo/animal/" + version + "/" + name + "/variants/" + name + "_adult_" + path + "_eyelid.png"));
    }

    protected String getEntityName(T entity) {
        return ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
    }

    private String getGrowthStage(T entity) {
        if (this.adultOnly) {
            return "adult";
        }
        return ((JSEntityDataHolder)((Object)entity)).getModules().getGrowthStageModule().getGrowthStage().getGrowthStageName();
    }

    public String getVersion(T entity) {
        float version = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().getVersion().versionId();
        return "v" + version;
    }

    protected String makeCacheKey(T entity, String type) {
        TravelersAnimalAttributes animal = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes();
        JSModuleHolder modules = ((JSEntityDataHolder)((Object)entity)).getModules();
        String growth = modules.getGrowthStageModule().getGrowthStage().name();
        boolean male = modules.getGeneticModule().isMale();
        String variant = (String)entity.method_5841().method_12789(JSEntityDataHolder.textureVariant);
        return type + ":" + animal.getAnimalName() + ":" + growth + ":" + (male ? "1" : "0") + ":" + variant;
    }
}

