/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj.locator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import net.minecraft.class_2960;
import travelers.server.animal.obj.locator.ResourceLocator;

public class JSGenderTextureLocator<T extends JSAnimalBase>
extends ResourceLocator<T> {
    protected Cache<String, class_2960> cache = CacheBuilder.newBuilder().maximumSize(5000L).build();

    public class_2960 getTextureLocation(T entity) {
        String key = this.makeKey(entity, "texture", ((JSEntityDataHolder)((Object)entity)).getModules().getGeneticModule().isMale());
        try {
            return (class_2960)this.cache.get((Object)key, () -> {
                String name = this.getEntityName(entity);
                String version = this.getVersion(entity);
                String gender = entity.getModules().getGeneticModule().isMale() ? "male" : "female";
                return class_2960.method_60655((String)"jurassicsaga", (String)("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + gender + ".png"));
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public class_2960 getModelLocation(T entity) {
        String key = this.makeKey(entity, "model");
        try {
            return (class_2960)this.cache.get((Object)key, () -> {
                String name = this.getEntityName(entity);
                String version = this.getVersion(entity);
                return class_2960.method_60655((String)"jurassicsaga", (String)("geo/animal/" + version + "/" + name + "/" + name + ".geo.json"));
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public class_2960 getAnimationLocation(T entity) {
        String key = this.makeKey(entity, "anim");
        try {
            return (class_2960)this.cache.get((Object)key, () -> {
                String name = this.getEntityName(entity);
                String version = this.getVersion(entity);
                return class_2960.method_60655((String)"jurassicsaga", (String)("animations/animal/" + version + "/" + name + "/" + name + ".animation.json"));
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private String getEntityName(T entity) {
        return ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
    }

    public String getVersion(T entity) {
        float version = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().getVersion().versionId();
        return "v" + (version % 1.0f == 0.0f ? (float)((int)version) : version);
    }

    private String makeKey(T entity, String type) {
        return type + ":" + ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getAnimalName();
    }

    protected String makeKey(T entity, String type, boolean male) {
        return type + ":" + ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getAnimalName() + ":" + male;
    }
}

