/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.other.vehicle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.jurassicsaga.mixin.LivingEntityAccessor;
import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.entity.obj.other.SeatEntity;
import jp.jurassicsaga.server.base.entity.obj.other.vehicle.JSVehicleEntity;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import jp.jurassicsaga.server.base.item.JSItems;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_9331;
import travelers.server.animal.ModelType;

public class BalloonTourVehicle
extends JSVehicleEntity {
    private List<BalloonPathPoint> path;
    private int pathIndex = 0;
    private int stopTimer = 0;
    private boolean forceGrounded = false;
    private float maxRaiseSpeed = 1.5f;
    private float currentRaise = 0.0f;

    public BalloonTourVehicle(class_1299<? extends JSVehicleEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.setMaxSpeed(0.25f);
        this.setTurnSpeed(5.0f);
        this.setMaxTurnSpeed(5.0f);
        this.setAcceleration(0.03f);
        this.setMaxSpeedBackwards(0.25f);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236 && !((Boolean)this.field_6011.method_12789(CAN_BE_DRIVEN)).booleanValue()) {
            this.followGivenPath();
        }
    }

    private void followGivenPath() {
        boolean landed;
        boolean shouldLandNow;
        if (this.path == null) {
            return;
        }
        if (this.path.isEmpty()) {
            return;
        }
        if (this.pathIndex >= this.path.size()) {
            this.pathIndex = 0;
        }
        BalloonPathPoint point = this.path.get(this.pathIndex);
        if (this.stopTimer > 0) {
            --this.stopTimer;
            this.setCurrentSpeed(0.0f);
            this.currentRaise = 0.0f;
            this.forceGrounded = true;
            return;
        }
        class_243 pos = this.method_19538();
        class_243 target = point.position;
        double dx = target.field_1352 - pos.field_1352;
        double dz = target.field_1350 - pos.field_1350;
        double distXZ = Math.sqrt(dx * dx + dz * dz);
        double arriveRadius = 1.2;
        double slowRadius = 8.0;
        float minSpeed = 0.03f;
        float desiredYaw = (float)Math.toDegrees(Math.atan2(-dx, dz));
        float currentYaw = this.method_36454();
        float yawError = class_3532.method_15393((float)(desiredYaw - currentYaw));
        float absYawError = Math.abs(yawError);
        boolean nearTarget = distXZ <= 1.2;
        boolean bl = shouldLandNow = point.land && nearTarget;
        if (shouldLandNow) {
            this.forceGrounded = true;
            this.setCurrentSpeed(0.0f);
            this.currentRaise = !this.method_24828() ? -Math.min(this.maxRaiseSpeed, 0.25f) : 0.0f;
        } else {
            this.forceGrounded = false;
            float heightDiff = (float)(point.position.field_1351 + (double)point.targetHeight - pos.field_1351);
            float climbFactor = 0.06f;
            float maxAutoClimb = 0.7f;
            this.currentRaise = Math.abs(heightDiff) > 0.2f ? class_3532.method_15363((float)(heightDiff * climbFactor), (float)(-maxAutoClimb), (float)maxAutoClimb) : 0.0f;
        }
        boolean bl2 = landed = !point.land || this.method_24828();
        if (distXZ <= 1.2 && landed) {
            this.stopTimer = point.stopTicks;
            this.setCurrentSpeed(0.0f);
            ++this.pathIndex;
            return;
        }
        if (!shouldLandNow) {
            float baseTurnRate = 3.5f;
            float closeBoost = distXZ < 3.0 ? 2.0f : 1.0f;
            float turnRate = baseTurnRate * closeBoost;
            float step = class_3532.method_15363((float)yawError, (float)(-turnRate), (float)turnRate);
            this.method_36456(currentYaw + step);
        }
        if (!shouldLandNow) {
            float distFactor = (float)class_3532.method_15350((double)(distXZ / 8.0), (double)0.0, (double)1.0);
            float desiredSpeed = this.maxSpeed * distFactor;
            float angleFactor = 1.0f;
            if (absYawError > 10.0f) {
                angleFactor = 0.65f;
            }
            if (absYawError > 25.0f) {
                angleFactor = 0.4f;
            }
            if (absYawError > 45.0f) {
                angleFactor = 0.2f;
            }
            desiredSpeed = Math.max(0.03f, desiredSpeed * angleFactor);
            float speed = this.getCurrentSpeed();
            speed = speed < desiredSpeed ? Math.min(speed + this.acceleration, desiredSpeed) : Math.max(speed - this.acceleration * 1.5f, desiredSpeed);
            this.setCurrentSpeed(speed);
            double mx = -Math.sin(Math.toRadians(this.method_36454())) * (double)speed;
            double mz = Math.cos(Math.toRadians(this.method_36454())) * (double)speed;
            this.method_5784(class_1313.field_6308, this.applyGravityToVec(mx, mz));
        } else {
            this.method_5784(class_1313.field_6308, this.applyGravityToVec(0.0, 0.0));
        }
    }

    @Override
    protected void method_5652(class_2487 compoundTag) {
        BalloonPathPoint balloonPathPoint;
        class_2487 path;
        super.method_5652(compoundTag);
        if (this.path == null) {
            return;
        }
        int size = 0;
        Iterator<BalloonPathPoint> iterator = this.path.iterator();
        while (iterator.hasNext() && (path = (balloonPathPoint = iterator.next()).toCompound()) != null) {
            compoundTag.method_10566("tour_checkpoint_" + ++size, (class_2520)path);
        }
        compoundTag.method_10569("tour_checkpoints", size);
        compoundTag.method_10556("canBeDriven", ((Boolean)this.field_6011.method_12789(CAN_BE_DRIVEN)).booleanValue());
        compoundTag.method_10569("pathIndex", this.pathIndex);
        compoundTag.method_10569("pathTimeout", this.stopTimer);
        compoundTag.method_10548("currentRaise", this.currentRaise);
        compoundTag.method_10556("forceGrounded", this.forceGrounded);
    }

    @Override
    protected void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        int size = compoundTag.method_10550("tour_checkpoints");
        for (int i = 0; i < size; ++i) {
            int curSize = i + 1;
            class_2487 tag = compoundTag.method_10562("tour_checkpoint_" + curSize);
            if (this.path == null) {
                this.path = new ArrayList<BalloonPathPoint>();
            }
            BalloonPathPoint node = BalloonPathPoint.fromCompound(tag);
            this.path.add(node);
        }
        this.field_6011.method_12778(CAN_BE_DRIVEN, (Object)compoundTag.method_10577("canBeDriven"));
        this.pathIndex = compoundTag.method_10550("pathIndex");
        this.stopTimer = compoundTag.method_10550("pathTimeout");
        this.currentRaise = compoundTag.method_10583("currentRaise");
        this.forceGrounded = compoundTag.method_10577("forceGrounded");
    }

    private float lerpRotation(float current, float target, float factor) {
        float diff = class_3532.method_15393((float)(target - current));
        return current + diff * factor;
    }

    @Override
    protected void updateDriver(class_1657 driver) {
        if (((Boolean)this.field_6011.method_12789(CAN_BE_DRIVEN)).booleanValue()) {
            class_3222 serverPlayer;
            float currentSpeed = this.getCurrentSpeed();
            this.field_6011.method_12778(HAS_DRIVER, (Object)(driver != null ? 1 : 0));
            if (driver instanceof class_3222 && (serverPlayer = (class_3222)driver) instanceof LivingEntityAccessor) {
                LivingEntityAccessor accessor = (LivingEntityAccessor)serverPlayer;
                if (accessor.isJumping()) {
                    this.currentRaise = Math.min(this.currentRaise + 0.01f, this.maxRaiseSpeed);
                } else if (this.currentRaise != 0.0f) {
                    this.currentRaise = Math.max(this.currentRaise - 0.005f, 0.0f);
                }
                if (this.currentRaise > 0.5f || !this.method_24828()) {
                    if ((double)serverPlayer.field_6250 > 0.0) {
                        currentSpeed = Math.min(currentSpeed + this.acceleration, this.maxSpeed);
                    } else if ((double)serverPlayer.field_6250 < 0.0) {
                        currentSpeed = Math.max(currentSpeed - this.acceleration, -this.maxSpeedBackwards);
                    } else if (Math.abs(currentSpeed *= 0.7f) < 1.0E-4f) {
                        currentSpeed = 0.0f;
                    }
                }
                if (this.method_24828() && currentSpeed != 0.0f) {
                    currentSpeed = Math.max(currentSpeed - 0.1f, 0.0f);
                }
                this.currentTurn = (double)serverPlayer.field_6212 < 0.0 ? this.maxTurnSpeed : ((double)serverPlayer.field_6212 > 0.0 ? -this.maxTurnSpeed : 0.0f);
            } else {
                if (this.currentRaise != 0.0f) {
                    this.currentRaise = Math.max(this.currentRaise - 0.005f, 0.0f);
                }
                if (currentSpeed != 0.0f) {
                    currentSpeed = Math.max(currentSpeed - 0.1f, 0.0f);
                }
                this.currentTurn = 0.0f;
            }
            if (this.currentRaise > 0.5f || !this.method_24828()) {
                this.method_36456(this.method_36454() + this.currentTurn);
            }
            double dx = -Math.sin(Math.toRadians(this.method_36454())) * (double)currentSpeed;
            double dz = Math.cos(Math.toRadians(this.method_36454())) * (double)currentSpeed;
            class_243 movementVec = this.applyGravityToVec(dx, dz);
            this.method_5784(class_1313.field_6308, movementVec);
            this.setCurrentSpeed(currentSpeed);
        }
    }

    @Override
    protected void updateNoDriver() {
        if (this.currentRaise != 0.0f) {
            this.currentRaise = Math.max(this.currentRaise - 0.001f, 0.0f);
        }
        super.updateNoDriver();
    }

    @Override
    protected void animateServer() {
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.module.playTransition((double)this.currentRaise > 0.0 || !this.method_24828(), JSAnimations.VEHICLE_INFLATE.wrap(40), JSAnimations.VEHICLE_INFLATED.wrap(), JSAnimations.VEHICLE_DEFLATE.wrap(70))) {
            return;
        }
        JSAnimations.VEHICLE_DEFLATED.sendForEntity(ModelType.AZURE, (class_1297)this);
    }

    @Override
    protected class_243 applyGravityToVec(double dx, double dz) {
        if (this.forceGrounded && !((Boolean)this.field_6011.method_12789(CAN_BE_DRIVEN)).booleanValue()) {
            return new class_243(dx, -0.5, dz);
        }
        return super.applyGravityToVec(dx, dz).method_1031(0.0, (double)(this.currentRaise + 0.5f), 0.0);
    }

    @Override
    protected void initializeSeats() {
        this.addSeat(0.5, 0.15, 0.5);
        this.addStandingSeat(-0.5, 0.15, 0.5);
        this.addStandingSeat(0.5, 0.15, -0.5);
        this.addStandingSeat(-0.5, 0.15, -0.5);
    }

    protected void addStandingSeat(double x, double y, double z) {
        SeatEntity entity = new SeatEntity(this.method_37908(), new class_243(x, y, z), true, this);
        entity.setStanding();
        this.seats.add(entity);
    }

    @Override
    protected class_1792 vehicleItem() {
        return (class_1792)JSItems.BALLOON_TOUR.get();
    }

    @Override
    protected void otherItemInteracts(class_1657 player, class_1799 itemInHand) {
        if (itemInHand.method_31574(class_1802.field_8600)) {
            boolean hasDriver = (Boolean)this.field_6011.method_12789(CAN_BE_DRIVEN);
            BalloonTourVehicle.message(player, (class_2561)class_2561.method_43470((String)(hasDriver ? "Enabled the automatic pilot for this balloon." : "Enabled Control on this balloon.")));
            this.field_6011.method_12778(CAN_BE_DRIVEN, (Object)(!hasDriver ? 1 : 0));
        }
    }

    @Override
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!player.method_5765() && !this.hasRiders()) {
            if (player.method_5715() && !this.method_37908().field_9236 && this.shiftInteraction(player, hand)) {
                return class_1269.field_51370;
            }
            SeatEntity closestSeat = null;
            double closestDistance = Double.MAX_VALUE;
            for (SeatEntity seat : this.seats) {
                double distance = player.method_19538().method_1022(seat.method_19538());
                if (!(distance < closestDistance)) continue;
                closestSeat = seat;
                closestDistance = distance;
            }
            if (closestSeat != null && closestSeat.hasNoPassenger()) {
                player.method_5804((class_1297)closestSeat);
                return class_1269.field_51370;
            }
        }
        return class_1269.field_5811;
    }

    @Override
    protected void applyAdditionalFeaturesTo(class_1799 vehicleItem) {
        if (this.path != null) {
            BalloonPathPoint balloonPathPoint;
            class_2487 checkpointTag;
            class_2487 tag = new class_2487();
            int size = 0;
            Iterator<BalloonPathPoint> iterator = this.path.iterator();
            while (iterator.hasNext() && (checkpointTag = (balloonPathPoint = iterator.next()).toCompound()) != null) {
                tag.method_10566("tour_checkpoint_" + ++size, (class_2520)checkpointTag);
            }
            tag.method_10569("tour_checkpoints", size);
            vehicleItem.method_57379((class_9331)JSDataComponents.TOUR_CHECKPOINTS.get(), (Object)tag);
        }
    }

    public void initFromCompound(class_2487 tag) {
        String str;
        class_2487 checkPoint;
        if (this.path == null) {
            this.path = new ArrayList<BalloonPathPoint>();
        }
        int numberOfCheckpoints = tag.method_10550("tour_checkpoints");
        for (int i = 0; i < numberOfCheckpoints && !(checkPoint = tag.method_10562(str = "tour_checkpoint_" + (i + 1))).method_33133(); ++i) {
            this.path.add(BalloonPathPoint.fromCompound(checkPoint));
        }
    }

    public float getMaxRaiseSpeed() {
        return this.maxRaiseSpeed;
    }

    public void setMaxRaiseSpeed(float maxRaiseSpeed) {
        this.maxRaiseSpeed = maxRaiseSpeed;
    }

    public float getCurrentRaise() {
        return this.currentRaise;
    }

    public static class BalloonPathPoint {
        public final class_243 position;
        public final float targetHeight;
        public final int stopTicks;
        public final boolean land;

        public BalloonPathPoint(class_243 position, float targetHeight, int stopTicks, boolean land) {
            this.position = position;
            this.targetHeight = targetHeight;
            this.stopTicks = stopTicks;
            this.land = land;
        }

        public class_2487 toCompound() {
            class_2487 tag = new class_2487();
            tag.method_10569("checkpoint_x", (int)this.position.field_1352);
            tag.method_10569("checkpoint_y", (int)this.position.field_1351);
            tag.method_10569("checkpoint_z", (int)this.position.field_1350);
            tag.method_10569("checkpoint_height", (int)this.targetHeight);
            tag.method_10569("checkpoint_stop_ticks", this.stopTicks);
            tag.method_10556("checkpoint_land", this.land);
            return tag;
        }

        public static BalloonPathPoint fromCompound(class_2487 checkPoint) {
            return new BalloonPathPoint(new class_243((double)checkPoint.method_10550("checkpoint_x"), (double)checkPoint.method_10550("checkpoint_y"), (double)checkPoint.method_10550("checkpoint_z")), checkPoint.method_10550("checkpoint_height"), checkPoint.method_10550("checkpoint_stop_ticks"), checkPoint.method_10577("checkpoint_land"));
        }
    }
}

