/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.other.vehicle;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import jp.jurassicsaga.client.base.sound.SoundRelayer;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.block.obj.entity.VehicleGate;
import jp.jurassicsaga.server.base.entity.obj.other.SeatEntity;
import jp.jurassicsaga.server.base.entity.obj.other.vehicle.JSVehicleEntity;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import jp.jurassicsaga.server.base.item.JSItems;
import jp.jurassicsaga.server.base.sound.JSSounds;
import jp.jurassicsaga.server.v2.block.entity.obj.TriggerTourRailEntity;
import jp.jurassicsaga.server.v2.block.obj.TourRailBlock;
import jp.jurassicsaga.server.v2.item.JSV2Items;
import jp.jurassicsaga.server.v2.item.obj.WrenchItem;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_9331;
import travelers.server.animal.TravelersAnimal;

public class FordExplorerEntity
extends JSVehicleEntity {
    protected static final class_2940<Boolean> IS_IN_TOUR_MODE = class_2945.method_12791(FordExplorerEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> REQUIRES_TAG_REFRESH = class_2945.method_12791(FordExplorerEntity.class, (class_2941)class_2943.field_13323);
    private static final Map<class_2768, class_2350[]> SHAPE_DIRS = Map.of(class_2768.field_12665, new class_2350[]{class_2350.field_11043, class_2350.field_11035}, class_2768.field_12674, new class_2350[]{class_2350.field_11034, class_2350.field_11039}, class_2768.field_12670, new class_2350[]{class_2350.field_11043, class_2350.field_11035}, class_2768.field_12668, new class_2350[]{class_2350.field_11035, class_2350.field_11043}, class_2768.field_12667, new class_2350[]{class_2350.field_11034, class_2350.field_11039}, class_2768.field_12666, new class_2350[]{class_2350.field_11039, class_2350.field_11034}, class_2768.field_12664, new class_2350[]{class_2350.field_11035, class_2350.field_11034}, class_2768.field_12671, new class_2350[]{class_2350.field_11035, class_2350.field_11039}, class_2768.field_12663, new class_2350[]{class_2350.field_11043, class_2350.field_11034}, class_2768.field_12672, new class_2350[]{class_2350.field_11043, class_2350.field_11039});
    private class_2350 railDir;
    private class_2338 currentRail;
    private class_2338 lastTriggerPos = null;
    private int stopTicks;
    private int blockedTicks;
    private FordExplorerEntity followTarget;
    private UUID linkedVehicleUUID;
    private boolean isInPursuit;
    private boolean cantFindRail;
    private float currentMaxSpeed = 0.1f;

    public FordExplorerEntity(class_1299<? extends JSVehicleEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.setMaxSpeed(0.9f);
        this.setTurnSpeed(5.0f);
        this.setMaxTurnSpeed(5.0f);
        this.setAcceleration(0.02f);
        this.setMaxSpeedBackwards(0.4f);
    }

    @Override
    void honk() {
        this.method_37908().method_8396(null, this.method_23312(), (class_3414)JSSounds.CAR_HONK.get(), class_3419.field_15245, 1.5f, 1.0f);
        Optional<SeatEntity> optionalSeatEntity = this.seats.stream().filter(seatEntity -> seatEntity.method_31483() != null).findFirst();
        List animals = this.method_37908().method_8390(JSAnimalBase.class, this.method_5829().method_1014(10.0), a -> true);
        for (JSAnimalBase animal : animals) {
            TravelersAnimal animalobj = animal.getAnimal();
            boolean attacksCar = animalobj.getAnimalAttributes().getMiscProperties().isAttacksCar();
            if (!attacksCar) {
                boolean bl = attacksCar = animal.getAggression() + animalobj.getAnimalAttributes().getSocialGroupProperties().getNaturalAggression() > 0.5f;
            }
            if (attacksCar) {
                class_1297 passenger;
                if (!optionalSeatEntity.isPresent() || !((passenger = optionalSeatEntity.get().method_31483()) instanceof class_1657)) continue;
                class_1657 player = (class_1657)passenger;
                animal.method_5980((class_1309)player);
                JSAnimalBase trueLeader = animal.getModules().getHerdModule().getTrueLeader();
                if (trueLeader != null) {
                    for (JSAnimalBase follower : trueLeader.getModules().getHerdModule().getFollowers()) {
                        if (follower.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT) {
                            follower.method_5980((class_1309)player);
                            continue;
                        }
                        follower.setFleeTarget(this);
                    }
                    trueLeader.method_5980((class_1309)player);
                }
                animal.setFleeTarget(null);
                continue;
            }
            animal.setFleeTarget(this);
            animal.method_5980(null);
        }
    }

    @Override
    protected class_1269 wrenchInteract(class_1268 hand, WrenchItem.WrenchMode wrenchMode, class_1657 player) {
        if (wrenchMode == WrenchItem.WrenchMode.TOGGLE_MODE) {
            boolean isInTour = (Boolean)this.field_6011.method_12789(IS_IN_TOUR_MODE);
            if (isInTour) {
                this.currentRail = null;
                this.lastTriggerPos = null;
                this.stopTicks = 0;
            } else {
                this.railDir = class_2350.method_10150((double)this.method_36454());
            }
            this.field_6011.method_12778(IS_IN_TOUR_MODE, (Object)(!this.isInTour() ? 1 : 0));
            JSUtils.message(player, (class_2561)(isInTour ? class_2561.method_43471((String)"tooltip.jurassicsaga.wrench.ford_toggle_off") : class_2561.method_43471((String)"tooltip.jurassicsaga.wrench.ford_toggle_on")));
        } else if (wrenchMode == WrenchItem.WrenchMode.LINK) {
            class_1799 wrench = player.method_5998(hand);
            if (wrench.method_31574((class_1792)JSV2Items.WRENCH.get())) {
                if (wrench.method_57826((class_9331)JSDataComponents.UUID.get())) {
                    String uuidString = (String)wrench.method_57824((class_9331)JSDataComponents.UUID.get());
                    if (uuidString != null) {
                        UUID uuid = UUID.fromString(uuidString);
                        if (!uuid.equals(this.method_5667())) {
                            this.linkedVehicleUUID = uuid;
                            this.isInPursuit = true;
                            wrench.method_57381((class_9331)JSDataComponents.UUID.get());
                            FordExplorerEntity.message(player, (class_2561)class_2561.method_43471((String)"tooltip.jurassicsaga.wrench.ford_link"));
                            if (this.linkedVehicleUUID != null && this.followTarget == null) {
                                class_1297 entity = ((class_3218)this.method_37908()).method_14190(this.linkedVehicleUUID);
                                if (entity instanceof FordExplorerEntity) {
                                    FordExplorerEntity fordExplorerEntity;
                                    this.followTarget = fordExplorerEntity = (FordExplorerEntity)entity;
                                    fordExplorerEntity.linkedVehicleUUID = this.method_5667();
                                    fordExplorerEntity.followTarget = this;
                                    fordExplorerEntity.isInPursuit = false;
                                } else {
                                    this.linkedVehicleUUID = null;
                                }
                            }
                        } else {
                            FordExplorerEntity.message(player, (class_2561)class_2561.method_43471((String)"tooltip.jurassicsaga.wrench.ford_link_fail_self"));
                        }
                        wrench.method_57381((class_9331)JSDataComponents.UUID.get());
                    } else {
                        wrench.method_57379((class_9331)JSDataComponents.UUID.get(), (Object)this.method_5845());
                    }
                } else {
                    wrench.method_57379((class_9331)JSDataComponents.UUID.get(), (Object)this.method_5845());
                }
                player.method_6122(hand, wrench);
            }
        } else if (wrenchMode == WrenchItem.WrenchMode.UNLINK) {
            this.unlink();
        }
        return super.wrenchInteract(hand, wrenchMode, player);
    }

    @Override
    public void method_5773() {
        if (!this.isInTour()) {
            super.method_5773();
            return;
        }
        this.method_5670();
        if (this.method_37908().field_9236) {
            if ((double)((Float)this.field_6011.method_12789(CURRENT_SPEED)).floatValue() != 0.0) {
                SoundRelayer.playCarLoop(this);
            } else {
                SoundRelayer.stopCarLoop(this);
            }
            super.method_5773();
        } else {
            class_1297 entity;
            this.animateServer();
            float speed = this.getCurrentSpeed();
            if (!this.isInPursuit) {
                speed = this.handleSpeed(speed);
            } else if (this.followTarget != null) {
                double dist = this.followTarget.method_5739(this);
                float targetSpeed = dist > 11.5 ? Math.min(1.1f, Math.max(0.1f, this.followTarget.getCurrentSpeed()) * 2.0f) : (dist < 10.5 ? ((double)this.followTarget.getCurrentSpeed() == 0.0 ? -0.1f : Math.max(0.001f, this.followTarget.getCurrentSpeed()) * 0.6f) : this.followTarget.getCurrentSpeed());
                if (speed < targetSpeed) {
                    speed = Math.min(speed + this.acceleration, Math.min(targetSpeed, this.getMaxSpeed()));
                } else if (speed > targetSpeed) {
                    speed = Math.max(speed - this.acceleration, targetSpeed);
                }
            } else if (this.linkedVehicleUUID != null && (entity = ((class_3218)this.method_37908()).method_14190(this.linkedVehicleUUID)) instanceof FordExplorerEntity) {
                FordExplorerEntity fordExplorerEntity;
                this.followTarget = fordExplorerEntity = (FordExplorerEntity)entity;
                fordExplorerEntity.linkedVehicleUUID = this.method_5667();
                fordExplorerEntity.followTarget = this;
                fordExplorerEntity.isInPursuit = false;
            }
            class_2338 railPos = this.currentRail == null ? this.method_24515() : this.currentRail;
            class_243 railCenter = class_243.method_24953((class_2382)railPos);
            if (this.currentRail == null || this.method_19538().method_1025(railCenter) < 2.0) {
                class_2338 next = this.findNextRail(railPos);
                if (next != null) {
                    this.currentRail = next;
                    railPos = next;
                    this.cantFindRail = false;
                } else {
                    this.cantFindRail = true;
                }
            }
            class_243 target = class_243.method_24953((class_2382)railPos);
            class_243 dir = target.method_1020(this.method_19538()).method_1029();
            float targetYaw = (float)(Math.atan2(-dir.field_1352, dir.field_1350) * 57.29577951308232);
            float currentYaw = this.method_36454();
            float newYaw = class_3532.method_17821((float)0.1f, (float)currentYaw, (float)targetYaw);
            this.method_36456(newYaw);
            double dx = dir.field_1352 * (double)this.getCurrentSpeed();
            double dz = dir.field_1350 * (double)this.getCurrentSpeed();
            class_243 movementVec = this.applyGravityToVec(dx, dz);
            this.method_5784(class_1313.field_6308, movementVec);
            this.setCurrentSpeed(speed);
            this.method_36456(newYaw);
            this.setCurrentSpeed(speed);
            this.handleCollision();
            this.method_56990();
            this.checkForClimbingBlocks();
            this.updateSeats(this.method_36454());
        }
    }

    private float handleSpeed(float speed) {
        double dist;
        if (this.cantFindRail) {
            return Math.max(speed - this.acceleration, 0.0f);
        }
        if (this.stopTicks == 0) {
            double lookAhead = 8.0 * (double)Math.max(1.0f, speed * 4.0f);
            double brakeStart = 30.0;
            double fullStop = 15.0;
            class_243 pos = this.method_19538();
            class_243 forward = this.method_5720().method_1029();
            class_238 scanBox = this.method_5829().method_18804(forward.method_1021(lookAhead)).method_1014(1.0);
            List entities = this.method_37908().method_8333((class_1297)this, scanBox, e -> e instanceof class_1309 && e.method_5805() && e != this && !e.method_5765());
            double nearestForward = Double.MAX_VALUE;
            class_1297 nearestEntity = null;
            for (class_1297 e2 : entities) {
                class_243 toEntity = e2.method_5829().method_1005().method_1020(pos);
                double forwardDist = toEntity.method_1026(forward);
                if (forwardDist <= 0.0 || forwardDist > lookAhead) continue;
                class_243 closest = pos.method_1019(forward.method_1021(forwardDist));
                double hitboxDistSq = e2.method_5829().method_49271(closest);
                double score = Math.sqrt(hitboxDistSq);
                if (!(score < nearestForward)) continue;
                nearestForward = score;
                nearestEntity = e2;
            }
            if (nearestForward < brakeStart) {
                if (this.blockedTicks == 0) {
                    if (nearestEntity instanceof JSAnimalBase) {
                        JSAnimalBase base = (JSAnimalBase)nearestEntity;
                        if (!base.isDead()) {
                            this.honk();
                        }
                    } else {
                        this.honk();
                    }
                    this.blockedTicks = 40;
                } else {
                    --this.blockedTicks;
                }
                if (nearestForward <= fullStop) {
                    return Math.max(speed - this.acceleration * 4.0f, 0.0f);
                }
                return Math.max(speed - this.acceleration * 2.0f, this.getMaxSpeed() * 0.5f);
            }
        }
        if (this.stopTicks > 0) {
            --this.stopTicks;
            if (speed > 0.0f) {
                return Math.max(speed - this.acceleration, 0.0f);
            }
            if (speed < 0.02f) {
                return 0.0f;
            }
        }
        if (this.followTarget != null && (dist = (double)this.followTarget.method_5739(this)) > 16.0) {
            if (dist > 22.0) {
                if ((double)speed > 0.0) {
                    return Math.max(speed - this.acceleration, 0.0f);
                }
                return 0.0f;
            }
            if (speed > this.getMaxSpeed() * 0.5f) {
                return Math.max(speed - this.acceleration, this.getMaxSpeed() * 0.5f);
            }
            return speed;
        }
        if (Math.abs(speed) < 1.0E-4f) {
            speed = 0.0f;
        }
        speed = speed < this.getMaxSpeed() ? Math.min(speed + this.acceleration, this.getMaxSpeed()) : this.getMaxSpeed();
        return speed;
    }

    private void stopFor(int stopTicks) {
        this.stopTicks = stopTicks;
    }

    public void setSpeed(float speed) {
        this.currentMaxSpeed = speed;
    }

    private class_2338 findNextRail(class_2338 pos) {
        boolean isGate;
        class_2768 shape;
        class_2350[] options;
        class_2680 state = this.method_37908().method_8320(pos);
        if (!this.isValidBlock(pos)) {
            state = this.method_37908().method_8320(pos.method_10074());
            if (!this.isValidBlock(pos = pos.method_10074())) {
                return null;
            }
        }
        if ((options = SHAPE_DIRS.get(shape = (isGate = state.method_26204() instanceof VehicleGate) ? this.getShapeFromGate(state) : (class_2768)state.method_11654((class_2769)class_2741.field_12507))) == null) {
            return null;
        }
        class_2350 back = this.railDir == null ? null : this.railDir.method_10153();
        for (class_2350 dir : options) {
            class_2338 up;
            if (dir == back) continue;
            class_2338 next = pos.method_10093(dir);
            if (this.isValidBlock(next.method_10074())) {
                this.railDir = dir;
                return next;
            }
            if (this.isValidBlock(next)) {
                this.railDir = dir;
                return next;
            }
            if (!shape.method_11897() || !this.isValidBlock(up = next.method_10084())) continue;
            return up;
        }
        return null;
    }

    private class_2768 getShapeFromGate(class_2680 state) {
        Optional facing = state.method_28500((class_2769)class_2741.field_12481);
        if (facing.isPresent()) {
            class_2350 actualFacing = (class_2350)facing.get();
            if (actualFacing == class_2350.field_11043 || actualFacing == class_2350.field_11035) {
                return class_2768.field_12665;
            }
            return class_2768.field_12674;
        }
        return class_2768.field_12665;
    }

    private boolean isValidBlock(class_2338 pos) {
        class_2680 block = this.method_37908().method_8320(pos);
        if (block.method_26204() instanceof VehicleGate) {
            return (Boolean)block.method_11654((class_2769)VehicleGate.IS_BASE);
        }
        return block.method_26204() instanceof TourRailBlock;
    }

    @Override
    protected void updateDriver(class_1657 driver) {
        if (this.isInTour()) {
            return;
        }
        super.updateDriver(driver);
    }

    @Override
    protected void updateNoDriver() {
        if (this.isInTour()) {
            return;
        }
        super.updateNoDriver();
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IS_IN_TOUR_MODE, (Object)false);
        builder.method_56912(REQUIRES_TAG_REFRESH, (Object)false);
    }

    @Override
    protected void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10556("IS_IN_TOUR_MODE", ((Boolean)this.field_6011.method_12789(IS_IN_TOUR_MODE)).booleanValue());
        compoundTag.method_10556("REQUIRES_TAG_REFRESH", ((Boolean)this.field_6011.method_12789(REQUIRES_TAG_REFRESH)).booleanValue());
        compoundTag.method_10548("MAX_SPEED", this.currentMaxSpeed);
        compoundTag.method_10569("stopTicks", this.stopTicks);
        compoundTag.method_10582("LINKED_VEHICLE", this.followTarget == null ? (this.linkedVehicleUUID == null ? "" : this.linkedVehicleUUID.toString()) : this.followTarget.method_5845());
        compoundTag.method_10556("inPursuit", this.isInPursuit);
        compoundTag.method_10582("railDir", this.railDir.method_10151());
        compoundTag.method_10569("railPosX", this.currentRail == null ? 0 : this.currentRail.method_10263());
        compoundTag.method_10569("railPosY", this.currentRail == null ? -9999 : this.currentRail.method_10264());
        compoundTag.method_10569("railPosZ", this.currentRail == null ? 0 : this.currentRail.method_10260());
        compoundTag.method_10556("cantFindRail", this.cantFindRail);
    }

    @Override
    protected void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.field_6011.method_12778(IS_IN_TOUR_MODE, (Object)compoundTag.method_10577("IS_IN_TOUR_MODE"));
        this.field_6011.method_12778(REQUIRES_TAG_REFRESH, (Object)compoundTag.method_10577("REQUIRES_TAG_REFRESH"));
        this.currentMaxSpeed = compoundTag.method_10583("MAX_SPEED");
        this.stopTicks = compoundTag.method_10550("stopTicks");
        try {
            this.linkedVehicleUUID = UUID.fromString(compoundTag.method_10558("LINKED_VEHICLE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isInPursuit = compoundTag.method_10577("inPursuit");
        this.railDir = (class_2350)class_2350.field_29502.method_47920(compoundTag.method_10558("railDir"), (Enum)class_2350.field_11043);
        int y = compoundTag.method_10550("railPosY");
        if (y != -9999) {
            int x = compoundTag.method_10550("railPosX");
            int z = compoundTag.method_10550("railPosZ");
            this.currentRail = new class_2338(x, y, z);
        }
        this.cantFindRail = compoundTag.method_10577("cantFindRail");
    }

    public void unlink() {
        if (this.followTarget != null && !this.isInPursuit) {
            this.followTarget.unlink();
        }
        if (this.isInPursuit && this.followTarget != null) {
            this.currentMaxSpeed = this.followTarget.currentMaxSpeed;
        }
        this.linkedVehicleUUID = null;
        this.isInPursuit = false;
        this.followTarget = null;
    }

    @Override
    public float getMaxSpeed() {
        if (this.isInTour()) {
            return this.currentMaxSpeed;
        }
        return super.getMaxSpeed();
    }

    private boolean isInTour() {
        return (Boolean)this.field_6011.method_12789(IS_IN_TOUR_MODE);
    }

    @Override
    public boolean canTriggerNearbyDoors() {
        return true;
    }

    @Override
    protected class_1792 vehicleItem() {
        return (class_1792)JSItems.FORD_EXPLORER.get();
    }

    @Override
    protected void initializeSeats() {
        this.addSeat(0.5, 0.55, 0.2);
        this.addSeat(-0.5, 0.55, 0.2);
        this.addSeat(0.5, 0.5, -1.25);
        this.addSeat(-0.5, 0.5, -1.25);
    }

    @Override
    public void initItem(class_1799 itemInHand, class_1838 context) {
        this.railDir = class_2350.method_10150((double)this.method_36454()).method_10153();
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        if (this.followTarget != null) {
            this.followTarget.unlink();
        }
    }

    public void trigger(TriggerTourRailEntity railEntity) {
        if (this.lastTriggerPos != railEntity.method_11016()) {
            this.lastTriggerPos = railEntity.method_11016();
            if ((float)railEntity.getSpeed() > 0.0f) {
                this.setSpeed((float)railEntity.getSpeed() / 100.0f);
                if (this.followTarget != null) {
                    this.followTarget.setSpeed((float)railEntity.getSpeed() / 100.0f);
                }
            }
            if ((float)railEntity.getStopTicks() > 0.0f) {
                this.stopFor(railEntity.getStopTicks());
            }
        }
    }

    public class_2350 getRailDir() {
        return this.railDir;
    }

    public class_2338 getCurrentRail() {
        return this.currentRail;
    }

    public class_2338 getLastTriggerPos() {
        return this.lastTriggerPos;
    }

    public int getStopTicks() {
        return this.stopTicks;
    }

    public int getBlockedTicks() {
        return this.blockedTicks;
    }

    public FordExplorerEntity getFollowTarget() {
        return this.followTarget;
    }

    public UUID getLinkedVehicleUUID() {
        return this.linkedVehicleUUID;
    }

    public boolean isInPursuit() {
        return this.isInPursuit;
    }

    public boolean isCantFindRail() {
        return this.cantFindRail;
    }

    public float getCurrentMaxSpeed() {
        return this.currentMaxSpeed;
    }
}

