/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.other.vehicle;

import java.util.HashMap;
import java.util.Map;
import jp.jurassicsaga.server.base.entity.obj.other.vehicle.JSVehicleEntity;
import net.minecraft.class_1297;
import travelers.server.animal.ModelType;
import travelers.server.animal.obj.animation.TravelersAnimationWrapper;

public class VehicleAnimations {
    private final Map<String, AnimationState> animationMap = new HashMap<String, AnimationState>();
    private final JSVehicleEntity base;

    public VehicleAnimations(JSVehicleEntity base) {
        this.base = base;
    }

    public boolean playTransition(boolean play, TravelersAnimationWrapper startAnim, TravelersAnimationWrapper loopAnim, TravelersAnimationWrapper outAnim) {
        return this.playTransition(play, false, startAnim, loopAnim, outAnim);
    }

    public boolean playTransition(boolean play, boolean stopInPlace, TravelersAnimationWrapper startAnim, TravelersAnimationWrapper loopAnim, TravelersAnimationWrapper outAnim) {
        String key = startAnim.getAnimation().getName() + "." + loopAnim.getAnimation().getName() + "." + outAnim.getAnimation().getName();
        AnimationState state = this.animationMap.computeIfAbsent(key, k -> new AnimationState(Phase.IDLE));
        int startDur = startAnim.getTickDuration();
        int outDur = outAnim.getTickDuration();
        if (play) {
            switch (state.phase.ordinal()) {
                case 0: {
                    state.phase = Phase.START;
                    state.ticks = 0;
                    break;
                }
                case 3: {
                    state.phase = Phase.LOOP;
                    state.ticks = 0;
                    loopAnim.getAnimation().sendForEntity(ModelType.AZURE, (class_1297)this.base);
                    return true;
                }
            }
            if (state.phase == Phase.START) {
                if (state.ticks++ < startDur) {
                    startAnim.getAnimation().sendForEntity(ModelType.AZURE, (class_1297)this.base);
                } else {
                    state.phase = Phase.LOOP;
                    state.ticks = 0;
                    loopAnim.getAnimation().sendForEntity(ModelType.AZURE, (class_1297)this.base);
                }
                return true;
            }
            if (state.phase == Phase.LOOP) {
                loopAnim.getAnimation().sendForEntity(ModelType.AZURE, (class_1297)this.base);
                return true;
            }
            return true;
        }
        switch (state.phase.ordinal()) {
            case 0: {
                return false;
            }
            case 2: {
                state.phase = Phase.OUT;
                state.ticks = 0;
                break;
            }
            case 1: {
                if (state.ticks++ < startDur) {
                    startAnim.getAnimation().sendForEntity(ModelType.AZURE, (class_1297)this.base);
                    return true;
                }
                state.phase = Phase.OUT;
                state.ticks = 0;
            }
        }
        if (state.phase == Phase.OUT) {
            outAnim.getAnimation().sendForEntity(ModelType.AZURE, (class_1297)this.base);
            if (++state.ticks >= outDur) {
                this.animationMap.remove(key);
                return false;
            }
            return true;
        }
        this.animationMap.put(key, state);
        return true;
    }

    private static class AnimationState {
        int ticks;
        Phase phase;

        AnimationState(Phase phase) {
            this.phase = phase;
        }
    }

    private static enum Phase {
        IDLE,
        START,
        LOOP,
        OUT;

    }
}

