/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.visitor.nav;

import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.entity.obj.visitor.nav.VisitorPathFinder;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.navigation.obj.TravelersGenericNav;

public class VisitorNav
extends TravelersPathNavigation {
    private final SmartAnimalBase base;
    private final int recomputeTick = 0;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public VisitorNav(SmartAnimalBase mob, class_1937 level) {
        super(mob, level);
        this.base = mob;
    }

    protected boolean canUpdatePath() {
        return this.mob.method_24828() || this.mob.method_52535() || this.mob.method_5765();
    }

    protected class_243 getTempMobPos() {
        return new class_243(this.mob.method_23317(), (double)this.getSurfaceY(), this.mob.method_23321());
    }

    protected void trimPath() {
        super.trimPath();
    }

    public CompletableFuture<TravelersPath> createPath(class_2338 pos, double accuracy) {
        class_2818 levelchunk = this.level.method_8398().method_21730(class_4076.method_18675((int)pos.method_10263()), class_4076.method_18675((int)pos.method_10260()));
        if (levelchunk == null) {
            return null;
        }
        if (levelchunk.method_8320(pos).method_26215()) {
            class_2338 blockpos = pos.method_10074();
            while (blockpos.method_10264() > this.level.method_31607() && levelchunk.method_8320(blockpos).method_26215()) {
                blockpos = blockpos.method_10074();
            }
            if (blockpos.method_10264() > this.level.method_31607()) {
                return super.createPath(blockpos.method_10084(), accuracy);
            }
            while (blockpos.method_10264() < this.level.method_31600() && levelchunk.method_8320(blockpos).method_26215()) {
                blockpos = blockpos.method_10084();
            }
            pos = blockpos;
        }
        if (!levelchunk.method_8320(pos).method_51367()) {
            return super.createPath(pos, accuracy);
        }
        class_2338 blockpos1 = pos.method_10084();
        while (blockpos1.method_10264() < this.level.method_31600() && levelchunk.method_8320(blockpos1).method_51367()) {
            blockpos1 = blockpos1.method_10084();
        }
        return super.createPath(blockpos1, accuracy);
    }

    public CompletableFuture<TravelersPath> createPath(class_1297 entity, int accuracy) {
        return this.createPath(entity.method_24515(), (double)accuracy);
    }

    private int getSurfaceY() {
        if (this.mob.method_5799() && this.canFloat()) {
            int i = this.mob.method_31478();
            class_2680 blockstate = this.level.method_8320(class_2338.method_49637((double)this.mob.method_23317(), (double)i, (double)this.mob.method_23321()));
            int j = 0;
            while (blockstate.method_27852(class_2246.field_10382)) {
                blockstate = this.level.method_8320(class_2338.method_49637((double)this.mob.method_23317(), (double)(++i), (double)this.mob.method_23321()));
                if (++j <= 16) continue;
                return this.mob.method_31478();
            }
            return i;
        }
        return class_3532.method_15357((double)(this.mob.method_23318() + 0.5));
    }

    public boolean isStableDestination(class_2338 pos) {
        class_2338 blockpos = pos.method_10074();
        class_2680 state = this.level.method_8320(blockpos);
        if (this.base.method_5799()) {
            if (state.method_26227().method_15769()) {
                return state.method_26216((class_1922)this.level, blockpos);
            }
            return !state.method_26216((class_1922)this.level, blockpos);
        }
        return state.method_26216((class_1922)this.level, blockpos);
    }

    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        class_243 temptPos = this.getTempMobPos();
        if (TravelersGenericNav.shouldTargetNextNodeInDirection((TravelersPath)this.path, (SmartAnimalBase)this.base)) {
            this.path.advance();
        }
        this.checkStuckOnNode();
        if (this.path != null && this.getPath().isDone()) {
            this.stop();
        }
    }

    private void checkStuckOnNode() {
        if (this.path == null) {
            return;
        }
        int nodeIndex = this.path.getNextNodeIndex() - 1;
        if (nodeIndex >= 0) {
            if (nodeIndex > this.path.getNodeCount()) {
                return;
            }
            if (this.curNodeIndex == nodeIndex) {
                ++this.nodeStuckTime;
                if (this.nodeStuckTime > 200) {
                    this.stop();
                }
                return;
            }
            this.nodeStuckTime = 0;
            this.curNodeIndex = nodeIndex;
        }
    }

    @NotNull
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new VisitorPathFinder();
        return new TravelersPathFinder(this.nodeEvaluator);
    }

    public void setCanOpenDoors(boolean canOpenDoors) {
        this.nodeEvaluator.setCanOpenDoors(canOpenDoors);
    }

    public boolean canPassDoors() {
        return this.nodeEvaluator.isCanPassDoors();
    }

    public void setCanPassDoors(boolean canPassDoors) {
        this.nodeEvaluator.setCanPassDoors(canPassDoors);
    }

    public boolean canOpenDoors() {
        return this.nodeEvaluator.isCanOpenDoors();
    }

    public void setCanWalkOverFences(boolean canWalkOverFences) {
        this.nodeEvaluator.setCanWalkOverFences(canWalkOverFences);
    }
}

