/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.generic.gene;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_5819;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class JSGeneUtil {
    public static JSGeneData fromCompound(@Nullable class_2487 tag) {
        if (tag == null || tag.method_33133()) {
            return new JSGeneData();
        }
        JSGeneData data = new JSGeneData();
        data.loadFromNbt(tag);
        return data;
    }

    public static JSGeneData readFromStack(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return new JSGeneData();
        }
        class_2487 tag = (class_2487)stack.method_57824((class_9331)JSDataComponents.GENE_DATA.get());
        return JSGeneUtil.fromCompound(tag);
    }

    public static class_1799 writeToStack(class_1799 stack, JSGeneData geneData) {
        if (stack == null || stack.method_7960() || geneData == null) {
            return stack;
        }
        class_2487 tag = new class_2487();
        geneData.saveToNbt(tag);
        stack.method_57379((class_9331)JSDataComponents.GENE_DATA.get(), (Object)tag);
        return stack;
    }

    public static class_1799 wipeStack(class_1799 stack) {
        if (stack != null && !stack.method_7960()) {
            stack.method_57381((class_9331)JSDataComponents.GENE_DATA.get());
        }
        return stack;
    }

    public static JSGeneData combineBreeding(class_5819 random, JSGeneData geneData, JSGeneData fatherGeneData) {
        List<JSGene> motherGenes = geneData.geneDataHolder.getGENE_SET();
        List<JSGene> fatherGenes = fatherGeneData.geneDataHolder.getGENE_SET();
        JSGeneData babyGenes = geneData.copy().resetGenes();
        ArrayList<JSGene> possible = new ArrayList<JSGene>();
        HashSet<JSGene> all = new HashSet<JSGene>();
        all.addAll(motherGenes);
        all.addAll(fatherGenes);
        for (JSGene gene : all) {
            if (gene == null) continue;
            double intChance = 0.5;
            if (!gene.canBeInherited()) continue;
            if (motherGenes.contains(gene) && fatherGenes.contains(gene)) {
                intChance = Math.clamp(intChance + 0.25, 0.0, 1.0);
            }
            if (intChance == 0.0 || intChance != 1.0 && !((double)random.method_43057() <= intChance)) continue;
            possible.add(gene);
        }
        if (!possible.isEmpty()) {
            for (JSGene gene : possible) {
                if (gene == null) continue;
                babyGenes.addGene(gene);
            }
        }
        return babyGenes;
    }
}

