/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item.obj.egg;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.obj.AnimalAttachment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicSpawnEgg
extends class_1826
implements AnimalAttachment {
    private static final List<BasicSpawnEgg> MOD_EGGS = new ArrayList<BasicSpawnEgg>();
    private static final class_2357 DEFAULT_DISPENSE_BEHAVIOR = (source, stack) -> {
        class_2350 face = (class_2350)source.comp_1969().method_11654((class_2769)class_2315.field_10918);
        class_1299 type = ((class_1826)stack.method_7909()).method_8015(stack);
        try {
            class_1297 base = type.method_5883((class_1937)source.comp_1967());
            if (base instanceof JSAnimalBase) {
                JSAnimalBase entity = (JSAnimalBase)base;
                class_1792 patt0$temp = stack.method_7909();
                if (patt0$temp instanceof BasicSpawnEgg) {
                    BasicSpawnEgg spawnEgg = (BasicSpawnEgg)patt0$temp;
                    JSGeneData data = JSGeneUtil.readFromStack(stack);
                    entity.getModules().getGrowthStageModule().setMax();
                    entity.getModules().getMetabolismModule().setMax();
                    data.setGeneSeed(source.comp_1967().method_8409().method_43054());
                    data.setDataOwnerName(spawnEgg.animal.getAnimalAttributes().getModId() + ":" + spawnEgg.animal.getAnimalAttributes().getAnimalName());
                    entity.getModules().getGeneticModule().setGeneData(data);
                    entity.getModules().getGeneticModule().hatch();
                    entity.method_5943((class_5425)source.comp_1967(), source.comp_1967().method_8404(source.comp_1968()), class_3730.field_16465, null);
                    stack.method_7934(1);
                    entity.method_33574(source.comp_1968().method_10093(face).method_61082());
                    source.comp_1967().method_8649((class_1297)entity);
                    source.comp_1967().method_43276((class_6880)class_5712.field_28738, source.comp_1968(), class_5712.class_7397.method_43287((class_2680)source.comp_1969()));
                }
            }
        }
        catch (Exception exception) {
            class_2357.field_34020.error("Error while dispensing spawn egg from dispenser at {}", (Object)source.comp_1968(), (Object)exception);
            return class_1799.field_8037;
        }
        return stack;
    };
    private final Supplier<? extends class_1299<? extends JSAnimalBase>> typeSupplier;
    private final JSAnimal<?> animal;

    public BasicSpawnEgg(JSAnimal<?> animal, Supplier<? extends class_1299<? extends JSAnimalBase>> type, int backgroundColor, int highlightColor, class_1792.class_1793 props) {
        super(type.get(), backgroundColor, highlightColor, props);
        this.typeSupplier = type;
        this.animal = animal;
        MOD_EGGS.add(this);
    }

    @NotNull
    public class_1799 method_7854() {
        class_1799 stack = super.method_7854();
        JSGeneData genes = this.animal.getAnimalAttributes().getGeneticProperties().getSpawnGenetics();
        genes.setBaseQuality(100);
        return JSGeneUtil.writeToStack(stack, genes);
    }

    public static void registerDispense() {
        for (BasicSpawnEgg modEgg : MOD_EGGS) {
            class_2357 dispenseBehavior = modEgg.createDispenseBehavior();
            if (dispenseBehavior == null) continue;
            class_2315.method_10009((class_1935)modEgg, (class_2357)dispenseBehavior);
        }
    }

    @NotNull
    public class_1799 getDefaultInstanceNoData() {
        class_1799 stack = super.method_7854();
        return stack;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        String value = String.valueOf(this.animal.getAnimalAttributes().getMiscProperties().getVersion().versionId());
        if (value.equalsIgnoreCase("-1")) {
            value = "Addon";
        }
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltip.jurassicsaga.version").method_27693(value).method_27692(class_124.field_1063));
        JSGeneData data = JSGeneUtil.readFromStack(stack);
        if (data.geneDataHolder.getGENE_SET().isEmpty()) {
            return;
        }
        if (!JSCommon.isShiftKeyDown && !tooltipFlag.method_8035()) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltip.jurassicsaga.shift_hint").method_27692(class_124.field_1078));
        } else if (!data.geneDataHolder.getGENE_SET().isEmpty()) {
            tooltipComponents.add((class_2561)class_2561.method_43470((String)"Genes:"));
            int geneId = 0;
            for (JSGene gene : data.geneDataHolder.getGENE_SET()) {
                tooltipComponents.add((class_2561)class_2561.method_43470((String)(++geneId + ". ")).method_10852((class_2561)gene.getTranslatableObject()).method_27692(gene.getToolTipColour()));
            }
        }
    }

    @NotNull
    public class_1269 method_7884(class_1838 pContext) {
        class_1937 level = pContext.method_8045();
        if (!(level instanceof class_3218)) {
            return class_1269.field_5812;
        }
        class_1799 itemstack = pContext.method_8041();
        class_2338 blockpos = pContext.method_8037();
        class_2350 direction = pContext.method_8038();
        class_2680 blockstate = level.method_8320(blockpos);
        class_1657 player = pContext.method_8036();
        if (player == null) {
            return class_1269.field_5811;
        }
        class_2338 blockpos1 = blockstate.method_26220((class_1922)level, blockpos).method_1110() ? blockpos : blockpos.method_10093(direction);
        class_1299 entitytype = this.method_8015(itemstack);
        JSAnimalBase entity = (JSAnimalBase)entitytype.method_5883((class_1937)((class_3218)level));
        if (entity != null) {
            JSGeneData data = JSGeneUtil.readFromStack(itemstack);
            if (player.method_5715()) {
                entity.getModules().getGrowthStageModule().setGrowthStage(AnimalGrowthStage.BABY);
                entity.getModules().getGrowthStageModule().setGrowthProgress(0);
            } else {
                entity.getModules().getGrowthStageModule().setMax();
            }
            entity.getModules().getMetabolismModule().setMax();
            data.setGeneSeed(level.method_8409().method_43054());
            data.setDataOwnerName(this.animal.getAnimalAttributes().getModId() + ":" + this.animal.getAnimalAttributes().getAnimalName());
            entity.getModules().getGeneticModule().setGeneData(data);
            entity.getModules().getGeneticModule().hatch();
            entity.method_33574(blockpos1.method_61082());
            entity.method_5943((class_5425)level, level.method_8404(blockpos1), class_3730.field_16465, null);
            level.method_8649((class_1297)entity);
            itemstack.method_7934(1);
            level.method_33596((class_1297)pContext.method_8036(), (class_6880)class_5712.field_28738, blockpos);
        }
        return class_1269.field_21466;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 pLevel, class_1657 pPlayer, @NotNull class_1268 pHand) {
        class_1799 itemstack = pPlayer.method_5998(pHand);
        class_3965 blockhitresult = BasicSpawnEgg.method_7872((class_1937)pLevel, (class_1657)pPlayer, (class_3959.class_242)class_3959.class_242.field_1345);
        if (blockhitresult.method_17783() != class_239.class_240.field_1332) {
            return class_1271.method_22430((Object)itemstack);
        }
        if (!(pLevel instanceof class_3218)) {
            return class_1271.method_22427((Object)itemstack);
        }
        class_2338 blockpos = blockhitresult.method_17777();
        if (!(pLevel.method_8320(blockpos).method_26204() instanceof class_2404)) {
            return class_1271.method_22430((Object)itemstack);
        }
        if (pLevel.method_8505(pPlayer, blockpos) && pPlayer.method_7343(blockpos, blockhitresult.method_17780(), itemstack)) {
            class_1299 entitytype = this.method_8015(itemstack);
            JSAnimalBase entity = (JSAnimalBase)entitytype.method_5894((class_3218)pLevel, itemstack, pPlayer, blockpos, class_3730.field_16465, false, false);
            if (entity == null) {
                return class_1271.method_22430((Object)itemstack);
            }
            JSGeneData data = JSGeneUtil.readFromStack(itemstack);
            if (pPlayer.method_5715()) {
                entity.getModules().getGrowthStageModule().setGrowthStage(AnimalGrowthStage.BABY);
                entity.getModules().getGrowthStageModule().setGrowthProgress(0);
            } else {
                entity.getModules().getGrowthStageModule().setMax();
            }
            entity.getModules().getMetabolismModule().setMax();
            data.setGeneSeed(pLevel.method_8409().method_43054());
            data.setDataOwnerName(this.animal.getAnimalAttributes().getModId() + ":" + this.animal.getAnimalAttributes().getAnimalName());
            entity.getModules().getGeneticModule().setGeneData(data);
            entity.getModules().getGeneticModule().hatch();
            entity.method_5943((class_5425)pLevel, pLevel.method_8404(blockpos), class_3730.field_16465, null);
            pPlayer.method_7259(class_3468.field_15372.method_14956((Object)this));
            entity.method_33574(blockpos.method_61082());
            pLevel.method_8649((class_1297)entity);
            itemstack.method_57008(1, (class_1309)pPlayer);
            pLevel.method_33596((class_1297)pPlayer, (class_6880)class_5712.field_28738, blockpos);
            return class_1271.method_22428((Object)itemstack);
        }
        return class_1271.method_22431((Object)itemstack);
    }

    @Nullable
    protected class_2357 createDispenseBehavior() {
        return DEFAULT_DISPENSE_BEHAVIOR;
    }

    @Override
    public JSAnimal<?> getAnimal() {
        return this.animal;
    }
}

