/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.GenericHerdPool;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.ApatosaurusAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ApatosaurusEntity;
import net.minecraft.class_1311;
import net.minecraft.class_241;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class ApatosaurusAnimal
extends AbstractJSAnimal<ApatosaurusEntity> {
    public ApatosaurusAnimal() {
        super("apatosaurus");
        this.setAnimator(new ApatosaurusAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<ApatosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(2.5f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.setEggRenderScale(1.4f);
        geneticProperties.addSupportedGenes(JSGenetics.OCEAN_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<ApatosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.HERBIVORE);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(15.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(9.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<ApatosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.JURASSIC);
        miscProperties.setMachineScale(0.7f);
        miscProperties.setMaxHeadRotation(25.0f, 30.0f);
        miscProperties.setGuidebookScaling(new float[]{1.1f, 0.3f});
        miscProperties.setGuidebookOffset(new class_241(-2.0f, 0.0f), new class_241(-1.0f, 0.0f));
        miscProperties.setBabyAnimations();
        miscProperties.enableGuidebookPose();
        miscProperties.setExtinct();
        miscProperties.setGuideBookDescription("Apatosaurus was a massive, long-necked Jurassic herbivore, moving in herds and feeding on low to mid-level vegetation.");
        miscProperties.setGuideBookSource("North America, Europe");
        miscProperties.setGuideBookScientificName("Apatosaurus louisae");
        miscProperties.setAdvancementTitle("You're Making Them Nervous");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<ApatosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addHerdTargets(GenericHerdPool.BASE_HERBIVORE_POOL);
        socialGroupProperties.setMaxHerdSize(40);
        socialGroupProperties.setMaxDistanceToPackLeader(3200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(800.0f);
        socialGroupProperties.enableNesting();
    }

    @Override
    protected void applyItemProperties(JSItemProperties<ApatosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.OSTRICH);
        itemProperties.setSpawnEggColors(6840648, 4080700);
        itemProperties.setSpawnEggColorsMale(6844502, 4475439);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<ApatosaurusEntity> attributes, EntityBaseProperties<ApatosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setSizeDimorphism(140.0);
        base.setSizeClass(AnimalSizeClass.LARGE);
        base.setMaxTurnRate(13.0);
        base.setRenderScale((double)3.1f);
        base.setLocator(new JSAnimalBaseLocator());
        base.setTurnSmoothRate((double)0.2f);
        attributes.setPersistent();
        attributes.setEntityFactory(ApatosaurusEntity::new);
        attributes.setEyeHeight((double)0.95f);
        attributes.setCategory(class_1311.field_6294);
        attributes.setMaxHealth(100.0);
        attributes.setDimensions((double)4.9f, 5.75);
        attributes.setMovementSpeed((double)0.2f);
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier((double)1.4f);
        attributes.setAttackDamage(20.0);
        attributes.setAttackSpeed(1.0);
        attributes.setAttackKnockback(0.0);
        attributes.setFollowRange(64.0);
    }
}

