/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.GenericHerdPool;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.BasicHerbivoreAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.HadrosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.AchillobatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.BaryonyxEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.DracovenatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.HerrerasaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MetriacanthosaurusEntity;
import jp.jurassicsaga.server.v4.animal.entity.extinct.terrestial.CeratosaurusEntity;
import jp.jurassicsaga.server.v4.animal.entity.extinct.terrestial.SpinosaurusEntity;
import net.minecraft.class_1311;
import net.minecraft.class_241;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class HadrosaurusAnimal
extends AbstractJSAnimal<HadrosaurusEntity> {
    public HadrosaurusAnimal() {
        super("hadrosaurus");
        this.setAnimator(new BasicHerbivoreAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<HadrosaurusEntity> geneticProperties) {
        geneticProperties.addSupportedGenes(JSGenetics.OCEAN_COSMETIC);
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(1.5f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.setEggRenderScale(1.4f);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<HadrosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.HERBIVORE);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(5.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(4.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<HadrosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.CRETACEOUS);
        miscProperties.setMaxHeadRotation(25.0f, 30.0f);
        miscProperties.setGuidebookScaling(new float[]{1.5f, 0.6f});
        miscProperties.setGuidebookOffset(new class_241(-1.7f, 0.0f), new class_241(-0.3f, 0.0f));
        miscProperties.setBabyAnimations();
        miscProperties.enableGuidebookPose();
        miscProperties.setExtinct();
        miscProperties.setGuideBookDescription("A duck-billed herbivore from the Late Cretaceous period of North America. Known for its strong hind legs and a flattened, broad snout, Hadrosaurus likely moved in herds and used vocalizations for communication.");
        miscProperties.setGuideBookSource("United States");
        miscProperties.setGuideBookScientificName("Hadrosaurus foulkii");
        miscProperties.setAdvancementTitle("Gentle Hadrosaur");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<HadrosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(VelociraptorEntity.class, TroodonEntity.class, DilophosaurusEntity.class, TyrannosaurusEntity.class, AchillobatorEntity.class, BaryonyxEntity.class, MetriacanthosaurusEntity.class, HerrerasaurusEntity.class, DracovenatorEntity.class, SpinosaurusEntity.class, CeratosaurusEntity.class);
        socialGroupProperties.addHerdTargets(GenericHerdPool.BASE_HERBIVORE_POOL);
        socialGroupProperties.setMaxHerdSize(40);
        socialGroupProperties.setMaxDistanceToPackLeader(3200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(800.0f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<HadrosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(14997942, 8681523);
        itemProperties.setSpawnEggColorsMale(14997942, 10657094);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<HadrosaurusEntity> attributes, EntityBaseProperties<HadrosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setMaxTurnRate(20.0);
        base.setSizeDimorphism(90.0);
        base.setTurnSmoothRate((double)0.7f);
        base.setSizeClass(AnimalSizeClass.MEDIUM);
        base.setRenderScale((double)1.45f);
        base.setLocator(new JSAnimalBaseLocator());
        attributes.setPersistent();
        attributes.setEntityFactory(HadrosaurusEntity::new);
        attributes.setEyeHeight((double)0.9f);
        attributes.setCategory(class_1311.field_6294);
        attributes.setMaxHealth(80.0);
        attributes.setDimensions((double)2.4f, (double)3.2f);
        attributes.setMovementSpeed((double)0.19f);
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier((double)2.2f);
        attributes.setAttackDamage(4.0);
        attributes.setAttackSpeed(1.0);
        attributes.setAttackKnockback(0.0);
        attributes.setFollowRange(64.0);
        attributes.setTrackingRange(64.0);
    }
}

