/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.StegosaurusAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.StegosaurusEntity;
import net.minecraft.class_1311;
import net.minecraft.class_241;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class StegosaurusAnimal
extends AbstractJSAnimal<StegosaurusEntity> {
    public StegosaurusAnimal() {
        super("stegosaurus");
        this.setAnimator(new StegosaurusAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<StegosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(2.5f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.setEggRenderScale(1.4f);
        geneticProperties.addSupportedGenes(JSGenetics.TROPICAL_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<StegosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.HERBIVORE);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(6.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(4.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<StegosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.JURASSIC);
        miscProperties.setMaxHeadRotation(25.0f, 30.0f);
        miscProperties.setGuidebookScaling(new float[]{2.0f, 0.5f});
        miscProperties.setGuidebookOffset(new class_241(-1.0f, 0.0f), new class_241(0.8f, 0.0f));
        miscProperties.setBabyAnimations();
        miscProperties.enableGuidebookPose();
        miscProperties.setExtinct();
        miscProperties.setAttacksCar(true);
        miscProperties.setGuideBookDescription("Stegosaurus stenops was a large, plated herbivore with a small head, spiked tail, and distinctive double row of back plates.");
        miscProperties.setGuideBookSource("North America, Europe");
        miscProperties.setGuideBookScientificName("Stegosaurus stenops");
        miscProperties.setAdvancementTitle("That's how it always starts..");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<StegosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addHerdTargets(StegosaurusEntity.class);
        socialGroupProperties.setMaxHerdSize(20);
        socialGroupProperties.setMaxDistanceToPackLeader(3200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(800.0f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<StegosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.OSTRICH);
        itemProperties.setSpawnEggColors(4803369, 5455652);
        itemProperties.setSpawnEggColorsMale(4803369, 5650459);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<StegosaurusEntity> attributes, EntityBaseProperties<StegosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setMaxTurnRate(14.0);
        base.setSizeDimorphism(90.0);
        base.setSizeClass(AnimalSizeClass.MEDIUM);
        base.setTurnSmoothRate((double)0.3f);
        base.setRenderScale((double)1.85f);
        base.setLocator(new JSAnimalBaseLocator());
        attributes.setPersistent();
        attributes.setEntityFactory(StegosaurusEntity::new);
        attributes.setEyeHeight((double)0.9f);
        attributes.setCategory(class_1311.field_6294);
        attributes.setMaxHealth(90.0);
        attributes.setDimensions(3.0, 4.0);
        attributes.setMovementSpeed((double)0.12f);
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier(3.0);
        attributes.setAttackDamage(17.5);
        attributes.setAttackSpeed(1.0);
        attributes.setAttackKnockback(0.0);
        attributes.setFollowRange(64.0);
        attributes.setTrackingRange(64.0);
    }
}

