/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.obj.task;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAquaticBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSHerdCombatFollowTask;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3419;
import net.minecraft.class_8710;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.animation.TravelersSoundAnimationDefinition;
import travelers.server.packet.obj.TravelersShakeCamera;
import travelers.util.helper.TravelersPacketDistributor;

public class JSAnimalRoarAttack
extends JSHerdCombatFollowTask {
    private final TravelersSoundAnimationDefinition soundAnimDef;
    private boolean isRoaring;
    private int roarTickOffset = 0;
    private int roarLength = 0;
    private boolean hasEnteredShake;
    private boolean scaresNearby;

    public JSAnimalRoarAttack(JSAnimalBase baseAnimal, TravelersSoundAnimationDefinition roarAnim, boolean scaresNearby) {
        super(baseAnimal);
        this.soundAnimDef = roarAnim;
        this.scaresNearby = scaresNearby;
    }

    @Override
    protected void switchState(JSHerdCombatFollowTask.State state, JSHerdCombatFollowTask.State newState) {
        super.switchState(state, newState);
        if (newState == JSHerdCombatFollowTask.State.AGGRESSIVE && !this.animal.method_6510()) {
            this.isRoaring = this.random.nextBoolean();
            if (this.animal.method_5799() && !(this.animal instanceof JSAquaticBase)) {
                this.isRoaring = false;
            }
            if (this.isRoaring && !this.isTargetRunningAway(this.animal.method_5968()) && this.animal.method_6065() == null) {
                this.roarTickOffset = this.soundAnimDef.length() - this.soundAnimDef.offset();
                this.roarLength = this.soundAnimDef.length();
                if (this.roarTickOffset == this.roarLength) {
                    this.animal.method_5783(this.soundAnimDef.event(), 6.0f, 1.0f);
                    if (this.scaresNearby) {
                        for (JSAnimalBase animalBase : this.animal.method_37908().method_8390(JSAnimalBase.class, this.animal.method_5829().method_1014(30.0), e -> e.method_17682() + e.method_17681() < this.animal.method_17682() + this.animal.method_17681())) {
                            animalBase.setFleeTarget((class_1297)this.animal);
                        }
                    }
                }
                this.animal.method_18799(class_243.field_1353);
                this.animal.getNavigationController().stop();
                this.animal.getNavigationController().setFrozen(true);
                this.animal.field_6283 = this.animal.method_36454();
                this.animal.field_6241 = this.animal.method_36454();
                this.animal.field_5982 = this.animal.method_36454();
                this.animal.field_6220 = this.animal.field_6283;
                this.animal.field_6259 = this.animal.field_6241;
            }
            this.animal.method_19540(true);
        }
    }

    @Override
    protected void tickAggresive(class_1309 target) {
        if (this.isRoaring && this.animal.method_6065() == null) {
            --this.roarLength;
            if (this.roarTickOffset == this.roarLength) {
                this.animal.method_37908().method_8396(null, this.animal.method_24515(), this.soundAnimDef.event(), class_3419.field_15251, 2.0f, 1.0f);
            }
            if (this.animal.canShake() && !this.hasEnteredShake && this.soundAnimDef.length() - this.soundAnimDef.secondaryOffset() > this.roarLength) {
                TravelersPacketDistributor.sendToPlayersTrackingEntity((SmartAnimalBase)this.animal, (class_8710)new TravelersShakeCamera(false, this.animal.shakeAmount() * 0.7f, this.roarLength, this.animal.shakeDistance() * 0.7f, this.animal.method_19538().method_46409()));
                this.hasEnteredShake = true;
            }
            this.animal.freezeAnimator();
            if (this.soundAnimDef != null && this.roarLength > 0) {
                this.soundAnimDef.def().sendForEntity((SmartAnimalBase)this.animal);
            }
            if (this.roarLength <= 0) {
                this.isRoaring = false;
                this.animal.getNavigationController().setFrozen(false);
            }
        } else {
            super.tickAggresive(target);
        }
    }
}

