/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.obj.task;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatTaskBase;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class LeapOutOfWaterTask
extends JSCombatTaskBase {
    private State state = State.APPROACH;
    private int timer = 0;
    private int cooldown = 0;
    private int pathCooldown = 0;

    public LeapOutOfWaterTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.getGoals().add(TaskGoal.ATTACK);
    }

    public TaskPriority getPriority() {
        if (this.animal.method_5968() != null && !this.animal.method_5968().method_5777(class_3486.field_15517)) {
            return TaskPriority.HIGH;
        }
        return TaskPriority.LOW;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean shouldRun() {
        if (this.animal.isDead() || this.animal.method_6113() || this.animal.isResting()) {
            return false;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        class_1309 target = this.animal.method_5968();
        if (target == null || target.method_5799()) {
            return false;
        }
        return this.isTargetNearWater(target);
    }

    public void onStart() {
        this.state = State.APPROACH;
        this.timer = 0;
        this.pathCooldown = 0;
        this.animal.getNavigationController().setFrozen(false);
    }

    public boolean canContinueRunning() {
        return this.animal.method_5968() != null;
    }

    public boolean canInterrupt() {
        return false;
    }

    public void tick() {
        class_1309 target = this.animal.method_5968();
        if (target == null) {
            this.abort();
            return;
        }
        class_243 targetPos = target.method_19538();
        double distSq = this.animal.method_5649(target.method_23317(), this.animal.method_23318(), target.method_23321());
        switch (this.state.ordinal()) {
            case 0: {
                double desired = 12.0;
                if (this.pathCooldown-- < 0) {
                    this.animal.getNavigationController().moveTo((class_1297)target);
                    this.pathCooldown = 10;
                }
                if (!(distSq <= desired * desired)) break;
                this.animal.getNavigationController().stop();
                this.animal.getNavigationController().setFrozen(true);
                this.state = State.DIVE;
                this.timer = 0;
                break;
            }
            case 1: {
                ++this.timer;
                if (this.getWaterDepth() < 3) {
                    this.abort();
                    return;
                }
                this.animal.method_18800(this.animal.method_18798().field_1352 * 0.8, -0.25, this.animal.method_18798().field_1350 * 0.8);
                if (this.timer <= 15 && this.getWaterDepthAbove() < 6) break;
                this.state = State.CHARGE;
                this.timer = 0;
                this.animal.setLeaping(true);
                break;
            }
            case 2: {
                ++this.timer;
                class_243 aim = targetPos.method_1031(0.0, (double)target.method_17682() * 0.5, 0.0);
                class_243 dir = aim.method_1020(this.animal.method_19538()).method_1029();
                double accel = Math.min(0.15 + (double)this.timer * 0.02, 0.6);
                class_243 vel = this.animal.method_18798().method_1019(dir.method_1021(accel));
                vel = new class_243(vel.field_1352, Math.min(vel.field_1351, 2.5), vel.field_1350);
                this.animal.method_18799(vel);
                this.rotateToVelocity(vel);
                if (this.animal.method_5858((class_1297)target) < Math.pow((double)this.animal.method_17681() + 2.0, 2.0)) {
                    this.animal.method_6121((class_1297)target);
                    this.abort();
                    return;
                }
                int maxCharge = Math.min(30 + this.getWaterDepthAbove() * 2, 60);
                if (this.timer <= maxCharge) break;
                this.state = State.LAUNCH;
                break;
            }
            case 3: {
                this.animal.setLeaping(true);
                this.rotateToVelocity(this.animal.method_18798());
                if (!this.animal.method_5799() && !this.animal.method_24828()) break;
                this.abort();
            }
        }
    }

    private void rotateToVelocity(class_243 vel) {
        float yaw = (float)(class_3532.method_15349((double)vel.field_1350, (double)vel.field_1352) * 57.29577951308232) - 90.0f;
        float pitch = (float)(-(class_3532.method_15349((double)vel.field_1351, (double)Math.sqrt(vel.field_1352 * vel.field_1352 + vel.field_1350 * vel.field_1350)) * 57.29577951308232));
        this.animal.method_36456(class_3532.method_16439((float)0.2f, (float)this.animal.method_36454(), (float)yaw));
        this.animal.method_36457(class_3532.method_16439((float)0.2f, (float)this.animal.method_36455(), (float)pitch));
        this.animal.field_6283 = this.animal.method_36454();
        this.animal.field_6241 = this.animal.method_36454();
    }

    private void abort() {
        this.animal.setLeaping(false);
        this.animal.getNavigationController().setFrozen(false);
        this.animal.method_19540(false);
        this.animal.method_5980(null);
        this.cooldown = 20;
        this.timer = 0;
        this.state = State.APPROACH;
    }

    private boolean isTargetNearWater(class_1309 target) {
        class_2338 basePos = target.method_24515();
        class_1937 level = target.method_37908();
        int radius = 2;
        int depth = 5;
        for (int y = 0; y <= depth; ++y) {
            class_2338 center = basePos.method_10087(y);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (!level.method_8316(center.method_10069(x, 0, z)).method_15767(class_3486.field_15517)) continue;
                    return true;
                }
            }
        }
        this.animal.blackListAnimal(target);
        this.animal.method_5980(null);
        return false;
    }

    private int getWaterDepth() {
        class_2338 pos = this.animal.method_24515();
        int depth = 0;
        for (int i = 1; i <= 20 && !this.animal.method_37908().method_8316(pos.method_10087(i)).method_15769(); ++i) {
            ++depth;
        }
        return depth;
    }

    private int getWaterDepthAbove() {
        class_2338 pos = this.animal.method_24515();
        int depth = 0;
        for (int i = 1; i <= 20 && !this.animal.method_37908().method_8316(pos.method_10086(i)).method_15769(); ++i) {
            ++depth;
        }
        return depth;
    }

    public void onStop() {
        this.animal.setLeaping(false);
        this.animal.getNavigationController().setFrozen(false);
        this.animal.method_19540(false);
        this.cooldown = 4;
        this.timer = 0;
        this.state = State.APPROACH;
    }

    private static enum State {
        APPROACH,
        DIVE,
        CHARGE,
        LAUNCH;

    }
}

