/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.animals.extant.avian;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.v2.animal.animations.extant.ButterflyAnimations;
import jp.jurassicsaga.server.v2.animal.entity.extant.avian.ButterflyEntity;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1657;
import net.minecraft.class_1959;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import net.minecraft.class_9169;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.locator.ResourceLocator;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class ButterflyAnimal
extends AbstractJSAnimal<ButterflyEntity> {
    public ButterflyAnimal() {
        super("butterfly");
        this.setAnimator(new ButterflyAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<ButterflyEntity> geneticProperties) {
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<ButterflyEntity> metabolismProperties) {
        metabolismProperties.disableSleep();
        metabolismProperties.disableBreeding();
        metabolismProperties.disableFood();
        metabolismProperties.disableWater();
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<ButterflyEntity> miscProperties) {
        miscProperties.setGenderedVariants();
        miscProperties.setEra(Era.NONE);
        miscProperties.setVersion(Versions.VERSION_2);
        miscProperties.addBiomeTarget("overworld", 2, 2, 4, class_1311.field_6294, (class_6862<class_1959>)class_6908.field_37393);
        miscProperties.setSpawnPlacementType(class_9169.field_48745);
        miscProperties.setSpawnHeightMap(class_2902.class_2903.field_13203);
        miscProperties.setSpawnPredicate((class_1317.class_4306<ButterflyEntity>)((class_1317.class_4306)ButterflyEntity::canSpawn));
        miscProperties.setHasEyeLid(false);
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<ButterflyEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(class_1657.class);
        socialGroupProperties.addHerdTargets(ButterflyEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(50.0f);
        socialGroupProperties.setMaxHerdSize(20);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<ButterflyEntity> itemProperties) {
        itemProperties.disableEgg();
        itemProperties.disableMeat();
        itemProperties.setEggtype(EggType.SPIDER);
        itemProperties.setSpawnEggColors(3489351, 10792116);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<ButterflyEntity> attributes, EntityBaseProperties<ButterflyEntity> base) {
        base.setAnimalType(AnimalType.INSECT);
        base.setSizeClass(AnimalSizeClass.SMALL);
        base.setMaxTurnRate(64.0);
        base.setTurnSmoothRate((double)0.8f);
        base.setMaxHeadRotation(90.0, 30.0);
        base.setRenderScale((double)0.4f);
        base.setLocator((ResourceLocator)new ResourceLocator<ButterflyEntity>(this){
            private Cache<String, class_2960> cache = CacheBuilder.newBuilder().maximumSize(5000L).build();

            public class_2960 getModelLocation(ButterflyEntity entity) {
                String name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT);
                String key = "model:" + name;
                try {
                    return (class_2960)this.cache.get((Object)key, () -> JSCommon.createId("geo/animal/v2.0/" + name + "/" + name + ".geo.json"));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }

            public class_2960 getAnimationLocation(ButterflyEntity entity) {
                String name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT);
                String key = "anim:" + name;
                try {
                    return (class_2960)this.cache.get((Object)key, () -> JSCommon.createId("animations/animal/v2.0/" + name + "/" + name + ".animation.json"));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }

            public class_2960 getTextureLocation(ButterflyEntity entity) {
                String name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT);
                String variant = entity.getVariant().getName();
                String key = "tex:" + name + ";var:" + variant;
                try {
                    return (class_2960)this.cache.get((Object)key, () -> JSCommon.createId("textures/geo/animal/v2.0/" + name + "/" + name + "_" + variant + ".png"));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        attributes.setSpawnFar();
        attributes.setEntityFactory(ButterflyEntity::new);
        attributes.setCategory(class_1311.field_6303);
        attributes.setEyeHeight(0.5);
        attributes.setMaxHealth(0.5);
        attributes.setAttackDamage(0.0);
        attributes.setAttackSpeed(3.0);
        attributes.setDimensions(0.5, 0.5);
        attributes.setMovementSpeed((double)0.04f);
        attributes.setRunningSpeedMultiplier((double)1.2f);
        attributes.setFlyingSpeed((double)0.15f);
    }
}

