/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.GenericHerdPool;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.BasicSauropodAnimations;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.AlamosaurusEntity;
import net.minecraft.class_1311;
import net.minecraft.class_241;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class AlamosaurusAnimal
extends AbstractJSAnimal<AlamosaurusEntity> {
    public AlamosaurusAnimal() {
        super("alamosaurus");
        this.setAnimator(new BasicSauropodAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<AlamosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(3.0f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(1.5f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.setEggRenderScale(1.4f);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<AlamosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.HERBIVORE);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(20.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(10.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<AlamosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.CRETACEOUS);
        miscProperties.disableBabyGuidebook();
        miscProperties.setMachineScale(0.7f);
        miscProperties.setMaxHeadRotation(25.0f, 30.0f);
        miscProperties.setGuidebookScaling(new float[]{1.25f, 0.265f});
        miscProperties.setGuidebookOffset(new class_241(-2.0f, 0.0f), new class_241(-2.9f, 0.0f));
        miscProperties.setBabyAnimations();
        miscProperties.enableGuidebookPose();
        miscProperties.setExtinct();
        miscProperties.setVersion(Versions.VERSION_2);
        miscProperties.setGuideBookDescription("Alamosaurus meaning \"Ojo Alamo lizard\" is a genus of titanosaurian sauropod dinosaurs containing a single known species, Alamosaurus sanjuanensis.");
        miscProperties.setGuideBookSource("North America");
        miscProperties.setGuideBookScientificName("Alamosaurus sanjuanensis");
        miscProperties.setAdvancementTitle("Remember the Alamosaurus");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<AlamosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addHerdTargets(GenericHerdPool.BASE_HERBIVORE_POOL);
        socialGroupProperties.setMaxHerdSize(40);
        socialGroupProperties.setMaxDistanceToPackLeader(3200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(800.0f);
        socialGroupProperties.enableNesting();
    }

    @Override
    protected void applyItemProperties(JSItemProperties<AlamosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.OSTRICH);
        itemProperties.setSpawnEggColors(5855822, 8750709);
        itemProperties.setSpawnEggColorsMale(4803132, 8026984);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<AlamosaurusEntity> attributes, EntityBaseProperties<AlamosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setSizeDimorphism(140.0);
        base.setSizeClass(AnimalSizeClass.GIANT);
        base.setMaxTurnRate((double)0.1f);
        base.setRenderScale(3.0);
        base.setLocator(new JSAnimalBaseLocator().setAdultOnly());
        base.setTurnSmoothRate((double)0.1f);
        attributes.setPersistent();
        attributes.setEntityFactory(AlamosaurusEntity::new);
        attributes.setEyeHeight((double)0.95f);
        attributes.setCategory(class_1311.field_6294);
        attributes.setMaxHealth(120.0);
        attributes.setDimensions((double)5.8f, 6.5);
        attributes.setMovementSpeed((double)0.157f);
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier((double)1.4f);
        attributes.setAttackDamage(4.0);
        attributes.setAttackSpeed(1.0);
        attributes.setAttackKnockback(0.0);
        attributes.setFollowRange(64.0);
    }
}

