/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.GenericHerdPool;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.BasicHerbivoreAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.AchillobatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.BaryonyxEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CallovosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.DracovenatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.HerrerasaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MetriacanthosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProceratosaurusEntity;
import net.minecraft.class_1311;
import net.minecraft.class_241;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalType;

public class CallovosaurusAnimal
extends AbstractJSAnimal<CallovosaurusEntity> {
    public CallovosaurusAnimal() {
        super("callovosaurus");
        this.setAnimator(new BasicHerbivoreAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<CallovosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(0.87f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.addSupportedGenes(new JSGene[0]);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<CallovosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.HERBIVORE);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(2.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
        metabolismProperties.setStalkingSpeedMultiplier(0.7f);
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<CallovosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.JURASSIC);
        miscProperties.setMaxHeadRotation(20.0f, 46.0f);
        miscProperties.setBabyAnimations();
        miscProperties.disableBabyGuidebook();
        miscProperties.setGuidebookScaling(new float[]{1.2f, 2.5f});
        miscProperties.setGuidebookOffset(new class_241(-1.0f, 0.0f), new class_241(0.0f, 0.0f));
        miscProperties.setExtinct();
        miscProperties.setVersion(Versions.VERSION_2);
        miscProperties.setGuideBookDescription("Callovosaurus (meaning \"Callovian lizard\") is a genus of iguanodontian dinosaur known from most of a left thigh bone discovered in Middle Jurassic-age rocks of England.");
        miscProperties.setGuideBookSource("England");
        miscProperties.setGuideBookScientificName("Callovosaurus leedsi");
        miscProperties.setAdvancementTitle("Prickly.");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<CallovosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(TyrannosaurusEntity.class, VelociraptorEntity.class, TroodonEntity.class, DilophosaurusEntity.class, MetriacanthosaurusEntity.class, AchillobatorEntity.class, BaryonyxEntity.class, ProceratosaurusEntity.class, DracovenatorEntity.class, HerrerasaurusEntity.class);
        socialGroupProperties.addHerdTargets(GenericHerdPool.BASE_HERBIVORE_POOL_SMALL);
        socialGroupProperties.setMaxDistanceToPackLeader(900.0f);
        socialGroupProperties.setMinDistanceToPackLeader(400.0f);
        socialGroupProperties.setMaxHerdSize(7);
        socialGroupProperties.setNaturalAggression(0.2f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<CallovosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(8871977, 4211219);
        itemProperties.setSpawnEggColorsMale(10242350, 6572580);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<CallovosaurusEntity> attributes, EntityBaseProperties<CallovosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setMaxTurnRate(9.0);
        base.setTurnSmoothRate(0.7);
        base.setSizeDimorphism(25.0);
        base.setRenderScale(0.5);
        base.setLocator(new JSAnimalBaseLocator().setAdultOnly());
        base.setBabyAnimations();
        attributes.setPersistent();
        attributes.setWaterEfficiency((double)0.6f);
        attributes.setEntityFactory(CallovosaurusEntity::new);
        attributes.setEyeHeight((double)0.95f);
        attributes.setCategory(class_1311.field_6294);
        attributes.setMaxHealth(50.0);
        attributes.setDimensions(0.75, (double)1.4f);
        attributes.setTrackingRange(64.0);
        attributes.setMovementSpeed(JSUtils.kmhToSpeed(14.0));
        attributes.setRunningSpeedMultiplier((double)1.9f);
        attributes.setAttackDamage(5.0);
        attributes.setAttackSpeed(2.0);
        attributes.setAttackKnockback(0.5);
        attributes.setFollowRange(64.0);
    }
}

