/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.entity.obj.visitor.VisitorEntity;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic.MesolimulusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DryosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.GallimimusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.HadrosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ParasaurolophusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import jp.jurassicsaga.server.v2.animal.animations.extinct.terrestial.MetriacanthosaurusAnimations;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CallovosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CoelurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.EuoplocephalusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MaiasauraEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MetriacanthosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MicroceratusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.OthnielaEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProceratosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProtoceratopsEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.StyracosaurusEntity;
import jp.jurassicsaga.server.v4.animal.entity.extinct.terrestial.CeratosaurusEntity;
import jp.jurassicsaga.server.v4.animal.entity.extinct.terrestial.SpinosaurusEntity;
import net.minecraft.class_1311;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_241;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalType;

public class MetriacanthosaurusAnimal
extends AbstractJSAnimal<MetriacanthosaurusEntity> {
    public MetriacanthosaurusAnimal() {
        super("metriacanthosaurus");
        this.setAnimator(new MetriacanthosaurusAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<MetriacanthosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(0.425f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.addSupportedGenes(JSGenetics.TAIGA_COSMETIC, JSGenetics.TROPICAL_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<MetriacanthosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.CARNIVORE, Diets.CARNIVORE);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(3.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<MetriacanthosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.JURASSIC);
        miscProperties.setMaxHeadRotation(20.0f, 46.0f);
        miscProperties.setBabyAnimations();
        miscProperties.disableBabyGuidebook();
        miscProperties.setGuidebookScaling(new float[]{1.7f, 0.825f});
        miscProperties.setGuidebookOffset(new class_241(0.5f, 0.0f), new class_241(-0.5f, 0.0f));
        miscProperties.setExtinct();
        miscProperties.setVersion(Versions.VERSION_2);
        miscProperties.setGuideBookDescription("Metriacanthosaurus meaning \"moderately-spined lizard\" is a genus of metriacanthosaurid dinosaur from the Oxford Clay Formation of England, dating to the Late Jurassic period, about 160 million years ago (lower Oxfordian).");
        miscProperties.setGuideBookSource("United Kingdom");
        miscProperties.setGuideBookScientificName("Metriacanthosaurus parkeri");
        miscProperties.setAdvancementTitle("Fragmented Puzzle");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<MetriacanthosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(TyrannosaurusEntity.class, SpinosaurusEntity.class);
        socialGroupProperties.addHuntTargets(class_1657.class, MesolimulusEntity.class, class_1429.class, GoatEntity.class, OstrichEntity.class, GallimimusEntity.class, DryosaurusEntity.class, DilophosaurusEntity.class, HadrosaurusEntity.class, ParasaurolophusEntity.class, VelociraptorEntity.class, VisitorEntity.class, MaiasauraEntity.class, OthnielaEntity.class, MicroceratusEntity.class, StyracosaurusEntity.class, ProceratosaurusEntity.class, EuoplocephalusEntity.class, CoelurusEntity.class, CallovosaurusEntity.class, ProtoceratopsEntity.class, CeratosaurusEntity.class);
        socialGroupProperties.addHerdTargets(MetriacanthosaurusEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(900.0f);
        socialGroupProperties.setMinDistanceToPackLeader(400.0f);
        socialGroupProperties.setMaxHerdSize(3);
        socialGroupProperties.setNaturalAggression(0.2f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<MetriacanthosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(11372869, 6504735);
        itemProperties.setSpawnEggColorsMale(12290890, 9131310);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<MetriacanthosaurusEntity> attributes, EntityBaseProperties<MetriacanthosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setMaxTurnRate(9.0);
        base.setSizeDimorphism(11.0);
        base.setRenderScale((double)1.725f);
        base.setLocator(new JSAnimalBaseLocator().setAdultOnly());
        base.setBabyAnimations();
        base.setTurnSmoothRate(0.5);
        attributes.setPersistent();
        attributes.setEntityFactory(MetriacanthosaurusEntity::new);
        attributes.setEyeHeight((double)0.85f);
        attributes.setCategory(class_1311.field_6294);
        attributes.setMaxHealth(90.0);
        attributes.setDimensions((double)1.6f, 3.0);
        attributes.setTrackingRange(64.0);
        attributes.setMovementSpeed(JSUtils.kmhToSpeed(15.0));
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier((double)1.8f);
        attributes.setAttackDamage(20.0);
        attributes.setAttackSpeed(4.0);
        attributes.setAttackKnockback(1.0);
        attributes.setFollowRange(64.0);
    }
}

