/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGroundNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSOpenDoorTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatLeapTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSHerdCombatFollowTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSRevengeOrRunTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindFoodTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindWaterTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc.JSRestTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.base.entity.obj.other.IJSLeapingEntity;
import jp.jurassicsaga.server.v2.sound.JSV2Sounds;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class AchillobatorEntity
extends JSAnimalBase
implements IJSLeapingEntity {
    private int minLeapTicks = 0;

    public AchillobatorEntity(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSOpenDoorTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 50));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(16, 9));
        controller.registerTask((TravelerTaskBase)new JSFindFoodTask(this));
        controller.registerTask((TravelerTaskBase)new JSFindWaterTask(this));
        controller.registerTask((TravelerTaskBase)new JSRevengeOrRunTask(this));
        controller.registerTask((TravelerTaskBase)new JSHerdCombatFollowTask(this).shouldCallout(true, 40).stalk());
        controller.registerTask((TravelerTaskBase)new JSCombatLeapTask(this, 0.5f));
        controller.registerTask((TravelerTaskBase)new JSRestTask(this));
        combatTargeting.registerTask((TravelerTaskBase)new JSTargetTask(this, true));
    }

    protected float method_5867() {
        float speed = this.method_6029();
        return this.field_5994 + 5.7f * speed;
    }

    @Override
    protected int attackAnimLength() {
        return 20;
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (this.isLeaping()) {
            if (this.minLeapTicks > 0) {
                --this.minLeapTicks;
            } else if (this.method_24828() || this.method_5799()) {
                this.setLeaping(false);
            }
        }
    }

    @Override
    public double minDistance() {
        return 90.0;
    }

    @Override
    public double maxDistance() {
        return 100.0;
    }

    public double jumpHeight() {
        if (this.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT && !this.method_5799()) {
            return 5.0;
        }
        return 1.0;
    }

    @Override
    public void onLeap() {
        if (this.getAttackSound() != null) {
            this.method_5783(this.getAttackSound(), this.method_6107(), 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.4f);
        }
        this.setLeaping(true);
        this.minLeapTicks = 1;
    }

    @Override
    protected TravelersPathNavigation createNavigationController(class_1937 level) {
        JSGroundNavigation nav = new JSGroundNavigation(this, level);
        nav.setCanOpenDoors(true);
        nav.setCanPassDoors(true);
        return nav;
    }

    @Override
    @Nullable
    protected class_3414 getAttackSound() {
        return (class_3414)JSV2Sounds.ACHILLOBATOR_ATTACK.get();
    }

    @Nullable
    protected class_3414 method_5994() {
        if (this.method_5968() != null) {
            return (class_3414)JSV2Sounds.ACHILLOBATOR_THREAT.get();
        }
        return (class_3414)JSV2Sounds.ACHILLOBATOR_LIVING.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)JSV2Sounds.ACHILLOBATOR_DEATH.get();
    }

    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return (class_3414)JSV2Sounds.ACHILLOBATOR_HURT.get();
    }

    @Override
    @Nullable
    protected class_3414 getCallSound() {
        return (class_3414)JSV2Sounds.ACHILLOBATOR_BARK.get();
    }
}

