/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.entity.obj;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3532;
import travelers.server.animal.entity.task.TaskGoal;

public class LudoPickupTask
extends JSTaskBase {
    private final JSAvianBase avian;
    private State state = State.APPROACH;
    private class_1309 target;
    private static final double PICKUP_RANGE = 1.6;
    private static final double MAX_HORIZONTAL_SPEED = 0.7;
    private static final double MAX_CLIMB_SPEED = 0.6;
    private static final double ACCEL = 0.08;
    private static final double DRAG = 0.96;
    private static final double APPROACH_HEIGHT_OFFSET = 2.2;
    private static final double RAISE_HEIGHT = 20.0;
    private static final double GROUND_CLEARANCE = 2.5;
    private double dropY;

    public LudoPickupTask(JSAvianBase animal) {
        super(animal);
        this.avian = animal;
        this.getGoals().add(TaskGoal.ATTACK);
    }

    public boolean shouldRun() {
        if (this.checkCooldown-- > 0) {
            return false;
        }
        if (this.animal.method_6113() || this.animal.isDead() || this.animal.getModules().getMetabolismModule().isHungry() || this.animal.getModules().getMetabolismModule().isThirsty()) {
            return false;
        }
        class_1309 t = this.animal.method_5968();
        if (!this.isBiggerThanTarget(t)) {
            return false;
        }
        if (!t.method_5805() || t.method_5765()) {
            return false;
        }
        this.target = t;
        return true;
    }

    private boolean isBiggerThanTarget(class_1309 target) {
        double theirScore;
        if (target == null) {
            return false;
        }
        if (target instanceof JSAvianBase) {
            return false;
        }
        double thisScore = this.animal.method_17681() + this.animal.method_17682();
        return thisScore > (theirScore = (double)(target.method_17681() + target.method_17682())) * 1.5;
    }

    public boolean canContinueRunning() {
        return this.state != State.DONE && !this.animal.isDead();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void onStart() {
        this.state = State.APPROACH;
        this.avian.setFlying(true);
        this.avian.setFlapping(true);
        this.avian.lock();
        this.animal.method_18799(this.animal.method_18798().method_1031(0.0, 0.25, 0.0));
    }

    public void tick() {
        if (this.animal.method_37908().field_9236) {
            return;
        }
        this.avian.setFlapping(true);
        switch (this.state.ordinal()) {
            case 0: {
                this.approach();
                break;
            }
            case 1: {
                this.ascend();
            }
        }
    }

    private void approach() {
        if (this.target == null || !this.target.method_5805()) {
            this.state = State.DONE;
            return;
        }
        class_243 currentVel = this.animal.method_18798();
        double safeY = this.getSafeFlightY();
        double desiredY = Math.max(this.target.method_23318() + 2.2, safeY);
        class_243 desiredPos = new class_243(this.target.method_23317(), desiredY, this.target.method_23321());
        class_243 toTarget = desiredPos.method_1020(this.animal.method_19538());
        class_243 horizDir = new class_243(toTarget.field_1352, 0.0, toTarget.field_1350);
        class_243 desiredHoriz = horizDir.method_1027() > 0.001 ? horizDir.method_1029().method_1021(0.7) : class_243.field_1353;
        double verticalIntent = class_3532.method_15350((double)(toTarget.field_1351 * 0.08), (double)-0.15, (double)0.25);
        class_243 desiredVel = new class_243(desiredHoriz.field_1352, verticalIntent, desiredHoriz.field_1350);
        class_243 newVel = currentVel.method_35590(desiredVel, 0.08).method_1021(0.96);
        this.animal.method_18799(newVel);
        this.animal.method_5951((class_1297)this.target, 30.0f, 30.0f);
        double dx = this.animal.method_23317() - this.target.method_23317();
        double dz = this.animal.method_23321() - this.target.method_23321();
        if (this.animal.method_23318() > this.target.method_23318() + 1.5 && this.animal.method_23318() > safeY && dx * dx + dz * dz <= 2.5600000000000005) {
            this.dropY = this.animal.method_23318() + 20.0;
            this.target.method_5873((class_1297)this.animal, true);
            this.target.field_6017 = 0.0f;
            this.state = State.ASCEND;
        }
    }

    private void ascend() {
        class_243 currentVel = this.animal.method_18798();
        class_243 horiz = new class_243(currentVel.field_1352, 0.0, currentVel.field_1350);
        if (horiz.method_1027() < 0.002) {
            class_243 forward = class_243.method_1030((float)0.0f, (float)this.animal.method_36454());
            horiz = new class_243(forward.field_1352, 0.0, forward.field_1350).method_1021(0.2);
        }
        horiz = horiz.method_1029().method_1021(0.63);
        double heightRemaining = this.dropY - this.animal.method_23318();
        double climb = class_3532.method_15350((double)(0.08 + heightRemaining * 0.02), (double)0.08, (double)0.6);
        class_243 desiredVel = new class_243(horiz.field_1352, climb, horiz.field_1350);
        class_243 newVel = currentVel.method_35590(desiredVel, 0.08).method_1021(0.96);
        this.animal.method_18799(newVel);
        if (this.animal.method_23318() >= this.dropY) {
            for (class_1297 passenger : this.animal.method_5685()) {
                passenger.method_5848();
                passenger.method_18800(0.0, -0.9, 0.0);
            }
            this.state = State.DONE;
        }
    }

    private double getSafeFlightY() {
        class_2338 pos = this.animal.method_24515();
        int top = this.animal.method_37908().method_8598(class_2902.class_2903.field_13203, pos).method_10264();
        return (double)top + 2.5;
    }

    public void onStop() {
        for (class_1297 passenger : this.animal.method_5685()) {
            passenger.method_5848();
        }
        this.checkCooldown = 20;
        this.state = State.APPROACH;
        this.avian.unlock();
        this.target = null;
    }

    private static enum State {
        APPROACH,
        ASCEND,
        DONE;

    }
}

