/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.block.obj;

import com.google.common.collect.Lists;
import java.util.List;
import jp.jurassicsaga.server.v2.block.obj.TourRailBlock;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import org.jetbrains.annotations.Nullable;

public class JSRailState {
    private final class_1937 level;
    private final class_2338 pos;
    private final TourRailBlock block;
    private class_2680 state;
    private final boolean isStraight;
    private final List<class_2338> connections = Lists.newArrayList();

    public JSRailState(class_1937 level, class_2338 pos, class_2680 state) {
        this.level = level;
        this.pos = pos;
        this.state = state;
        this.block = (TourRailBlock)state.method_26204();
        class_2768 railShape = (class_2768)state.method_11654(this.block.getShapeProperty());
        this.isStraight = this.block.isStraight();
        this.updateConnections(railShape);
    }

    private void updateConnections(class_2768 shape) {
        this.connections.clear();
        switch (shape) {
            case field_12665: {
                this.connections.add(this.pos.method_10095());
                this.connections.add(this.pos.method_10072());
                break;
            }
            case field_12674: {
                this.connections.add(this.pos.method_10067());
                this.connections.add(this.pos.method_10078());
                break;
            }
            case field_12667: {
                this.connections.add(this.pos.method_10067());
                this.connections.add(this.pos.method_10078().method_10084());
                break;
            }
            case field_12666: {
                this.connections.add(this.pos.method_10067().method_10084());
                this.connections.add(this.pos.method_10078());
                break;
            }
            case field_12670: {
                this.connections.add(this.pos.method_10095().method_10084());
                this.connections.add(this.pos.method_10072());
                break;
            }
            case field_12668: {
                this.connections.add(this.pos.method_10095());
                this.connections.add(this.pos.method_10072().method_10084());
                break;
            }
            case field_12664: {
                this.connections.add(this.pos.method_10078());
                this.connections.add(this.pos.method_10072());
                break;
            }
            case field_12671: {
                this.connections.add(this.pos.method_10067());
                this.connections.add(this.pos.method_10072());
                break;
            }
            case field_12672: {
                this.connections.add(this.pos.method_10067());
                this.connections.add(this.pos.method_10095());
                break;
            }
            case field_12663: {
                this.connections.add(this.pos.method_10078());
                this.connections.add(this.pos.method_10095());
            }
        }
    }

    private void removeSoftConnections() {
        for (int i = 0; i < this.connections.size(); ++i) {
            JSRailState JSRailState2 = this.getRail(this.connections.get(i));
            if (JSRailState2 != null && JSRailState2.connectsTo(this)) {
                this.connections.set(i, JSRailState2.pos);
                continue;
            }
            this.connections.remove(i--);
        }
    }

    private boolean hasRail(class_2338 pos) {
        return TourRailBlock.isRail(this.level, pos) || TourRailBlock.isRail(this.level, pos.method_10084()) || TourRailBlock.isRail(this.level, pos.method_10074());
    }

    @Nullable
    private JSRailState getRail(class_2338 pos) {
        class_2680 blockState = this.level.method_8320(pos);
        if (TourRailBlock.isRail(blockState)) {
            return new JSRailState(this.level, pos, blockState);
        }
        class_2338 blockPos = pos.method_10084();
        blockState = this.level.method_8320(blockPos);
        if (TourRailBlock.isRail(blockState)) {
            return new JSRailState(this.level, blockPos, blockState);
        }
        blockPos = pos.method_10074();
        blockState = this.level.method_8320(blockPos);
        return TourRailBlock.isRail(blockState) ? new JSRailState(this.level, blockPos, blockState) : null;
    }

    private boolean connectsTo(JSRailState state) {
        return this.hasConnection(state.pos);
    }

    private boolean hasConnection(class_2338 pos) {
        for (class_2338 connection : this.connections) {
            class_2338 blockPos = connection;
            if (blockPos.method_10263() != pos.method_10263() || blockPos.method_10260() != pos.method_10260()) continue;
            return true;
        }
        return false;
    }

    protected int countPotentialConnections() {
        int i = 0;
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            if (!this.hasRail(this.pos.method_10093(direction))) continue;
            ++i;
        }
        return i;
    }

    private boolean canConnectTo(JSRailState state) {
        return this.connectsTo(state) || this.connections.size() != 2;
    }

    private void connectTo(JSRailState state) {
        this.connections.add(state.pos);
        class_2338 blockPos = this.pos.method_10095();
        class_2338 blockPos2 = this.pos.method_10072();
        class_2338 blockPos3 = this.pos.method_10067();
        class_2338 blockPos4 = this.pos.method_10078();
        boolean bl = this.hasConnection(blockPos);
        boolean bl2 = this.hasConnection(blockPos2);
        boolean bl3 = this.hasConnection(blockPos3);
        boolean bl4 = this.hasConnection(blockPos4);
        class_2768 railShape = null;
        if (bl || bl2) {
            railShape = class_2768.field_12665;
        }
        if (bl3 || bl4) {
            railShape = class_2768.field_12674;
        }
        if (!this.isStraight) {
            if (bl2 && bl4 && !bl && !bl3) {
                railShape = class_2768.field_12664;
            }
            if (bl2 && bl3 && !bl && !bl4) {
                railShape = class_2768.field_12671;
            }
            if (bl && bl3 && !bl2 && !bl4) {
                railShape = class_2768.field_12672;
            }
            if (bl && bl4 && !bl2 && !bl3) {
                railShape = class_2768.field_12663;
            }
        }
        if (railShape == class_2768.field_12665) {
            if (TourRailBlock.isRail(this.level, blockPos.method_10084())) {
                railShape = class_2768.field_12670;
            }
            if (TourRailBlock.isRail(this.level, blockPos2.method_10084())) {
                railShape = class_2768.field_12668;
            }
        }
        if (railShape == class_2768.field_12674) {
            if (TourRailBlock.isRail(this.level, blockPos4.method_10084())) {
                railShape = class_2768.field_12667;
            }
            if (TourRailBlock.isRail(this.level, blockPos3.method_10084())) {
                railShape = class_2768.field_12666;
            }
        }
        if (railShape == null) {
            railShape = class_2768.field_12665;
        }
        this.state = (class_2680)this.state.method_11657(this.block.getShapeProperty(), (Comparable)railShape);
        this.level.method_8652(this.pos, this.state, 3);
    }

    private boolean hasNeighborRail(class_2338 pos) {
        JSRailState JSRailState2 = this.getRail(pos);
        if (JSRailState2 == null) {
            return false;
        }
        JSRailState2.removeSoftConnections();
        return JSRailState2.canConnectTo(this);
    }

    public JSRailState place(boolean powered, boolean alwaysPlace, class_2768 shape) {
        boolean bl10;
        boolean bl6;
        class_2338 blockPos = this.pos.method_10095();
        class_2338 blockPos2 = this.pos.method_10072();
        class_2338 blockPos3 = this.pos.method_10067();
        class_2338 blockPos4 = this.pos.method_10078();
        boolean bl = this.hasNeighborRail(blockPos);
        boolean bl2 = this.hasNeighborRail(blockPos2);
        boolean bl3 = this.hasNeighborRail(blockPos3);
        boolean bl4 = this.hasNeighborRail(blockPos4);
        class_2768 railShape = null;
        boolean bl5 = bl || bl2;
        boolean bl7 = bl6 = bl3 || bl4;
        if (bl5 && !bl6) {
            railShape = class_2768.field_12665;
        }
        if (bl6 && !bl5) {
            railShape = class_2768.field_12674;
        }
        boolean bl72 = bl2 && bl4;
        boolean bl8 = bl2 && bl3;
        boolean bl9 = bl && bl4;
        boolean bl11 = bl10 = bl && bl3;
        if (!this.isStraight) {
            if (bl72 && !bl && !bl3) {
                railShape = class_2768.field_12664;
            }
            if (bl8 && !bl && !bl4) {
                railShape = class_2768.field_12671;
            }
            if (bl10 && !bl2 && !bl4) {
                railShape = class_2768.field_12672;
            }
            if (bl9 && !bl2 && !bl3) {
                railShape = class_2768.field_12663;
            }
        }
        if (railShape == null) {
            if (bl5 && bl6) {
                railShape = shape;
            } else if (bl5) {
                railShape = class_2768.field_12665;
            } else if (bl6) {
                railShape = class_2768.field_12674;
            }
            if (!this.isStraight) {
                if (powered) {
                    if (bl72) {
                        railShape = class_2768.field_12664;
                    }
                    if (bl8) {
                        railShape = class_2768.field_12671;
                    }
                    if (bl9) {
                        railShape = class_2768.field_12663;
                    }
                    if (bl10) {
                        railShape = class_2768.field_12672;
                    }
                } else {
                    if (bl10) {
                        railShape = class_2768.field_12672;
                    }
                    if (bl9) {
                        railShape = class_2768.field_12663;
                    }
                    if (bl8) {
                        railShape = class_2768.field_12671;
                    }
                    if (bl72) {
                        railShape = class_2768.field_12664;
                    }
                }
            }
        }
        if (railShape == class_2768.field_12665) {
            if (TourRailBlock.isRail(this.level, blockPos.method_10084())) {
                railShape = class_2768.field_12670;
            }
            if (TourRailBlock.isRail(this.level, blockPos2.method_10084())) {
                railShape = class_2768.field_12668;
            }
        }
        if (railShape == class_2768.field_12674) {
            if (TourRailBlock.isRail(this.level, blockPos4.method_10084())) {
                railShape = class_2768.field_12667;
            }
            if (TourRailBlock.isRail(this.level, blockPos3.method_10084())) {
                railShape = class_2768.field_12666;
            }
        }
        if (railShape == null) {
            railShape = shape;
        }
        this.updateConnections(railShape);
        this.state = (class_2680)this.state.method_11657(this.block.getShapeProperty(), (Comparable)railShape);
        if (alwaysPlace || this.level.method_8320(this.pos) != this.state) {
            this.level.method_8652(this.pos, this.state, 3);
            for (class_2338 connection : this.connections) {
                JSRailState JSRailState2 = this.getRail(connection);
                if (JSRailState2 == null) continue;
                JSRailState2.removeSoftConnections();
                if (!JSRailState2.canConnectTo(this)) continue;
                JSRailState2.connectTo(this);
            }
        }
        return this;
    }

    public class_2680 getState() {
        return this.state;
    }

    public List<class_2338> getConnections() {
        return this.connections;
    }
}

