/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v4.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.entity.obj.visitor.VisitorEntity;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic.MesolimulusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DryosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.GallimimusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.HadrosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ParasaurolophusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CallovosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CoelurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.EuoplocephalusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MaiasauraEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MicroceratusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.OthnielaEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProceratosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProtoceratopsEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.StyracosaurusEntity;
import jp.jurassicsaga.server.v4.animal.animations.extinct.terrestial.CeratosaurusAnimations;
import jp.jurassicsaga.server.v4.animal.entity.extinct.terrestial.CeratosaurusEntity;
import jp.jurassicsaga.server.v4.animal.entity.extinct.terrestial.SpinosaurusEntity;
import net.minecraft.class_1311;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_241;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalType;

public class CeratosaurusAnimal
extends AbstractJSAnimal<CeratosaurusEntity> {
    public CeratosaurusAnimal() {
        super("ceratosaurus");
        this.setAnimator(new CeratosaurusAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<CeratosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(2.25f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.setEggRenderScale(1.4f);
        geneticProperties.addSupportedGenes(JSGenetics.TROPICAL_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<CeratosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.CARNIVORE, Diets.CARNIVORE);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(7.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(5.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<CeratosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.JURASSIC);
        miscProperties.setMaxHeadRotation(25.0f, 30.0f);
        miscProperties.setGuidebookScaling(new float[]{2.4f, 0.8f});
        miscProperties.setGuidebookOffset(new class_241(-1.2f, 0.0f), new class_241(0.0f, 0.0f));
        miscProperties.setBabyAnimations();
        miscProperties.disableBabyGuidebook();
        miscProperties.enableGuidebookPose();
        miscProperties.setExtinct();
        miscProperties.setVersion(Versions.VERSION_4);
        miscProperties.setGuideBookDescription("Ceratosaurus is a genus of carnivorous theropod dinosaur that lived during the Late Jurassic period in North America and Europe.");
        miscProperties.setGuideBookSource("North America, Europe");
        miscProperties.setGuideBookScientificName("Ceratosaurus dentisulcatus");
        miscProperties.setAdvancementTitle("Nash's Resting Place");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<CeratosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(TyrannosaurusEntity.class, SpinosaurusEntity.class);
        socialGroupProperties.addHuntTargets(class_1657.class, MesolimulusEntity.class, class_1429.class, GoatEntity.class, OstrichEntity.class, GallimimusEntity.class, DryosaurusEntity.class, DilophosaurusEntity.class, HadrosaurusEntity.class, ParasaurolophusEntity.class, VelociraptorEntity.class, VisitorEntity.class, MaiasauraEntity.class, OthnielaEntity.class, MicroceratusEntity.class, StyracosaurusEntity.class, ProceratosaurusEntity.class, EuoplocephalusEntity.class, CoelurusEntity.class, CallovosaurusEntity.class, ProtoceratopsEntity.class);
        socialGroupProperties.addHerdTargets(CeratosaurusEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(900.0f);
        socialGroupProperties.setMinDistanceToPackLeader(400.0f);
        socialGroupProperties.setMaxHerdSize(3);
        socialGroupProperties.setNaturalAggression(0.2f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<CeratosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(7631192, 5327166);
        itemProperties.setSpawnEggColorsMale(9326143, 5191731);
        itemProperties.setHasFossil(false);
        itemProperties.disableMeat();
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<CeratosaurusEntity> attributes, EntityBaseProperties<CeratosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setMaxTurnRate(9.0);
        base.setSizeDimorphism(70.0);
        base.setRenderScale((double)1.65f);
        base.setLocator(new JSAnimalBaseLocator().setAdultOnly());
        base.setBabyAnimations();
        base.setTurnSmoothRate((double)0.4f);
        attributes.setPersistent();
        attributes.setEntityFactory(CeratosaurusEntity::new);
        attributes.setEyeHeight((double)0.85f);
        attributes.setCategory(class_1311.field_6294);
        attributes.setMaxHealth(90.0);
        attributes.setDimensions((double)2.1f, 3.5);
        attributes.setTrackingRange(64.0);
        attributes.setMovementSpeed(JSUtils.kmhToSpeed(18.0));
        attributes.setRunningSpeedMultiplier(2.25);
        attributes.setAttackDamage(20.0);
        attributes.setAttackSpeed(4.0);
        attributes.setAttackKnockback(1.0);
        attributes.setFollowRange(64.0);
    }
}

