/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v4.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.GenericHerdPool;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.BasicHerbivoreAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.AchillobatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.BaryonyxEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.DracovenatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.HerrerasaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MetriacanthosaurusEntity;
import jp.jurassicsaga.server.v4.animal.entity.extinct.terrestial.CeratosaurusEntity;
import jp.jurassicsaga.server.v4.animal.entity.extinct.terrestial.MussaurusEntity;
import jp.jurassicsaga.server.v4.animal.entity.extinct.terrestial.SpinosaurusEntity;
import net.minecraft.class_1311;
import net.minecraft.class_241;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalType;

public class MussaurusAnimal
extends AbstractJSAnimal<MussaurusEntity> {
    public MussaurusAnimal() {
        super("mussaurus");
        this.setAnimator(new BasicHerbivoreAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<MussaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(2.25f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.setEggRenderScale(1.4f);
        geneticProperties.addSupportedGenes(new JSGene[0]);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<MussaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.HERBIVORE);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(6.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(4.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<MussaurusEntity> miscProperties) {
        miscProperties.setEra(Era.JURASSIC);
        miscProperties.setMaxHeadRotation(25.0f, 30.0f);
        miscProperties.setGuidebookScaling(new float[]{2.4f, 1.0f});
        miscProperties.setGuidebookOffset(new class_241(-1.2f, 0.0f), new class_241(0.0f, 0.0f));
        miscProperties.setBabyAnimations();
        miscProperties.disableBabyGuidebook();
        miscProperties.enableGuidebookPose();
        miscProperties.setExtinct();
        miscProperties.setVersion(Versions.VERSION_4);
        miscProperties.setGuideBookDescription("Mussaurus is a genus of herbivorous sauropodomorph dinosaur that lived in southern Argentina during the Sinemurian stage of the Early Jurassic.");
        miscProperties.setGuideBookSource("North America");
        miscProperties.setGuideBookScientificName("Mussaurus patagonicus");
        miscProperties.setAdvancementTitle("Little Little Mussaurus");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<MussaurusEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(VelociraptorEntity.class, TroodonEntity.class, DilophosaurusEntity.class, TyrannosaurusEntity.class, AchillobatorEntity.class, BaryonyxEntity.class, MetriacanthosaurusEntity.class, HerrerasaurusEntity.class, DracovenatorEntity.class, SpinosaurusEntity.class, CeratosaurusEntity.class);
        socialGroupProperties.addHerdTargets(GenericHerdPool.BASE_HERBIVORE_POOL_SMALL);
        socialGroupProperties.setMaxHerdSize(40);
        socialGroupProperties.setMaxDistanceToPackLeader(3200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(800.0f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<MussaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(11180909, 3556647);
        itemProperties.setSpawnEggColorsMale(7506820, 5339491);
        itemProperties.disableMeat();
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<MussaurusEntity> attributes, EntityBaseProperties<MussaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setMaxTurnRate(9.0);
        base.setSizeDimorphism(50.0);
        base.setRenderScale((double)0.6567f);
        base.setLocator(new JSAnimalBaseLocator().setAdultOnly());
        base.setBabyAnimations();
        base.setTurnSmoothRate((double)0.4f);
        attributes.setPersistent();
        attributes.setEntityFactory(MussaurusEntity::new);
        attributes.setEyeHeight((double)0.95f);
        attributes.setCategory(class_1311.field_6294);
        attributes.setMaxHealth(90.0);
        attributes.setDimensions((double)2.1f, 3.5);
        attributes.setTrackingRange(64.0);
        attributes.setMovementSpeed(JSUtils.kmhToSpeed(18.0));
        attributes.setWaterEfficiency(1.0);
        attributes.setSwimmingSpeedMultiplier((double)1.3f);
        attributes.setRunningSpeedMultiplier(2.25);
        attributes.setAttackDamage(20.0);
        attributes.setAttackSpeed(4.0);
        attributes.setAttackKnockback(1.0);
        attributes.setFollowRange(64.0);
    }
}

