/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v4.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.entity.obj.visitor.VisitorEntity;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.entity.extant.AlligatorEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.MosquitoEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.ReedFrogEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.avian.CearadactylusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.avian.MeganeuraEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ApatosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DryosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.GallimimusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.HadrosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ParasaurolophusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.StegosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TriceratopsEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.avian.LudodactylusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.AchillobatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CoelurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.EuoplocephalusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MaiasauraEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MetriacanthosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MicroceratusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.OthnielaEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProceratosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProtoceratopsEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.StyracosaurusEntity;
import jp.jurassicsaga.server.v4.animal.animations.extinct.terrestial.SpinosaurusAnimations;
import jp.jurassicsaga.server.v4.animal.entity.extinct.terrestial.CeratosaurusEntity;
import jp.jurassicsaga.server.v4.animal.entity.extinct.terrestial.CorythosaurusEntity;
import jp.jurassicsaga.server.v4.animal.entity.extinct.terrestial.SpinosaurusEntity;
import net.minecraft.class_1311;
import net.minecraft.class_1429;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_241;
import net.minecraft.class_3988;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalType;

public class SpinosaurusAnimal
extends AbstractJSAnimal<SpinosaurusEntity> {
    public SpinosaurusAnimal() {
        super("spinosaurus");
        this.setAnimator(new SpinosaurusAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<SpinosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(2.25f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.setEggRenderScale(1.4f);
        geneticProperties.addSupportedGenes(JSGenetics.LEGACY_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<SpinosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.CARNIVORE, Diets.CARNIVORE);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(7.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(5.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<SpinosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.CRETACEOUS);
        miscProperties.setMaxHeadRotation(25.0f, 30.0f);
        miscProperties.setGuidebookScaling(new float[]{2.4f, 0.42f});
        miscProperties.setGuidebookOffset(new class_241(-1.2f, 0.0f), new class_241(-1.0f, 0.0f));
        miscProperties.setBabyAnimations();
        miscProperties.disableBabyGuidebook();
        miscProperties.enableGuidebookPose();
        miscProperties.setExtinct();
        miscProperties.setVersion(Versions.VERSION_4);
        miscProperties.setGuideBookDescription("Spinosaurus is a genus of large spinosaurid theropod dinosaurs that lived in what now is North Africa during the Cenomanian stage of the Late Cretaceous period");
        miscProperties.setGuideBookSource("North Africa");
        miscProperties.setGuideBookScientificName("Spinosaurus aegyptiacus");
        miscProperties.setAdvancementTitle("I don't remember that on the list");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<SpinosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addHuntTargets(class_1657.class, class_3988.class, class_1429.class, class_1588.class, VisitorEntity.class, GoatEntity.class, DryosaurusEntity.class, OstrichEntity.class, ApatosaurusEntity.class, TriceratopsEntity.class, VelociraptorEntity.class, DilophosaurusEntity.class, DilophosaurusEntity.class, GallimimusEntity.class, HadrosaurusEntity.class, ParasaurolophusEntity.class, AlligatorEntity.class, CearadactylusEntity.class, MeganeuraEntity.class, MosquitoEntity.class, ReedFrogEntity.class, StegosaurusEntity.class, TroodonEntity.class, TyrannosaurusEntity.class, AchillobatorEntity.class, MetriacanthosaurusEntity.class, MicroceratusEntity.class, StyracosaurusEntity.class, EuoplocephalusEntity.class, LudodactylusEntity.class, ProceratosaurusEntity.class, OthnielaEntity.class, MaiasauraEntity.class, CoelurusEntity.class, ProtoceratopsEntity.class, CorythosaurusEntity.class, CeratosaurusEntity.class);
        socialGroupProperties.addHerdTargets(TyrannosaurusEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(900.0f);
        socialGroupProperties.setMinDistanceToPackLeader(400.0f);
        socialGroupProperties.setMaxHerdSize(3);
        socialGroupProperties.setNaturalAggression(0.5f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<SpinosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.OSTRICH);
        itemProperties.setSpawnEggColors(9061941, 10589587);
        itemProperties.setSpawnEggColorsMale(8076599, 10589587);
        itemProperties.disableMeat();
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<SpinosaurusEntity> attributes, EntityBaseProperties<SpinosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setMaxTurnRate(9.0);
        base.setSizeDimorphism(90.0);
        base.setRenderScale((double)2.35f);
        base.setLocator(new JSAnimalBaseLocator().setAdultOnly());
        base.setBabyAnimations();
        base.setTurnSmoothRate((double)0.4f);
        attributes.setPersistent();
        attributes.setEntityFactory(SpinosaurusEntity::new);
        attributes.setEyeHeight((double)0.95f);
        attributes.setCategory(class_1311.field_6294);
        attributes.setMaxHealth(90.0);
        attributes.setDimensions((double)3.15f, 6.5);
        attributes.setTrackingRange(64.0);
        attributes.setMovementSpeed(JSUtils.kmhToSpeed(18.0));
        attributes.setWaterEfficiency(1.0);
        attributes.setSwimmingSpeedMultiplier((double)1.3f);
        attributes.setRunningSpeedMultiplier(2.25);
        attributes.setAttackDamage(20.0);
        attributes.setAttackSpeed(4.0);
        attributes.setAttackKnockback(1.0);
        attributes.setFollowRange(64.0);
    }
}

