/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v5.animal.animals.extinct.terrestial;

import java.util.Locale;
import java.util.concurrent.ExecutionException;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.entity.extant.AlligatorEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.MosquitoEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.ReedFrogEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.avian.CearadactylusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.avian.MeganeuraEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ApatosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DryosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.GallimimusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.HadrosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ParasaurolophusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.StegosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TriceratopsEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.avian.LudodactylusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.AchillobatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CoelurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.DracovenatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.EuoplocephalusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.HerrerasaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MaiasauraEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MetriacanthosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MicroceratusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.OthnielaEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProceratosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProtoceratopsEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.StyracosaurusEntity;
import jp.jurassicsaga.server.v4.animal.entity.extinct.terrestial.CeratosaurusEntity;
import jp.jurassicsaga.server.v4.animal.entity.extinct.terrestial.CorythosaurusEntity;
import jp.jurassicsaga.server.v4.animal.entity.extinct.terrestial.SpinosaurusEntity;
import jp.jurassicsaga.server.v5.animal.animations.extinct.terrestial.AlbertosaurusAnimations;
import jp.jurassicsaga.server.v5.animal.entity.extinct.terrestial.AlbertosaurusEntity;
import net.minecraft.class_1311;
import net.minecraft.class_1429;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3988;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.locator.ResourceLocator;
import travelers.server.animal.obj.misc.AnimalType;

public class AlbertosaurusAnimal
extends AbstractJSAnimal<AlbertosaurusEntity> {
    public AlbertosaurusAnimal() {
        super("albertosaurus");
        this.setAnimator(new AlbertosaurusAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<AlbertosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(2.5f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.addSupportedGenes(JSGenetics.PASTURE_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<AlbertosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.CARNIVORE, Diets.CARNIVORE);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(6.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(3.0f));
        metabolismProperties.setStalkingSpeedMultiplier(0.7f);
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<AlbertosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.CRETACEOUS);
        miscProperties.setMaxHeadRotation(20.0f, 46.0f);
        miscProperties.setBabyAnimations();
        miscProperties.setGuidebookScaling(new float[]{1.5f, 0.535f});
        miscProperties.setGuidebookOffset(new class_241(0.7f, 0.0f), new class_241(-1.0f, 0.0f));
        miscProperties.setExtinct();
        miscProperties.setVersion(Versions.VERSION_5);
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<AlbertosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addHuntTargets(class_1657.class, class_3988.class, class_1429.class, class_1588.class, GoatEntity.class, DryosaurusEntity.class, OstrichEntity.class, ApatosaurusEntity.class, TriceratopsEntity.class, VelociraptorEntity.class, DilophosaurusEntity.class, DilophosaurusEntity.class, GallimimusEntity.class, HadrosaurusEntity.class, ParasaurolophusEntity.class, AlligatorEntity.class, CearadactylusEntity.class, MeganeuraEntity.class, MosquitoEntity.class, ReedFrogEntity.class, StegosaurusEntity.class, TroodonEntity.class, AchillobatorEntity.class, MetriacanthosaurusEntity.class, MicroceratusEntity.class, StyracosaurusEntity.class, EuoplocephalusEntity.class, LudodactylusEntity.class, ProceratosaurusEntity.class, OthnielaEntity.class, MaiasauraEntity.class, CoelurusEntity.class, ProtoceratopsEntity.class, HerrerasaurusEntity.class, DracovenatorEntity.class, CorythosaurusEntity.class, CeratosaurusEntity.class, SpinosaurusEntity.class);
        socialGroupProperties.addHerdTargets(AlbertosaurusEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(900.0f);
        socialGroupProperties.setMinDistanceToPackLeader(400.0f);
        socialGroupProperties.setMaxHerdSize(5);
        socialGroupProperties.setNaturalAggression(0.5f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<AlbertosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.OSTRICH);
        itemProperties.setSpawnEggColors(13547662, 3813404);
        itemProperties.setSpawnEggColorsMale(3813414, 8999461);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<AlbertosaurusEntity> attributes, EntityBaseProperties<AlbertosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setMaxTurnRate(25.0);
        base.setSizeDimorphism(90.0);
        base.setRenderScale(2.0);
        base.setLocator((ResourceLocator)new JSAnimalBaseLocator<AlbertosaurusEntity>(this){

            @Override
            public class_2960 getTextureLocation(AlbertosaurusEntity entity) {
                JSVariants.JSVariant variant;
                class_2561 customName = entity.method_5797();
                if (customName != null && customName.getString().toLowerCase(Locale.ROOT).contains("cyclops") && entity.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT && (variant = JSVariants.fromLocation((String)entity.method_5841().method_12789(JSEntityDataHolder.textureVariant))) == JSVariants.FOREST) {
                    Object key = this.makeCacheKey(entity, "texture_cyclops");
                    if (entity.method_16914()) {
                        key = (String)key + "|name=" + entity.method_5797().getString().toLowerCase(Locale.ROOT);
                    }
                    try {
                        return (class_2960)this.cache.get(key, () -> this.buildTextureLocation(entity));
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                return super.getTextureLocation(entity);
            }

            @Override
            protected class_2960 buildTextureLocation(AlbertosaurusEntity entity) {
                class_2561 customName = entity.method_5797();
                if (customName != null && customName.getString().toLowerCase(Locale.ROOT).contains("cyclops")) {
                    JSVariants.JSVariant variant;
                    String entity_name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
                    if (entity.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT && (variant = JSVariants.fromLocation((String)entity.method_5841().method_12789(JSEntityDataHolder.textureVariant))) == JSVariants.FOREST) {
                        return class_2960.method_60655((String)JSVariants.FOREST.location().method_12836(), (String)("textures/geo/animal/v1.0/" + entity_name + "/variants/" + entity_name + "_adult_forest_secret.png"));
                    }
                }
                return super.buildTextureLocation(entity);
            }
        });
        base.setBabyAnimations();
        base.setTurnSmoothRate(0.25);
        attributes.setPersistent();
        attributes.setEntityFactory(AlbertosaurusEntity::new);
        attributes.setEyeHeight((double)0.95f);
        attributes.setCategory(class_1311.field_6294);
        attributes.setMaxHealth(120.0);
        attributes.setDimensions(3.0, 6.0);
        attributes.setTrackingRange(64.0);
        attributes.setMovementSpeed(JSUtils.kmhToSpeed(23.0));
        attributes.setWaterEfficiency(1.0);
        attributes.setSwimmingSpeedMultiplier((double)1.3f);
        attributes.setRunningSpeedMultiplier(2.25);
        attributes.setAttackDamage(30.0);
        attributes.setAttackSpeed(4.0);
        attributes.setAttackKnockback(1.0);
        attributes.setFollowRange(64.0);
    }
}

