/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v5.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.entity.extant.BonitoEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic.MesolimulusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic.TylosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DryosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.GallimimusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ProcompsognathusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CallovosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CoelurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CompsognathusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MicroceratusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.OthnielaEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProceratosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProtoceratopsEntity;
import jp.jurassicsaga.server.v5.animal.animations.extinct.terrestial.DeinosuchusAnimations;
import jp.jurassicsaga.server.v5.animal.entity.extinct.terrestial.DeinosuchusEntity;
import net.minecraft.class_1311;
import net.minecraft.class_1422;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class DeinosuchusAnimal
extends AbstractJSAnimal<DeinosuchusEntity> {
    public DeinosuchusAnimal() {
        super("deinosuchus");
        this.setAnimator(new DeinosuchusAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<DeinosuchusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(0.5f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.5f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(5.0f));
        geneticProperties.setSpawnGeneticsDefault();
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<DeinosuchusEntity> metabolismProperties) {
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
        metabolismProperties.disableFood();
        metabolismProperties.disableWater();
        metabolismProperties.setDiet(AnimalDietType.CARNIVORE, () -> Diets.CARNIVORE.get().add(Diets.PISCIVORE.get()));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<DeinosuchusEntity> miscProperties) {
        miscProperties.setEra(Era.NONE);
        miscProperties.setBabyAnimations();
        miscProperties.setGenderedVariants();
        miscProperties.setExtinct();
        miscProperties.setVersion(Versions.VERSION_5);
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<DeinosuchusEntity> socialGroupProperties) {
        socialGroupProperties.addHuntTargets(class_1657.class, MesolimulusEntity.class, class_1422.class, class_1429.class, GoatEntity.class, OstrichEntity.class, GallimimusEntity.class, DryosaurusEntity.class, ProcompsognathusEntity.class, BonitoEntity.class, ProceratosaurusEntity.class, OthnielaEntity.class, CompsognathusEntity.class, MicroceratusEntity.class, CoelurusEntity.class, CallovosaurusEntity.class, ProtoceratopsEntity.class);
        socialGroupProperties.addScaredOf(TylosaurusEntity.class);
        socialGroupProperties.addHerdTargets(DeinosuchusEntity.class);
        socialGroupProperties.setMaxHerdSize(6);
        socialGroupProperties.enableNesting();
        socialGroupProperties.setNaturalAggression(1.0f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<DeinosuchusEntity> itemProperties) {
        itemProperties.enableCoin();
        itemProperties.disableMeat();
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(9666105, 5193756);
        itemProperties.setSpawnEggColorsMale(7101988, 2958618);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<DeinosuchusEntity> attributes, EntityBaseProperties<DeinosuchusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setSizeClass(AnimalSizeClass.MEDIUM);
        base.setMaxTurnRate(13.0);
        base.setTurnSmoothRate((double)0.4f);
        base.setMaxHeadRotation(25.0, 30.0);
        base.setRenderScale((double)1.85f);
        base.setLocator(new JSAnimalBaseLocator());
        base.setSizeDimorphism(150.0);
        attributes.setEntityFactory(DeinosuchusEntity::new);
        attributes.setCategory(class_1311.field_6300);
        attributes.setEyeHeight((double)0.8f);
        attributes.setMaxHealth(18.0);
        attributes.setAttackDamage(16.0);
        attributes.setAttackSpeed(1.0);
        attributes.setDimensions(3.0, (double)1.8f);
        attributes.setMovementSpeed((double)0.16f);
        attributes.setRunningSpeedMultiplier((double)1.2f);
        attributes.setSwimmingSpeedMultiplier((double)1.6f);
        attributes.setWaterEfficiency(1.0);
    }
}

