/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.render.animal.azure;

import mod.azure.azurelib.common.model.AzBakedModel;
import mod.azure.azurelib.common.render.AzRendererConfig;
import mod.azure.azurelib.common.render.AzRendererPipeline;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;

public abstract class TravelersAzContext<K, T>
extends AzRendererPipelineContext<K, T> {
    private final AzRendererPipeline<K, T> rendererPipeline;
    private AzBakedModel bakedModel;
    private class_4597 multiBufferSource;
    private int packedLight;
    private int packedOverlay;
    private float partialTick;
    private class_4587 poseStack;
    private int renderColor;
    @Nullable
    private class_1921 renderType;
    private class_4588 vertexConsumer;

    protected TravelersAzContext(AzRendererPipeline<K, T> rendererPipeline) {
        super(null);
        this.rendererPipeline = rendererPipeline;
    }

    public void populate(T animatable, AzBakedModel bakedModel, class_4597 multiBufferSource, int packedLight, float partialTick, class_4587 poseStack, class_1921 renderType, class_4588 vertexConsumer) {
        this.animatable = animatable;
        this.bakedModel = bakedModel;
        this.multiBufferSource = multiBufferSource;
        this.packedLight = packedLight;
        this.packedOverlay = this.getPackedOverlay(animatable, 0.0f, partialTick);
        this.partialTick = partialTick;
        this.poseStack = poseStack;
        if (vertexConsumer != null) {
            this.vertexConsumer = vertexConsumer;
        }
        this.renderColor = this.getRenderColor(animatable, partialTick, packedLight).argbInt();
        if (renderType == null) {
            AzRendererConfig cfg = this.rendererPipeline.config();
            class_2960 texture = cfg.textureLocation(this.currentEntity, animatable);
            this.renderType = this.getDefaultRenderType(animatable, texture, multiBufferSource, partialTick, cfg.getRenderType(this.currentEntity, animatable), cfg.alpha(animatable));
        } else {
            if (this.renderType != renderType) {
                this.vertexConsumer = null;
            }
            this.renderType = renderType;
        }
        if (this.vertexConsumer == null && this.renderType != null) {
            this.vertexConsumer = multiBufferSource.getBuffer(this.renderType);
        }
    }

    public AzRendererPipeline<K, T> rendererPipeline() {
        return this.rendererPipeline;
    }

    public T animatable() {
        return (T)this.animatable;
    }

    public void setCurrentEntity(class_1297 currentEntity) {
        this.currentEntity = currentEntity;
    }

    @Nullable
    public class_1297 currentEntity() {
        return this.currentEntity;
    }

    public AzBakedModel bakedModel() {
        return this.bakedModel;
    }

    public class_4597 multiBufferSource() {
        return this.multiBufferSource;
    }

    public int packedLight() {
        return this.packedLight;
    }

    public void setPackedLight(int packedLight) {
        this.packedLight = packedLight;
    }

    public int packedOverlay() {
        return this.packedOverlay;
    }

    public void setPackedOverlay(int packedOverlay) {
        this.packedOverlay = packedOverlay;
    }

    public float partialTick() {
        return this.partialTick;
    }

    public class_4587 poseStack() {
        return this.poseStack;
    }

    public int renderColor() {
        return this.renderColor;
    }

    public void setRenderColor(int renderColor) {
        this.renderColor = renderColor;
    }

    @Nullable
    public class_1921 renderType() {
        return this.renderType;
    }

    public void setRenderType(@Nullable class_1921 renderType) {
        this.renderType = renderType;
    }

    public class_4588 vertexConsumer() {
        return this.vertexConsumer;
    }

    public void setVertexConsumer(class_4588 vertexConsumer) {
        this.vertexConsumer = vertexConsumer;
    }

    public class_2960 getTextureOverride() {
        return this.textureOverride;
    }
}

