/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersBinaryHeap;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersPathFinder {
    private static final ThreadLocal<TravelersNode[]> THREAD_NEIGHBORS = ThreadLocal.withInitial(() -> new TravelersNode[64]);
    private static final int BASE_MAX_VISITED_NODES = 300;
    private final TravelersNodeEvaluator nodeEvaluator;

    public TravelersPathFinder(TravelersNodeEvaluator evaluator) {
        this.nodeEvaluator = evaluator;
    }

    @Nullable
    public CompletableFuture<TravelersPath> findPathAsync(class_1950 region, SmartAnimalBase mob, Set<class_2338> targets, float maxRange, int accuracy, float depthMul) {
        return CompletableFuture.supplyAsync(() -> this.findPath(region, mob, targets, maxRange, accuracy, depthMul));
    }

    @Nullable
    public TravelersPath findPath(class_1950 region, SmartAnimalBase mob, Set<class_2338> targets, float maxRange, int accuracy, float depthMul) {
        TravelersNodeEvaluator evaluator = this.nodeEvaluator.copy();
        TravelersBinaryHeap openSet = new TravelersBinaryHeap();
        ArrayList<TravelersTarget> targetList = new ArrayList<TravelersTarget>(targets.size());
        HashSet<TravelersTarget> reached = new HashSet<TravelersTarget>(targets.size());
        evaluator.prepare(region, mob);
        TravelersNode start = evaluator.getStart();
        if (start == null) {
            evaluator.done();
            return null;
        }
        for (class_2338 pos : targets) {
            TravelersTarget t = evaluator.getTarget(pos.method_10263(), pos.method_10264(), pos.method_10260());
            t.setTargetPos(pos);
            targetList.add(t);
        }
        int maxVisitedNodes = Math.max(100, (int)(300.0f * Math.max(0.5f, depthMul)));
        TravelersPath result = this.findPathInternal(evaluator, openSet, reached, targetList, start, maxRange, accuracy, maxVisitedNodes);
        evaluator.done();
        return result;
    }

    @Nullable
    private TravelersPath findPathInternal(TravelersNodeEvaluator nodeEvaluator, TravelersBinaryHeap openSet, Set<TravelersTarget> reached, List<TravelersTarget> targetList, TravelersNode start, float maxRange, int accuracy, int maxVisitedNodes) {
        TravelersNode[] neighbors = THREAD_NEIGHBORS.get();
        start.g = 0.0f;
        start.walkedDistance = 0.0f;
        start.f = start.h = this.getBestH(targetList, start);
        start.cameFrom = null;
        start.closed = false;
        openSet.insert(start);
        int visits = 0;
        while (!openSet.isEmpty() && visits++ < maxVisitedNodes) {
            TravelersNode current = openSet.pop();
            current.closed = true;
            for (TravelersTarget target : targetList) {
                if (target.isReached() || !(current.distanceManhattan(target) < (float)accuracy)) continue;
                target.setReached(true);
                reached.add(target);
            }
            if (!reached.isEmpty()) break;
            float distFromStart = current.distanceTo(start);
            if (distFromStart >= maxRange) continue;
            int neighborCount = nodeEvaluator.getNeighbors(neighbors, current);
            for (int i = 0; i < neighborCount; ++i) {
                TravelersNode neighbor = neighbors[i];
                if (neighbor.closed) continue;
                float stepCost = current.distanceTo(neighbor);
                float totalG = current.g + stepCost + neighbor.costMalus;
                if (neighbor.walkedDistance >= maxRange || neighbor.inOpenSet() && totalG >= neighbor.g - 1.0E-6f) continue;
                neighbor.walkedDistance = current.walkedDistance + stepCost;
                neighbor.cameFrom = current;
                neighbor.g = totalG;
                neighbor.h = this.getBestH(targetList, neighbor) * 1.5f;
                neighbor.f = neighbor.g + neighbor.h;
                if (neighbor.inOpenSet()) {
                    openSet.changeCost(neighbor, neighbor.f);
                    continue;
                }
                openSet.insert(neighbor);
            }
        }
        return reached.isEmpty() ? this.getClosestUnreachedPath(targetList) : this.getBestReachedPath(reached);
    }

    private float getBestH(List<TravelersTarget> targets, TravelersNode node) {
        float bestSq = Float.MAX_VALUE;
        for (TravelersTarget t : targets) {
            float dx = node.x - t.x;
            float dy = node.y - t.y;
            float dz = node.z - t.z;
            float distSq = dx * dx + dy * dy + dz * dz;
            if (distSq < bestSq) {
                bestSq = distSq;
            }
            float dist = (float)Math.sqrt(distSq);
            t.updateBest(dist, node);
        }
        return (float)Math.sqrt(bestSq);
    }

    @Nullable
    private TravelersPath getClosestUnreachedPath(List<TravelersTarget> targets) {
        TravelersPath best = null;
        int bestCount = Integer.MAX_VALUE;
        double bestDist = Double.MAX_VALUE;
        for (TravelersTarget target : targets) {
            TravelersPath path;
            TravelersNode bestNode = target.getBestNode();
            if (bestNode == null || (path = this.reconstructPath(bestNode, target.getTargetPos(), false)) == null) continue;
            double dist = path.getDistToTarget();
            int count = path.getNodeCount();
            if (!(dist < bestDist) && (dist != bestDist || count >= bestCount)) continue;
            best = path;
            bestDist = dist;
            bestCount = count;
        }
        return best;
    }

    @Nullable
    private TravelersPath getBestReachedPath(Set<TravelersTarget> reached) {
        TravelersPath best = null;
        int bestCount = Integer.MAX_VALUE;
        for (TravelersTarget target : reached) {
            int count;
            TravelersPath path;
            TravelersNode bestNode = target.getBestNode();
            if (bestNode == null || (path = this.reconstructPath(bestNode, target.getTargetPos(), true)) == null || (count = path.getNodeCount()) >= bestCount) continue;
            best = path;
            bestCount = count;
        }
        return best;
    }

    @Nullable
    private TravelersPath reconstructPath(TravelersNode end, class_2338 target, boolean reachesTarget) {
        if (end == null) {
            return null;
        }
        ArrayList<TravelersNode> nodes = new ArrayList<TravelersNode>();
        TravelersNode n = end;
        while (n != null) {
            nodes.add(n);
            n = n.cameFrom;
        }
        Collections.reverse(nodes);
        return new TravelersPath(nodes, target, reachesTarget);
    }
}

