/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.control;

import net.minecraft.class_1297;
import net.minecraft.class_3532;
import net.minecraft.class_6035;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersMoveControl
implements class_6035 {
    protected final float maxTurn;
    protected final float turnSmoothRate;
    protected final SmartAnimalBase mob;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected double speedModifier;
    protected Operation operation = Operation.WAIT;

    public TravelersMoveControl(SmartAnimalBase pMob, TravelersAnimal<?> animal) {
        this.mob = pMob;
        this.maxTurn = (float)animal.getAnimalAttributes().getEntityBaseProperties().getMaxTurnRate();
        this.turnSmoothRate = (float)animal.getAnimalAttributes().getEntityBaseProperties().getTurnSmoothRate();
    }

    public void setWantedPosition(double x, double y, double z, double speed) {
        this.wantedX = x;
        this.wantedY = y;
        this.wantedZ = z;
        this.speedModifier = speed;
        if (this.operation != Operation.JUMPING) {
            this.operation = Operation.MOVE_TO;
        }
    }

    public void tick() {
        switch (this.operation.ordinal()) {
            case 1: {
                this.handleMoveTo();
                break;
            }
            case 2: {
                this.handleJumping();
                break;
            }
            default: {
                this.mob.method_5930(0.0f);
            }
        }
    }

    protected void handleMoveTo() {
        double dz;
        double dy;
        double dx = this.wantedX - this.mob.method_23317();
        double distSq = dx * dx + (dy = this.wantedY - this.mob.method_23318()) * dy + (dz = this.wantedZ - this.mob.method_23321()) * dz;
        if (distSq < 2.5E-7) {
            this.mob.method_5930(0.0f);
            this.operation = Operation.WAIT;
            return;
        }
        float targetAngle = (float)(class_3532.method_15349((double)dz, (double)dx) * 180.0 / Math.PI) - 90.0f;
        this.mob.method_36456(this.rotlerp(this.mob.method_36454(), targetAngle, this.getTurnSpeed()));
        this.mob.method_5636(this.mob.method_36454());
        this.mob.method_6125((float)(this.speedModifier * (double)this.mob.method_6029()));
        if (this.shouldJump(dy, dx, dz)) {
            this.mob.method_5993().method_6233();
            this.operation = Operation.JUMPING;
        }
    }

    protected void handleJumping() {
        this.mob.method_6125((float)(this.speedModifier * (double)this.mob.method_6029()));
        if (this.mob.method_24828()) {
            this.operation = Operation.WAIT;
        }
    }

    protected boolean shouldJump(double dy, double dx, double dz) {
        double dist = this.mob.method_5649(this.mob.method_23317() + dx, this.mob.method_23318(), this.mob.method_23321() + dz);
        if (dist < (double)(this.mob.method_17681() * 1.1f)) {
            boolean collides;
            boolean bl = collides = !this.mob.method_37908().method_52569((class_1297)this.mob, this.mob.method_5829().method_1012(0.0, dy, 0.0));
            if (collides) {
                return false;
            }
            return dy > (double)this.mob.method_49476() && dy <= this.mob.jumpHeight();
        }
        return false;
    }

    protected float rotlerp(float from, float to, float maxTurn) {
        float delta = class_3532.method_15393((float)(to - from));
        float limited = class_3532.method_15363((float)delta, (float)(-maxTurn), (float)maxTurn);
        return from + limited;
    }

    protected float getTurnSpeed() {
        float v = this.maxTurn;
        float mult = this.mob.getTurnMultiplier();
        if (mult > 0.0f && mult != 1.0f) {
            v *= mult;
        }
        return v;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public static enum Operation {
        WAIT,
        MOVE_TO,
        JUMPING;

    }
}

