/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import net.minecraft.class_10;
import net.minecraft.class_1922;
import net.minecraft.class_1941;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersSwimNodeEvaluator
extends TravelersNodeEvaluator {
    private final boolean allowBreaching;
    private final Long2ObjectMap<TravelersPathType> pathTypeCache = new Long2ObjectOpenHashMap();
    private final class_2338.class_2339 temp = new class_2338.class_2339();

    public TravelersSwimNodeEvaluator(boolean allowBreaching) {
        this.allowBreaching = allowBreaching;
    }

    private static boolean hasMalus(@Nullable TravelersNode node) {
        return node != null && node.costMalus >= 0.0f;
    }

    @Override
    public TravelersNodeEvaluator copy() {
        TravelersSwimNodeEvaluator nodeEvaluator = new TravelersSwimNodeEvaluator(this.allowBreaching);
        this.applyDefaultProperties(nodeEvaluator);
        return nodeEvaluator;
    }

    @Override
    public void prepare(@NotNull class_1950 level, @NotNull SmartAnimalBase mob) {
        super.prepare(level, mob);
        this.pathTypeCache.clear();
    }

    @Override
    public void done() {
        super.done();
        this.pathTypeCache.clear();
    }

    @Override
    @NotNull
    public TravelersNode getStart() {
        class_238 box = this.mob.method_5829();
        double cx = (box.field_1323 + box.field_1320) * 0.5;
        double cy = (box.field_1322 + box.field_1325) * 0.5;
        double cz = (box.field_1321 + box.field_1324) * 0.5;
        int y = class_3532.method_15357((double)cy);
        this.temp.method_10102(cx, (double)y, cz);
        class_2680 state = this.context.getBlockState((class_2338)this.temp);
        if (!state.method_26227().method_39360((class_3611)class_3612.field_15910)) {
            boolean found = false;
            for (int dy = 1; dy <= 6; ++dy) {
                if (this.context.getBlockState((class_2338)this.temp.method_10102(cx, (double)(y - dy), cz)).method_26227().method_39360((class_3611)class_3612.field_15910)) {
                    y -= dy;
                    found = true;
                    break;
                }
                if (!this.context.getBlockState((class_2338)this.temp.method_10102(cx, (double)(y + dy), cz)).method_26227().method_39360((class_3611)class_3612.field_15910)) continue;
                y += dy;
                found = true;
                break;
            }
            if (!found) {
                y = class_3532.method_15357((double)this.mob.method_23318());
            }
        }
        this.temp.method_33098(y);
        return this.getNode((class_2338)this.temp);
    }

    @Override
    @NotNull
    public TravelersTarget getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y, z);
    }

    @Override
    public int getNeighbors(TravelersNode @NotNull [] outputArray, @NotNull TravelersNode current) {
        int i = 0;
        EnumMap<class_2350, TravelersNode> neighbors = new EnumMap<class_2350, TravelersNode>(class_2350.class);
        for (class_2350 dir : class_2350.values()) {
            TravelersNode n = this.findAcceptedNode(current.x + dir.method_10148(), current.y + dir.method_10164(), current.z + dir.method_10165());
            neighbors.put(dir, n);
            if (!this.isNodeValid(n)) continue;
            outputArray[i++] = n;
        }
        for (class_2350 dir1 : class_2350.class_2353.field_11062) {
            TravelersNode diag;
            class_2350 dir2 = dir1.method_10170();
            if (!TravelersSwimNodeEvaluator.hasMalus((TravelersNode)neighbors.get(dir1)) || !TravelersSwimNodeEvaluator.hasMalus((TravelersNode)neighbors.get(dir2)) || !this.isNodeValid(diag = this.findAcceptedNode(current.x + dir1.method_10148() + dir2.method_10148(), current.y, current.z + dir1.method_10165() + dir2.method_10165()))) continue;
            outputArray[i++] = diag;
        }
        return i;
    }

    protected boolean isNodeValid(@Nullable TravelersNode node) {
        return node != null && !node.closed;
    }

    @Nullable
    protected TravelersNode findAcceptedNode(int x, int y, int z) {
        TravelersPathType type = this.getCachedBlockType(x, y, z);
        if (!this.allowBreaching && type != TravelersPathType.WATER && type != TravelersPathType.BREACH) {
            return null;
        }
        float malus = this.mob.getPathfindingMalus(type);
        if (malus < 0.0f) {
            return null;
        }
        TravelersNode node = this.getNode(x, y, z);
        node.type = type;
        node.costMalus = Math.max(node.costMalus, malus);
        class_1941 level = this.context.level();
        this.temp.method_10103(x, y, z);
        class_2680 state = level.method_8320((class_2338)this.temp);
        if (!state.method_26220((class_1922)level, (class_2338)this.temp).method_1110()) {
            return null;
        }
        if (level.method_8316((class_2338)this.temp).method_15769()) {
            node.costMalus += 8.0f;
        }
        if (!this.makeSureYFits(x, y, z)) {
            return null;
        }
        if (!this.canMobStandAt(x, y, z)) {
            return null;
        }
        return node;
    }

    protected boolean canMobStandAt(int x, int y, int z) {
        int half = Math.max(1, class_3532.method_15386((float)((float)this.entityHeight / 2.0f)) / 2);
        for (int i = -half; i < half; ++i) {
            if (!this.isSpaceValidForStanding(x, y + i, z)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSpaceValidForStanding(int x, int y, int z) {
        class_238 box = this.mob.method_5829();
        double width = box.method_17939();
        double height = box.method_17940();
        double depth = box.method_17941();
        double cx = (double)x + 0.5;
        double cz = (double)z + 0.5;
        int minX = class_3532.method_15357((double)(cx - width / 2.0));
        int maxX = class_3532.method_15384((double)(cx + width / 2.0));
        int maxY = class_3532.method_15384((double)((double)y + height));
        int minZ = class_3532.method_15357((double)(cz - depth / 2.0));
        int maxZ = class_3532.method_15384((double)(cz + depth / 2.0));
        for (int xi = minX; xi < maxX; ++xi) {
            for (int yi = y; yi < maxY; ++yi) {
                for (int zi = minZ; zi < maxZ; ++zi) {
                    TravelersPathType type = this.getPathType(this.context, xi, yi, zi);
                    if (type == TravelersPathType.OPEN || type == TravelersPathType.WATER || type == TravelersPathType.WATER_BORDER) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean makeSureYFits(int x, int y, int z) {
        double height = this.mob.method_17682();
        int maxY = class_3532.method_15384((double)((double)y + height));
        for (int yi = y; yi < maxY; ++yi) {
            TravelersPathType type = this.getPathType(this.context, x, yi, z);
            if (type == TravelersPathType.WALKABLE || type == TravelersPathType.OPEN || type == TravelersPathType.WATER || type == TravelersPathType.WATER_BORDER) continue;
            return false;
        }
        return true;
    }

    protected TravelersPathType getCachedBlockType(int x, int y, int z) {
        long key = class_2338.method_10064((int)x, (int)y, (int)z);
        TravelersPathType cached = (TravelersPathType)((Object)this.pathTypeCache.get(key));
        if (cached != null) {
            return cached;
        }
        TravelersPathType computed = this.getPathType(this.context, x, y, z);
        this.pathTypeCache.put(key, (Object)computed);
        return computed;
    }

    @Override
    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext context, int x, int y, int z) {
        return this.getPathTypeOfMob(context, x, y, z, this.mob);
    }

    @Override
    @NotNull
    public TravelersPathType getPathTypeOfMob(@NotNull TravelersPathfindingContext context, int x, int y, int z, @NotNull SmartAnimalBase mob) {
        this.temp.method_10103(x, y, z);
        class_2680 state = context.getBlockState((class_2338)this.temp);
        class_3610 fluid = state.method_26227();
        if (fluid.method_15769() && state.method_26171(class_10.field_48) && state.method_26215()) {
            return TravelersPathType.BREACH;
        }
        return state.method_26171(class_10.field_48) ? TravelersPathType.WATER : TravelersPathType.BREACH;
    }
}

