/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.vanilla;

import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.vanilla.TLGoalUtils;
import travelers.server.animal.entity.pathingsystem.vanilla.TLRandomPos;

public class TLHoverRandomPos {
    private static final Random rng = new Random();

    @Nullable
    public static class_243 getPos(SmartAnimalBase mob, int radius, int yRange, double x, double z, float angleVarianceRadians, int maxSwimUp, int minSwimUp) {
        boolean restricted = TLGoalUtils.mobRestricted(mob, radius);
        return TLRandomPos.generateBestRandomPos(() -> {
            class_2338 direction = TLRandomPos.generateRandomDirectionWithinRadians(radius, yRange, 0, x, z, angleVarianceRadians);
            if (direction == null) {
                return null;
            }
            class_2338 toward = TLHoverRandomPos.generateValidTarget(mob, radius, restricted, direction);
            if (toward == null) {
                return null;
            }
            int swimUpAmount = rng.nextInt(maxSwimUp - minSwimUp + 1) + minSwimUp;
            class_2338 elevated = TLRandomPos.moveUpToAboveSolid(toward, swimUpAmount, mob.method_37908().method_31600(), pos -> TLGoalUtils.isSolid(mob, pos));
            return TLHoverRandomPos.isValidFinalHoverTarget(mob, elevated) ? elevated : null;
        }, arg_0 -> ((SmartAnimalBase)mob).method_6149(arg_0));
    }

    @Nullable
    private static class_2338 generateValidTarget(SmartAnimalBase mob, int radius, boolean restricted, class_2338 offset) {
        class_2338 candidate = TLRandomPos.generateRandomPosTowardDirection(mob, radius, offset);
        return candidate != null && !TLGoalUtils.isOutsideLimits(candidate, mob) && !TLGoalUtils.isRestricted(restricted, mob, candidate) && !TLGoalUtils.isNotStable(mob.getNavigationController(), candidate) ? candidate : null;
    }

    private static boolean isValidFinalHoverTarget(SmartAnimalBase mob, class_2338 pos) {
        return !TLGoalUtils.isWater(mob, pos) && !TLGoalUtils.hasMalus(mob, pos);
    }
}

