/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.animation;

import mod.azure.azurelib.common.animation.controller.keyframe.AzAnimationPoint;
import mod.azure.azurelib.common.animation.controller.keyframe.AzBoneAnimationQueue;
import mod.azure.azurelib.common.animation.easing.AzEasingType;
import mod.azure.azurelib.common.animation.easing.AzEasingUtil;
import mod.azure.azurelib.common.model.AzBone;
import mod.azure.azurelib.common.model.AzBoneSnapshot;

public class AzBoneAnimationUpdateUtil {
    public static void updatePositions(AzBoneAnimationQueue boneAnimation, AzBone bone, AzEasingType easingType, AzBoneSnapshot snapshot) {
        AzAnimationPoint posXPoint = boneAnimation.positionXQueue().poll();
        AzAnimationPoint posYPoint = boneAnimation.positionYQueue().poll();
        AzAnimationPoint posZPoint = boneAnimation.positionZQueue().poll();
        if (posXPoint != null && posYPoint != null && posZPoint != null) {
            bone.setPosX((float)AzEasingUtil.lerpWithOverride(posXPoint, easingType));
            bone.setPosY((float)AzEasingUtil.lerpWithOverride(posYPoint, easingType));
            bone.setPosZ((float)AzEasingUtil.lerpWithOverride(posZPoint, easingType));
            snapshot.updateOffset(bone.getPosX(), bone.getPosY(), bone.getPosZ());
            snapshot.startPosAnim();
            bone.markPositionAsChanged();
        }
    }

    public static void updateRotations(AzBoneAnimationQueue boneAnimation, AzBone bone, AzEasingType easingType, AzBoneSnapshot initialSnapshot, AzBoneSnapshot snapshot) {
        AzAnimationPoint rotXPoint = boneAnimation.rotationXQueue().poll();
        AzAnimationPoint rotYPoint = boneAnimation.rotationYQueue().poll();
        AzAnimationPoint rotZPoint = boneAnimation.rotationZQueue().poll();
        if (rotXPoint != null && rotYPoint != null && rotZPoint != null) {
            bone.setRotX((float)AzEasingUtil.lerpWithOverride(rotXPoint, easingType) + initialSnapshot.getRotX());
            bone.setRotY((float)AzEasingUtil.lerpWithOverride(rotYPoint, easingType) + initialSnapshot.getRotY());
            bone.setRotZ((float)AzEasingUtil.lerpWithOverride(rotZPoint, easingType) + initialSnapshot.getRotZ());
            snapshot.updateRotation(bone.getRotX(), bone.getRotY(), bone.getRotZ());
            snapshot.startRotAnim();
            bone.markRotationAsChanged();
        }
    }

    public static void updateScale(AzBoneAnimationQueue boneAnimation, AzBone bone, AzEasingType easingType, AzBoneSnapshot snapshot) {
        AzAnimationPoint scaleXPoint = boneAnimation.scaleXQueue().poll();
        AzAnimationPoint scaleYPoint = boneAnimation.scaleYQueue().poll();
        AzAnimationPoint scaleZPoint = boneAnimation.scaleZQueue().poll();
        if (scaleXPoint != null && scaleYPoint != null && scaleZPoint != null) {
            bone.setScaleX((float)AzEasingUtil.lerpWithOverride(scaleXPoint, easingType));
            bone.setScaleY((float)AzEasingUtil.lerpWithOverride(scaleYPoint, easingType));
            bone.setScaleZ((float)AzEasingUtil.lerpWithOverride(scaleZPoint, easingType));
            snapshot.updateScale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
            snapshot.startScaleAnim();
            bone.markScaleAsChanged();
        }
    }
}

