/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.animation.property;

import java.util.Objects;
import mod.azure.azurelib.common.animation.easing.AzEasingType;
import mod.azure.azurelib.common.animation.easing.AzEasingTypes;
import mod.azure.azurelib.common.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelib.common.animation.play_behavior.AzPlayBehaviors;
import mod.azure.azurelib.common.animation.property.AzAnimationProperties;
import mod.azure.azurelib.common.animation.property.codec.AzAnimationStagePropertiesCodec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzAnimationStageProperties
extends AzAnimationProperties {
    public static final AzAnimationStagePropertiesCodec CODEC = new AzAnimationStagePropertiesCodec();
    public static final AzAnimationStageProperties DEFAULT = new AzAnimationStageProperties(1.0, AzEasingTypes.NONE, AzPlayBehaviors.PLAY_ONCE, Float.valueOf(0.0f), 0.0, 0.0, 1.0, false);
    public static final AzAnimationStageProperties EMPTY = new AzAnimationStageProperties(null, null, null, null, null, null, null, null);
    private AzPlayBehavior playBehavior;

    public AzAnimationStageProperties(@Nullable Double animationSpeed, @Nullable AzEasingType easingType, @Nullable AzPlayBehavior playBehavior, @Nullable Float transitionLength, @Nullable Double startTickOffset, @Nullable Double freezeTickOffset, @Nullable Double repeatXTimes, @Nullable Boolean isReversing) {
        super(animationSpeed, easingType, transitionLength, startTickOffset, freezeTickOffset, repeatXTimes, isReversing);
        this.playBehavior = playBehavior;
        this.startTickOffset = startTickOffset;
    }

    public boolean hasPlayBehavior() {
        return this.playBehavior != null;
    }

    @Override
    public AzAnimationStageProperties withAnimationSpeed(double animationSpeed) {
        this.animationSpeed = animationSpeed;
        return new AzAnimationStageProperties(animationSpeed, this.easingType, this.playBehavior, this.transitionLength, this.startTickOffset, this.freezeTickOffset, this.repeatXTimes, this.isReversing);
    }

    @Override
    public AzAnimationStageProperties withEasingType(@NotNull AzEasingType easingType) {
        this.easingType = easingType;
        return new AzAnimationStageProperties(this.animationSpeed, easingType, this.playBehavior, this.transitionLength, this.startTickOffset, this.freezeTickOffset, this.repeatXTimes, this.isReversing);
    }

    public AzAnimationStageProperties withPlayBehavior(@NotNull AzPlayBehavior playBehavior) {
        this.playBehavior = playBehavior;
        return new AzAnimationStageProperties(this.animationSpeed, this.easingType, playBehavior, this.transitionLength, this.startTickOffset, this.freezeTickOffset, this.repeatXTimes, this.isReversing);
    }

    @Override
    public AzAnimationStageProperties withTransitionLength(float transitionLength) {
        this.transitionLength = Float.valueOf(transitionLength);
        return new AzAnimationStageProperties(this.animationSpeed, this.easingType, this.playBehavior, Float.valueOf(transitionLength), this.startTickOffset, this.freezeTickOffset, this.repeatXTimes, this.isReversing);
    }

    @Override
    public AzAnimationStageProperties withStartTickOffset(double startTickOffset) {
        this.startTickOffset = startTickOffset;
        return new AzAnimationStageProperties(this.animationSpeed, this.easingType, this.playBehavior, this.transitionLength, startTickOffset, this.freezeTickOffset, this.repeatXTimes, this.isReversing);
    }

    @Override
    public AzAnimationStageProperties withFreezeTickOffset(double freezeTickOffset) {
        this.freezeTickOffset = freezeTickOffset;
        return new AzAnimationStageProperties(this.animationSpeed, this.easingType, this.playBehavior, this.transitionLength, this.startTickOffset, freezeTickOffset, this.repeatXTimes, this.isReversing);
    }

    @Override
    public AzAnimationStageProperties withRepeatXTimes(double repeatXTimes) {
        this.repeatXTimes = repeatXTimes;
        return new AzAnimationStageProperties(this.animationSpeed, this.easingType, this.playBehavior, this.transitionLength, this.startTickOffset, this.freezeTickOffset, repeatXTimes, this.isReversing);
    }

    @Override
    public AzAnimationStageProperties withShouldReverse(boolean isReversing) {
        this.isReversing = isReversing;
        return new AzAnimationStageProperties(this.animationSpeed, this.easingType, this.playBehavior, this.transitionLength, this.startTickOffset, this.freezeTickOffset, this.repeatXTimes, isReversing);
    }

    public AzPlayBehavior playBehavior() {
        return this.playBehavior == null ? DEFAULT.playBehavior() : this.playBehavior;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AzAnimationStageProperties that = (AzAnimationStageProperties)object;
        return Objects.equals(this.playBehavior, that.playBehavior) && super.equals(object);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.playBehavior);
    }
}

