/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mod.azure.azurelib.common.config.ConfigHolder;
import mod.azure.azurelib.common.config.io.ConfigIO;

public final class ConfigHolderRegistry {
    private static final Map<String, ConfigHolder<?>> REGISTERED_CONFIGS = new HashMap();

    private ConfigHolderRegistry() {
        throw new UnsupportedOperationException();
    }

    public static void registerConfig(ConfigHolder<?> holder) {
        REGISTERED_CONFIGS.put(holder.getConfigId(), holder);
        ConfigIO.processConfig(holder);
    }

    public static <C> Optional<ConfigHolder<C>> getConfig(String id) {
        return Optional.ofNullable(REGISTERED_CONFIGS.get(id));
    }

    public static Map<String, List<ConfigHolder<?>>> getConfigGroupingByGroup() {
        return REGISTERED_CONFIGS.values().stream().collect(Collectors.groupingBy(ConfigHolder::getGroup));
    }

    public static List<ConfigHolder<?>> getConfigsByGroup(String group) {
        return REGISTERED_CONFIGS.values().stream().filter(configHolder -> configHolder.getGroup().equals(group)).toList();
    }

    public static Set<String> getSynchronizedConfigs() {
        return REGISTERED_CONFIGS.entrySet().stream().filter(e -> !((ConfigHolder)e.getValue()).getNetworkSerializedFields().isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

